require 'racc/parser'

#
# parsemail.rb
#
#   Copyright (c) 1998-2001 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'nkf'
require 'tmail/scanmail'


module TMail

  class Parser < ::Racc::Parser

module_eval <<'..end mp.y modeval..idf2036f5cfd', 'mp.y', 287

  def self.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && Racc_debug_parser
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  NATIVE_ROUTINE = {
    'TMail::MsgidH' => :msgid_parse,
    'TMail::RefH'   => :refs_parse
  }

  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    if mid = NATIVE_ROUTINE[ obj.type.name ] then
      __send__ mid, str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = Scanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]

      yyparse self, :parse_in
    end
  end

  private


  def parse_in( &block )
    yield @first
    @scanner.scan &block
  end
  
  def on_error( tok, val, vstack )
    raise MailSyntaxError,
          "\nparse error in '#{@field.name}:' on token #{val.inspect}"
  end


  def refs_parse( str )
    arr = []

    while mdata = ::TMail::MSGID.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      proc_phrase pre, arr unless pre.empty?
      arr.push mdata.to_s
    end
    str.strip!
    proc_phrase str, arr if not pre or pre.empty?

    @field.refs.replace arr
  end

  def proc_phrase( str, arr )
    while mdata = /"([^\\]*(?:\\.[^"\\]*)*)"/.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      arr.push pre unless pre.empty?
      arr.push mdata[1]
    end
    str.strip!
    arr.push str unless str.empty?
  end


  def msgid_parse( str )
    if mdata = ::TMail::MSGID.match( str ) then
      @field.msgid = mdata.to_s
    else
      raise MailSyntaxError, "wrong Message-ID format: #{str}"
    end
  end

  def decode_params( hash )
    tmp = nil
    hash.delete_if do |k,v|
      if m = /\*(?:(\d+)\*)?\z/.match(k) then
        ((tmp ||= {})[ m.pre_match ] ||= [])[ (m[1] || 0).to_i ] = v
        true
      else
        false
      end
    end
    if tmp then
      tmp.each do |k,v|
        hash[k] = decode_v( v.join('') )
      end
    end

    hash
  end

  VE_RE = /\A(?:iso-2022-jp|euc-jp|shift_jis|us-ascii)?'[a-z]*'/in

  def decode_v( str )
    if m = VE_RE.match(str) then
      NKF.nkf '-e', m.post_match.gsub( /%[\da-f]{2}/in ) {|s| s[1,2].hex.chr }
    else
      str
    end
  end

..end mp.y modeval..idf2036f5cfd

##### racc 1.3.11 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 2, 39, :_reduce_1,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_4,
 2, 39, :_reduce_5,
 2, 39, :_reduce_6,
 2, 39, :_reduce_7,
 2, 39, :_reduce_8,
 2, 39, :_reduce_9,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_15,
 2, 39, :_reduce_16,
 6, 40, :_reduce_17,
 0, 55, :_reduce_none,
 2, 55, :_reduce_none,
 3, 56, :_reduce_20,
 5, 56, :_reduce_21,
 1, 57, :_reduce_22,
 7, 41, :_reduce_none,
 0, 58, :_reduce_none,
 2, 58, :_reduce_25,
 4, 58, :_reduce_26,
 3, 58, :_reduce_27,
 0, 59, :_reduce_none,
 2, 59, :_reduce_29,
 0, 60, :_reduce_none,
 2, 60, :_reduce_31,
 0, 61, :_reduce_none,
 2, 61, :_reduce_33,
 0, 62, :_reduce_none,
 2, 62, :_reduce_35,
 2, 62, :_reduce_36,
 0, 63, :_reduce_none,
 2, 63, :_reduce_38,
 0, 64, :_reduce_none,
 2, 64, :_reduce_40,
 2, 42, :_reduce_none,
 1, 42, :_reduce_42,
 1, 43, :_reduce_43,
 3, 43, :_reduce_44,
 1, 44, :_reduce_none,
 1, 44, :_reduce_none,
 1, 45, :_reduce_47,
 3, 45, :_reduce_48,
 1, 46, :_reduce_none,
 1, 46, :_reduce_none,
 2, 46, :_reduce_51,
 4, 67, :_reduce_52,
 4, 66, :_reduce_53,
 3, 66, :_reduce_54,
 2, 69, :_reduce_none,
 2, 70, :_reduce_56,
 4, 70, :_reduce_57,
 3, 54, :_reduce_58,
 1, 54, :_reduce_59,
 1, 71, :_reduce_60,
 3, 71, :_reduce_61,
 1, 65, :_reduce_62,
 3, 65, :_reduce_63,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 3, 47, :_reduce_67,
 1, 68, :_reduce_none,
 2, 68, :_reduce_69,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 48, :_reduce_none,
 3, 48, :_reduce_none,
 1, 49, :_reduce_75,
 2, 49, :_reduce_76,
 3, 50, :_reduce_77,
 4, 51, :_reduce_78,
 2, 51, :_reduce_79,
 0, 75, :_reduce_80,
 5, 75, :_reduce_81,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 52, :_reduce_84,
 2, 53, :_reduce_85,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none ]

racc_reduce_n = 93

racc_shift_n = 157

racc_action_table = [
   -60,    26,    30,   149,   131,    18,    93,   102,    22,    23,
    24,    25,    29,   103,    51,    68,    92,    20,    26,    30,
   -60,   104,    18,   -60,    99,    22,    23,    24,    25,    29,
   -60,    26,    30,   -60,    20,    18,   143,   144,    22,    23,
    24,    25,    29,    97,    51,    26,    30,    20,   110,    18,
    97,    94,    22,    23,    24,    25,    29,    84,    26,    30,
   132,    20,    18,   111,   112,    22,    23,    24,    25,    29,
   114,    51,    26,    30,    20,    95,    18,    78,   103,    22,
    23,    24,    25,    29,    76,    51,    26,    30,    20,    75,
    18,   106,   107,    22,    23,    24,    25,    29,    74,    26,
    30,   105,    20,    18,    88,    72,    22,    23,    24,    25,
    29,    70,    26,    30,   121,    20,    18,    88,    68,    22,
    23,    24,    25,    29,   122,   123,    87,    49,    20,    26,
    30,    45,   105,    18,   128,   129,    22,    23,    24,    25,
    29,   130,    51,    26,    30,    20,   105,    18,   101,   105,
    22,    23,    24,    25,    29,    44,    26,    30,   134,    20,
    18,   135,   103,    22,    23,    24,    25,    29,   105,    51,
    26,    30,    20,   137,    18,   138,    41,    22,    23,    24,
    25,    29,   141,    26,    30,   142,    20,    18,    39,   147,
    22,    23,    24,    25,    29,    37,    51,    26,    30,    20,
   105,    18,   150,   151,    22,    23,    24,    25,    29,    34,
    51,    26,    30,    20,   154,    18,    37,   156,    22,    23,
    24,    25,    29,   nil,    26,    30,   nil,    20,    18,   nil,
   nil,    22,    23,    24,    25,    29,   nil,    51,    26,    30,
    20,   nil,    18,   nil,   nil,    22,    23,    24,    25,    29,
   nil,    26,    30,   nil,    20,    18,   nil,   nil,    22,    23,
    24,    25,    29,   nil,    26,    30,   nil,    20,    18,   nil,
   nil,    22,    23,    24,    25,    29,   nil,    26,    30,   nil,
    20,    18,   nil,   nil,    22,    23,    24,    25,    29,   nil,
    51,    26,    30,    20,   nil,    18,   nil,   nil,    22,    23,
    24,    25,    29,   nil,    26,    30,   nil,    20,    18,   nil,
   nil,    22,    23,    24,    25,    29,   nil,    51,   nil,   nil,
    20,     4,     6,     8,    10,    12,    14,    15,    16,     1,
     2,     3,     5,     7,     9,    11,    13,    83,    30,   nil,
   nil,    18,   nil,    80,    22,    23,    24,    25,    29,    83,
    30,   nil,   nil,    18,   nil,    80,    22,    23,    24,    25,
    29,    83,    30,   nil,   nil,    18,   nil,    80,    22,    23,
    24,    25,    29,    83,    30,   nil,   nil,    18,   nil,    80,
    22,    23,    24,    25,    29,    83,    30,   nil,   nil,    18,
   nil,    80,    22,    23,    24,    25,    29,    83,    30,   nil,
   nil,    18,   nil,    80,    22,    23,    24,    25,    29,    83,
    30,   nil,   nil,    18,   nil,    80,    22,    23,    24,    25,
    29 ]

racc_action_check = [
    52,    11,    11,   137,   115,    11,    50,    75,    11,    11,
    11,    11,    11,    77,    11,   137,    50,    11,     2,     2,
    52,    78,     2,    52,    70,     2,     2,     2,     2,     2,
    52,   147,   147,    52,     2,   147,   135,   135,   147,   147,
   147,   147,   147,    65,   147,    68,    68,   147,    85,    68,
   119,    53,    68,    68,    68,    68,    68,    42,    61,    61,
   119,    68,    61,    86,    86,    61,    61,    61,    61,    61,
    89,    61,    59,    59,    61,    59,    59,    39,    91,    59,
    59,    59,    59,    59,    37,    59,    72,    72,    59,    36,
    72,    82,    82,    72,    72,    72,    72,    72,    34,    51,
    51,    82,    72,    51,    51,    28,    51,    51,    51,    51,
    51,    17,    45,    45,    98,    51,    45,    45,    16,    45,
    45,    45,    45,    45,   102,   103,    45,     9,    45,    10,
    10,     8,   108,    10,   109,   110,    10,    10,    10,    10,
    10,   111,    10,     1,     1,    10,   113,     1,    74,   117,
     1,     1,     1,     1,     1,     7,    12,    12,   122,     1,
    12,   123,   124,    12,    12,    12,    12,    12,   126,    12,
    13,    13,    12,   127,    13,   128,     6,    13,    13,    13,
    13,    13,   133,    14,    14,   134,    13,    14,     5,   136,
    14,    14,    14,    14,    14,     4,    14,    15,    15,    14,
   139,    15,   142,   146,    15,    15,    15,    15,    15,     3,
    15,   100,   100,    15,   150,   100,   151,   154,   100,   100,
   100,   100,   100,   nil,    97,    97,   nil,   100,    97,   nil,
   nil,    97,    97,    97,    97,    97,   nil,    97,    27,    27,
    97,   nil,    27,   nil,   nil,    27,    27,    27,    27,    27,
   nil,    92,    92,   nil,    27,    92,   nil,   nil,    92,    92,
    92,    92,    92,   nil,    31,    31,   nil,    92,    31,   nil,
   nil,    31,    31,    31,    31,    31,   nil,    94,    94,   nil,
    31,    94,   nil,   nil,    94,    94,    94,    94,    94,   nil,
    94,    90,    90,    94,   nil,    90,   nil,   nil,    90,    90,
    90,    90,    90,   nil,    95,    95,   nil,    90,    95,   nil,
   nil,    95,    95,    95,    95,    95,   nil,    95,   nil,   nil,
    95,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    88,    88,   nil,
   nil,    88,   nil,    88,    88,    88,    88,    88,    88,   105,
   105,   nil,   nil,   105,   nil,   105,   105,   105,   105,   105,
   105,    41,    41,   nil,   nil,    41,   nil,    41,    41,    41,
    41,    41,    41,   106,   106,   nil,   nil,   106,   nil,   106,
   106,   106,   106,   106,   106,    84,    84,   nil,   nil,    84,
   nil,    84,    84,    84,    84,    84,    84,   130,   130,   nil,
   nil,   130,   nil,   130,   130,   130,   130,   130,   130,    93,
    93,   nil,   nil,    93,   nil,    93,    93,    93,    93,    93,
    93 ]

racc_action_pointer = [
   319,   125,     0,   191,   176,   153,   154,   120,   100,    92,
   111,   -17,   138,   152,   165,   179,    87,   111,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   220,    85,   nil,
   nil,   246,   nil,   nil,    65,   nil,    71,    64,   nil,    41,
   nil,   343,    32,   nil,   nil,    94,   nil,   nil,   nil,   nil,
   -17,    81,     0,    31,   nil,   nil,   nil,   nil,   nil,    54,
   nil,    40,   nil,   nil,   nil,    23,   nil,   nil,    27,   nil,
    24,   nil,    68,   nil,   130,   -12,   nil,   -17,   -14,   nil,
   nil,   nil,    68,   nil,   367,    22,    43,   nil,   319,    38,
   273,    48,   233,   391,   259,   286,   nil,   206,    82,   nil,
   193,   nil,   106,    90,   nil,   331,   355,   nil,    99,   107,
   116,   118,   nil,   113,   nil,   -28,   nil,   116,   nil,    30,
   nil,   nil,   140,   124,   132,   nil,   135,   145,   156,   nil,
   379,   nil,   nil,   163,   164,     2,   160,   -16,   nil,   167,
   nil,   nil,   184,   nil,   nil,   nil,   173,    13,   nil,   nil,
   193,   197,   nil,   nil,   199,   nil,   nil ]

racc_action_default = [
   -93,   -93,   -93,   -93,   -18,   -93,   -24,   -93,   -93,   -93,
   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -87,   -68,
   -71,   -70,   -88,   -89,   -90,   -91,   -72,   -73,    -9,   -92,
   -86,   -75,   -10,   -11,   -93,    -1,   -93,   -93,   -12,   -80,
    -2,   -93,   -28,   -13,   -84,   -93,    -3,   -42,   -14,   -80,
   -59,   -93,   -68,    -4,   -49,   -43,   -50,   -45,   -46,   -93,
   -15,   -93,    -5,   -60,   -16,    -6,   -47,    -7,   -93,    -8,
   -93,   -69,   -93,   -76,   -93,   -93,   -19,   -79,   -93,   -62,
   -65,   -64,   -25,   -66,   -93,   -30,   -93,   -41,   -93,   -93,
   -93,   -85,   -93,   -93,   -93,   -93,   -51,   -93,   -93,   157,
   -74,   -77,   -93,   -93,   -80,   -93,   -93,   -27,   -29,   -32,
   -93,   -93,   -55,   -56,   -54,   -93,   -61,   -58,   -44,   -93,
   -48,   -67,   -93,   -93,   -78,   -63,   -26,   -34,   -93,   -31,
   -93,   -53,   -52,   -93,   -93,   -93,   -37,   -93,   -33,   -57,
   -17,   -22,   -93,   -83,   -82,   -81,   -39,   -93,   -35,   -36,
   -20,   -18,   -23,   -38,   -93,   -40,   -21 ]

racc_goto_table = [
    35,    55,    27,    62,    69,    19,    31,    65,    47,    64,
    81,    59,   133,    59,    77,    43,    48,    63,    33,    60,
    38,   140,    66,    67,    91,    42,    85,   109,   127,   136,
   146,    71,   152,    32,    28,    73,    53,    82,    46,   125,
    40,    89,    17,   145,   nil,   nil,   nil,    89,   nil,    63,
   nil,   nil,   nil,    81,   nil,    63,   nil,    81,   nil,    96,
   nil,    96,    81,    71,    98,    71,   nil,   nil,   nil,   nil,
   nil,   nil,    63,   100,    81,    81,    19,   nil,   nil,   124,
   108,   nil,   nil,   nil,   113,   118,   115,   nil,   119,   117,
   nil,   nil,   nil,   nil,    63,    59,   116,   nil,   nil,    81,
   nil,   nil,   126,    66,    71,   120,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   148,   139,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   153,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   155,    59 ]

racc_goto_check = [
     2,     6,    30,     6,     9,    34,    34,     7,    28,    16,
    36,    30,    18,    30,    37,    14,    15,    34,    12,     8,
    13,    19,     8,     8,    37,    20,    21,    22,    23,    24,
    25,    34,    26,    11,    10,    34,     5,    27,     4,    35,
     3,    16,     1,    38,   nil,   nil,   nil,    16,   nil,    34,
   nil,   nil,   nil,    36,   nil,    34,   nil,    36,   nil,    28,
   nil,    28,    36,    34,    16,    34,   nil,   nil,   nil,   nil,
   nil,   nil,    34,    30,    36,    36,    34,   nil,   nil,    37,
    27,   nil,   nil,   nil,    27,     6,    16,   nil,     7,    27,
   nil,   nil,   nil,   nil,    34,    30,    34,   nil,   nil,    36,
   nil,   nil,    27,     8,    34,     8,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     9,    27,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,     6,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,     2,    30 ]

racc_goto_pointer = [
   nil,    42,    -4,    34,    30,    26,    -9,    -7,     8,   -12,
    33,    31,    15,    15,     8,     7,    -4,   nil,  -110,  -112,
    19,   -16,   -58,   -81,   -98,  -106,  -114,    -4,     0,   nil,
     1,   nil,   nil,   nil,     4,   -66,   -31,   -25,   -92 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    57,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    54,    36,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    56,    58,
    61,    90,    86,    50,    52,    79,    21,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :KeyH => 10,
 :EncH => 11,
 :VersionH => 12,
 :CTypeH => 13,
 :CEncodingH => 14,
 :CDispositionH => 15,
 :Mbox => 16,
 :Spec => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37 }

racc_use_result_var = true

racc_nt_base = 38

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'DateH',
'RecvH',
'RetpathH',
'MaddrH',
'SaddrH',
'MmboxH',
'SmboxH',
'MsgidH',
'KeyH',
'EncH',
'VersionH',
'CTypeH',
'CEncodingH',
'CDispositionH',
'Mbox',
'Spec',
'DIGIT',
'ATOM',
'","',
'":"',
'FROM',
'"@"',
'DOMLIT',
'BY',
'VIA',
'WITH',
'ID',
'FOR',
'";"',
'"<"',
'">"',
'"."',
'QUOTED',
'TOKEN',
'"/"',
'"="',
'$start',
'content',
'datetime',
'received',
'returnpath',
'addrs',
'addr',
'mboxes',
'mbox',
'msgid',
'keys',
'enc',
'version',
'ctype',
'cencode',
'cdisp',
'spec',
'day',
'hour',
'zone',
'from',
'by',
'via',
'with',
'id',
'for',
'recvdatetime',
'domain',
'routeaddr',
'group',
'phrase',
'route',
'at_domains',
'local',
'word',
'domword',
'atom',
'params',
'value']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'mp.y', 14
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'mp.y', 17
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 18
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 19
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 20
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 21
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 22
  def _reduce_9( val, _values, result )
 @field.keys.replace val[1]
   result
  end
.,.,

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

module_eval <<'.,.,', 'mp.y', 30
  def _reduce_15( val, _values, result )
                  mb = val[1]
                  @field.phrase = mb.phrase
                  @field.setroute mb.route
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 38
  def _reduce_16( val, _values, result )
                  mb = val[1]
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 47
  def _reduce_17( val, _values, result )
                  t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
                  result = (t + val[4] - val[5]).localtime
   result
  end
.,.,

 # reduce 18 omitted

 # reduce 19 omitted

module_eval <<'.,.,', 'mp.y', 56
  def _reduce_20( val, _values, result )
                  result = (val[0].to_i * 60 * 60) +
                           (val[2].to_i * 60)
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 61
  def _reduce_21( val, _values, result )
                  result = (val[0].to_i * 60 * 60) +
                           (val[2].to_i * 60) +
                           (val[4].to_i)
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 68
  def _reduce_22( val, _values, result )
                  result = ::TMail.zonestr2i( result )
   result
  end
.,.,

 # reduce 23 omitted

 # reduce 24 omitted

module_eval <<'.,.,', 'mp.y', 76
  def _reduce_25( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 80
  def _reduce_26( val, _values, result )
                  @field.from = Address.join( val[3] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 84
  def _reduce_27( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

 # reduce 28 omitted

module_eval <<'.,.,', 'mp.y', 90
  def _reduce_29( val, _values, result )
                  @field.by = Address.join( val[1] )
   result
  end
.,.,

 # reduce 30 omitted

module_eval <<'.,.,', 'mp.y', 96
  def _reduce_31( val, _values, result )
                  @field.via = val[1]
   result
  end
.,.,

 # reduce 32 omitted

module_eval <<'.,.,', 'mp.y', 102
  def _reduce_33( val, _values, result )
                  @field.with.push val[1]
   result
  end
.,.,

 # reduce 34 omitted

module_eval <<'.,.,', 'mp.y', 108
  def _reduce_35( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 112
  def _reduce_36( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

 # reduce 37 omitted

module_eval <<'.,.,', 'mp.y', 118
  def _reduce_38( val, _values, result )
                  @field.for_ = val[1].address
   result
  end
.,.,

 # reduce 39 omitted

module_eval <<'.,.,', 'mp.y', 125
  def _reduce_40( val, _values, result )
                  @field.date = val[1]
   result
  end
.,.,

 # reduce 41 omitted

module_eval <<'.,.,', 'mp.y', 131
  def _reduce_42( val, _values, result )
                  @field.route.replace result.route
                  @field.addr = result.addr
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 135
  def _reduce_43( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 136
  def _reduce_44( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 45 omitted

 # reduce 46 omitted

module_eval <<'.,.,', 'mp.y', 143
  def _reduce_47( val, _values, result )
                  result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 147
  def _reduce_48( val, _values, result )
                  result.push val[2]
   result
  end
.,.,

 # reduce 49 omitted

 # reduce 50 omitted

module_eval <<'.,.,', 'mp.y', 154
  def _reduce_51( val, _values, result )
                  val[1].phrase = HFdecoder.decode( result )
                  result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 160
  def _reduce_52( val, _values, result )
                  result = AddressGroup.new( result, val[2] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 166
  def _reduce_53( val, _values, result )
                  result = val[2]
                  result.route = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 171
  def _reduce_54( val, _values, result )
                  result = val[1]
   result
  end
.,.,

 # reduce 55 omitted

module_eval <<'.,.,', 'mp.y', 176
  def _reduce_56( val, _values, result )
 result = [ val[1] ]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 177
  def _reduce_57( val, _values, result )
 result.push val[3]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 179
  def _reduce_58( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 180
  def _reduce_59( val, _values, result )
 result = Address.new( result, nil )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 182
  def _reduce_60( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 183
  def _reduce_61( val, _values, result )
 result.push val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 185
  def _reduce_62( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 186
  def _reduce_63( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 64 omitted

 # reduce 65 omitted

 # reduce 66 omitted

module_eval <<'.,.,', 'mp.y', 194
  def _reduce_67( val, _values, result )
                  val[1] = val[1].addr
                  result = val.join('')
   result
  end
.,.,

 # reduce 68 omitted

module_eval <<'.,.,', 'mp.y', 199
  def _reduce_69( val, _values, result )
 result << ' ' << val[1]
   result
  end
.,.,

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

module_eval <<'.,.,', 'mp.y', 210
  def _reduce_75( val, _values, result )
                  @field.encrypter = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 214
  def _reduce_76( val, _values, result )
                  @field.encrypter = val[0]
                  @field.keyword   = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 220
  def _reduce_77( val, _values, result )
                  @field.major = val[0].to_i
                  @field.minor = val[2].to_i
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 226
  def _reduce_78( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = val[2]
                  @field.params.replace decode_params(val[3])
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 232
  def _reduce_79( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = ''
                  @field.params.replace decode_params(val[3])
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 239
  def _reduce_80( val, _values, result )
                  result = {}
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 243
  def _reduce_81( val, _values, result )
                  result[ val[2].downcase ] = val[4]
   result
  end
.,.,

 # reduce 82 omitted

 # reduce 83 omitted

module_eval <<'.,.,', 'mp.y', 251
  def _reduce_84( val, _values, result )
                  @field.encoding = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 256
  def _reduce_85( val, _values, result )
                  @field.disposition = val[0]
                  @field.params.replace decode_params(val[1])
   result
  end
.,.,

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 def _reduce_none( val, _values, result )
  result
 end

  end   # class Parser

end   # module TMail
