require 'racc/parser'

#
# parsemail.rb
#
#   Copyright (c) 1998-2001 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'tmail/scanmail'


module TMail

  class Parser < ::Racc::Parser

module_eval <<'..end mp.y modeval..id7334ef43d1', 'mp.y', 286

  def self.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && Racc_debug_parser
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  NATIVE_ROUTINE = {
    'TMail::MsgidH' => :msgid_parse,
    'TMail::RefH'   => :refs_parse
  }

  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    if mid = NATIVE_ROUTINE[ obj.type.name ] then
      __send__ mid, str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = Scanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]

      yyparse self, :parse_in
    end
  end

  private


  def parse_in( &block )
    yield @first
    @scanner.scan &block
  end
  
  def on_error( tok, val, vstack )
    raise MailSyntaxError,
          "\nparse error in '#{@field.name}:' on token #{val.inspect}"
  end


  def refs_parse( str )
    arr = []

    while mdata = ::TMail::MSGID.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      proc_phrase pre, arr unless pre.empty?
      arr.push mdata.to_s
    end
    str.strip!
    proc_phrase str, arr if not pre or pre.empty?

    @field.refs.replace arr
  end

  def proc_phrase( str, arr )
    while mdata = /"([^\\]*(?:\\.[^"\\]*)*)"/.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      arr.push pre unless pre.empty?
      arr.push mdata[1]
    end
    str.strip!
    arr.push str unless str.empty?
  end


  def msgid_parse( str )
    if mdata = ::TMail::MSGID.match( str ) then
      @field.msgid = mdata.to_s
    else
      raise MailSyntaxError, "wrong Message-ID format: #{str}"
    end
  end

  def decode_params( hash )
    tmp = nil
    hash.delete_if do |k,v|
      if m = /\*(?:(\d+)\*)?\z/.match(k) then
        ((tmp ||= {})[ m.pre_match ] ||= [])[ (m[1] || 0).to_i ] = v
        true
      else
        false
      end
    end
    if tmp then
      tmp.each do |k,v|
        hash[k] = decode_v( v.join('') )
      end
    end

    hash
  end

  VE_RE = /\A(?:iso-2022-jp|euc-jp|shift_jis|us-ascii)?'[a-z]*'/in

  def decode_v( str )
    if m = VE_RE.match(str) then
      NKF.nkf '-e', m.post_match.gsub( /%[\da-f]{2}/in ) {|s| s[1,2].hex.chr }
    else
      str
    end
  end

..end mp.y modeval..id7334ef43d1

##### racc 1.3.9 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 2, 39, :_reduce_1,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_4,
 2, 39, :_reduce_5,
 2, 39, :_reduce_6,
 2, 39, :_reduce_7,
 2, 39, :_reduce_8,
 2, 39, :_reduce_9,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_15,
 2, 39, :_reduce_16,
 6, 40, :_reduce_17,
 0, 55, :_reduce_none,
 2, 55, :_reduce_none,
 3, 56, :_reduce_20,
 5, 56, :_reduce_21,
 1, 57, :_reduce_22,
 7, 41, :_reduce_none,
 0, 58, :_reduce_none,
 2, 58, :_reduce_25,
 4, 58, :_reduce_26,
 3, 58, :_reduce_27,
 0, 59, :_reduce_none,
 2, 59, :_reduce_29,
 0, 60, :_reduce_none,
 2, 60, :_reduce_31,
 0, 61, :_reduce_none,
 2, 61, :_reduce_33,
 0, 62, :_reduce_none,
 2, 62, :_reduce_35,
 2, 62, :_reduce_36,
 0, 63, :_reduce_none,
 2, 63, :_reduce_38,
 0, 64, :_reduce_none,
 2, 64, :_reduce_40,
 2, 42, :_reduce_none,
 1, 42, :_reduce_42,
 1, 43, :_reduce_43,
 3, 43, :_reduce_44,
 1, 44, :_reduce_none,
 1, 44, :_reduce_none,
 1, 45, :_reduce_47,
 3, 45, :_reduce_48,
 1, 46, :_reduce_none,
 1, 46, :_reduce_none,
 2, 46, :_reduce_51,
 4, 67, :_reduce_52,
 4, 66, :_reduce_53,
 3, 66, :_reduce_54,
 2, 69, :_reduce_none,
 2, 70, :_reduce_56,
 4, 70, :_reduce_57,
 3, 54, :_reduce_58,
 1, 54, :_reduce_59,
 1, 71, :_reduce_60,
 3, 71, :_reduce_61,
 1, 65, :_reduce_62,
 3, 65, :_reduce_63,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 3, 47, :_reduce_67,
 1, 68, :_reduce_none,
 2, 68, :_reduce_69,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 48, :_reduce_none,
 3, 48, :_reduce_none,
 1, 49, :_reduce_75,
 2, 49, :_reduce_76,
 3, 50, :_reduce_77,
 4, 51, :_reduce_78,
 2, 51, :_reduce_79,
 0, 75, :_reduce_80,
 5, 75, :_reduce_81,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 52, :_reduce_84,
 2, 53, :_reduce_85,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none ]

racc_reduce_n = 93

racc_shift_n = 157

racc_action_table = [
   -60,    21,    26,   143,   136,    30,   115,   113,    19,    20,
    25,    27,    29,    63,    34,    38,   114,    22,    21,    26,
   -60,    99,    30,   -60,   105,    19,    20,    25,    27,    29,
   -60,    34,    98,   -60,    22,    21,    26,    98,   107,    30,
    74,    56,    19,    20,    25,    27,    29,   132,    21,    26,
    73,    22,    30,   103,   104,    19,    20,    25,    27,    29,
   109,    34,    21,    26,    22,    70,    30,   147,   148,    19,
    20,    25,    27,    29,   111,    21,    26,    95,    22,    30,
   116,   117,    19,    20,    25,    27,    29,   118,    21,    26,
    55,    22,    30,    51,   117,    19,    20,    25,    27,    29,
    50,    21,    26,   114,    22,    30,   122,   123,    19,    20,
    25,    27,    29,   114,    34,    21,    26,    22,    44,    30,
   124,   114,    19,    20,    25,    27,    29,   125,    34,    21,
    26,    22,   126,    30,    94,    91,    19,    20,    25,    27,
    29,   130,    34,    21,    26,    22,    81,    30,    84,   135,
    19,    20,    25,    27,    29,    66,    21,    26,   137,    22,
    30,   114,   139,    19,    20,    25,    27,    29,   117,    34,
    21,    26,    22,   114,    30,   141,   142,    19,    20,    25,
    27,    29,    80,    21,    26,   145,    22,    30,    82,   150,
    19,    20,    25,    27,    29,    38,    34,    21,    26,    22,
   153,    30,   154,    44,    19,    20,    25,    27,    29,   156,
    21,    26,   nil,    22,    30,   nil,   nil,    19,    20,    25,
    27,    29,   nil,    34,    21,    26,    22,    96,    30,   nil,
   nil,    19,    20,    25,    27,    29,   nil,    34,    21,    26,
    22,   nil,    30,   nil,   nil,    19,    20,    25,    27,    29,
   nil,    21,    26,   nil,    22,    30,   nil,   nil,    19,    20,
    25,    27,    29,   nil,    34,    21,    26,    22,   nil,    30,
    78,   nil,    19,    20,    25,    27,    29,   nil,   nil,    92,
   nil,    22,    21,    26,   nil,   nil,    30,    78,   nil,    19,
    20,    25,    27,    29,   nil,    21,    26,   nil,    22,    30,
   nil,   nil,    19,    20,    25,    27,    29,   nil,    21,    26,
   nil,    22,    30,   nil,   nil,    19,    20,    25,    27,    29,
   nil,   nil,   nil,   nil,    22,     6,     8,    10,    12,    14,
    16,     2,     4,     5,     7,     9,    11,    13,    15,     1,
     3,    89,    26,   nil,   nil,    30,   nil,    86,    19,    20,
    25,    27,    29,    89,    26,   nil,   nil,    30,   nil,    86,
    19,    20,    25,    27,    29,    89,    26,   nil,   nil,    30,
   nil,    86,    19,    20,    25,    27,    29,    89,    26,   nil,
   nil,    30,   nil,    86,    19,    20,    25,    27,    29,    89,
    26,   nil,   nil,    30,   nil,    86,    19,    20,    25,    27,
    29,    89,    26,   nil,   nil,    30,   nil,    86,    19,    20,
    25,    27,    29,    89,    26,   nil,   nil,    30,   nil,    86,
    19,    20,    25,    27,    29 ]

racc_action_check = [
    18,    12,    12,   137,   126,    12,    88,    88,    12,    12,
    12,    12,    12,    13,    12,   137,    88,    12,     2,     2,
    18,    70,     2,    18,    77,     2,     2,     2,     2,     2,
    18,     2,    68,    18,     2,     3,     3,   120,    79,     3,
    33,    11,     3,     3,     3,     3,     3,   120,   145,   145,
    33,     3,   145,    76,    76,   145,   145,   145,   145,   145,
    82,   145,     5,     5,   145,    17,     5,   139,   139,     5,
     5,     5,     5,     5,    85,   108,   108,    59,     5,   108,
    91,    93,   108,   108,   108,   108,   108,    94,     7,     7,
    10,   108,     7,     9,    97,     7,     7,     7,     7,     7,
     8,    98,    98,   101,     7,    98,   102,   103,    98,    98,
    98,    98,    98,   106,    98,    96,    96,    98,     6,    96,
   109,   110,    96,    96,    96,    96,    96,   111,    96,    95,
    95,    96,   112,    95,    56,    51,    95,    95,    95,    95,
    95,   117,    95,    80,    80,    95,    44,    80,    49,   124,
    80,    80,    80,    80,    80,    15,     1,     1,   127,    80,
     1,   129,   130,     1,     1,     1,     1,     1,   131,     1,
    75,    75,     1,   133,    75,   134,   135,    75,    75,    75,
    75,    75,    41,    14,    14,   138,    75,    14,    45,   142,
    14,    14,    14,    14,    14,     4,    14,    73,    73,    14,
   146,    73,   150,   153,    73,    73,    73,    73,    73,   154,
    16,    16,   nil,    73,    16,   nil,   nil,    16,    16,    16,
    16,    16,   nil,    16,    60,    60,    16,    60,    60,   nil,
   nil,    60,    60,    60,    60,    60,   nil,    60,    38,    38,
    60,   nil,    38,   nil,   nil,    38,    38,    38,    38,    38,
   nil,    28,    28,   nil,    38,    28,   nil,   nil,    28,    28,
    28,    28,    28,   nil,    28,    55,    55,    28,   nil,    55,
    55,   nil,    55,    55,    55,    55,    55,   nil,   nil,    55,
   nil,    55,    34,    34,   nil,   nil,    34,    34,   nil,    34,
    34,    34,    34,    34,   nil,    46,    46,   nil,    34,    46,
   nil,   nil,    46,    46,    46,    46,    46,   nil,    42,    42,
   nil,    46,    42,   nil,   nil,    42,    42,    42,    42,    42,
   nil,   nil,   nil,   nil,    42,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   123,   123,   nil,   nil,   123,   nil,   123,   123,   123,
   123,   123,   123,    50,    50,   nil,   nil,    50,   nil,    50,
    50,    50,    50,    50,    50,    78,    78,   nil,   nil,    78,
   nil,    78,    78,    78,    78,    78,    78,    84,    84,   nil,
   nil,    84,   nil,    84,    84,    84,    84,    84,    84,   115,
   115,   nil,   nil,   115,   nil,   115,   115,   115,   115,   115,
   115,   114,   114,   nil,   nil,   114,   nil,   114,   114,   114,
   114,   114,   114,    74,    74,   nil,   nil,    74,   nil,    74,
    74,    74,    74,    74,    74 ]

racc_action_pointer = [
   323,   138,     0,    17,   164,    44,    99,    70,    78,    75,
    59,     6,   -17,   -22,   165,   120,   192,    65,     0,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   233,   nil,
   nil,   nil,   nil,    17,   264,   nil,   nil,   nil,   220,   nil,
   nil,   162,   290,   nil,   126,   170,   277,   nil,   nil,   123,
   335,   102,   nil,   nil,   nil,   247,    98,   nil,   nil,    57,
   206,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    12,   nil,
    21,   nil,   nil,   179,   395,   152,    33,    -8,   347,     6,
   125,   nil,    41,   nil,   359,    48,   nil,   nil,   -17,   nil,
   nil,    62,   nil,    51,    52,   111,    97,    64,    83,   nil,
   nil,    70,    74,    84,   nil,   nil,    80,   nil,    57,   102,
    88,   108,   105,   nil,   383,   371,   nil,   106,   nil,   nil,
    17,   nil,   nil,   323,   131,   nil,   -15,   130,   nil,   128,
   125,   138,   nil,   140,   156,   155,   nil,   -16,   156,    33,
   nil,   nil,   171,   nil,   nil,    30,   170,   nil,   nil,   nil,
   181,   nil,   nil,   184,   191,   nil,   nil ]

racc_action_default = [
   -93,   -93,   -93,   -93,   -93,   -93,   -18,   -93,   -24,   -93,
   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -68,   -88,
   -89,   -72,   -71,   -70,   -50,   -90,   -86,   -91,   -93,   -92,
   -87,   -49,   -15,   -59,   -93,    -7,   -60,   -16,   -93,    -8,
   -68,    -9,   -73,    -1,   -93,   -93,   -75,   -10,    -2,   -28,
   -93,   -93,   -11,   -42,    -3,   -93,   -80,   -12,   -46,    -4,
   -93,   -43,   -45,   -84,   -13,    -5,   -80,   -14,    -6,   -47,
   -93,   -69,   -51,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
   -93,   -19,   -93,   -76,   -93,   -30,   -65,   -62,   -25,   -66,
   -64,   -93,   -41,   -79,   -93,   -93,   -93,   -85,   -93,   157,
   -61,   -58,   -93,   -93,   -55,   -54,   -56,   -67,   -74,   -93,
   -29,   -93,   -32,   -27,   -93,   -93,   -77,   -93,   -80,   -44,
   -93,   -48,   -53,   -93,   -93,   -31,   -93,   -34,   -63,   -26,
   -93,   -78,   -52,   -57,   -93,   -93,   -33,   -93,   -37,   -93,
   -17,   -22,   -93,   -36,   -35,   -93,   -39,   -83,   -82,   -81,
   -20,   -38,   -23,   -18,   -93,   -40,   -21 ]

racc_goto_table = [
    43,    42,    39,    61,    53,    65,    93,    36,    60,    40,
    60,    46,    32,    35,    68,    88,    97,    90,   134,    64,
    67,    37,    72,    52,    57,   140,    49,    69,    85,   112,
   127,   138,    71,   146,   152,    47,    41,    59,    36,   101,
    54,    90,    36,   106,   128,    90,    71,    48,    17,   110,
    83,    90,    77,   149,    72,   nil,    79,   nil,   nil,    36,
   nil,   nil,   nil,   nil,    71,   nil,   nil,   nil,   131,   nil,
   nil,   nil,   nil,    77,   nil,   nil,   108,   100,   nil,    36,
   129,    90,    90,   nil,    40,   nil,   119,   nil,   133,   nil,
    90,    60,   nil,   102,   120,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    69,   nil,   121,
   nil,   nil,    71,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   144,   151,   nil,   nil,   nil,
   nil,    60,   nil,   nil,   nil,   nil,   nil,   155 ]

racc_goto_check = [
     2,    30,     9,     6,    28,     6,    37,    34,    30,    34,
    30,    34,     8,     8,     7,    27,    37,    36,    18,    14,
    15,    16,    28,    12,    13,    19,    20,     8,    21,    22,
    23,    24,    34,    25,    26,    11,    10,     5,    34,    27,
     4,    36,    34,    27,    35,    36,    34,     3,     1,    27,
    34,    36,    16,    38,    28,   nil,    16,   nil,   nil,    34,
   nil,   nil,   nil,   nil,    34,   nil,   nil,   nil,    37,   nil,
   nil,   nil,   nil,    16,   nil,   nil,    30,    34,   nil,    34,
    27,    36,    36,   nil,    34,   nil,     6,   nil,    27,   nil,
    36,    30,   nil,    16,     7,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,     8,   nil,     8,
   nil,   nil,    34,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     9,     6,   nil,   nil,   nil,
   nil,    30,   nil,   nil,   nil,   nil,   nil,     2 ]

racc_goto_pointer = [
   nil,    48,    -6,    39,    30,    25,    -9,    -2,    11,    -2,
    31,    28,    14,    13,     6,     5,    18,   nil,  -106,  -109,
    18,   -21,   -56,   -82,   -96,  -105,  -112,   -35,    -6,   nil,
    -4,   nil,   nil,   nil,     4,   -70,   -33,   -50,   -86 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    62,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    31,    45,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    24,    58,
    28,    75,    76,    33,    18,    87,    23,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :KeyH => 10,
 :EncH => 11,
 :VersionH => 12,
 :CTypeH => 13,
 :CEncodingH => 14,
 :CDispositionH => 15,
 :Mbox => 16,
 :Spec => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37 }

racc_use_result_var = true

racc_nt_base = 38

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'DateH',
'RecvH',
'RetpathH',
'MaddrH',
'SaddrH',
'MmboxH',
'SmboxH',
'MsgidH',
'KeyH',
'EncH',
'VersionH',
'CTypeH',
'CEncodingH',
'CDispositionH',
'Mbox',
'Spec',
'DIGIT',
'ATOM',
'","',
'":"',
'FROM',
'"@"',
'DOMLIT',
'BY',
'VIA',
'WITH',
'ID',
'FOR',
'";"',
'"<"',
'">"',
'"."',
'QUOTED',
'TOKEN',
'"/"',
'"="',
'$start',
'content',
'datetime',
'received',
'returnpath',
'addrs',
'addr',
'mboxes',
'mbox',
'msgid',
'keys',
'enc',
'version',
'ctype',
'cencode',
'cdisp',
'spec',
'day',
'hour',
'zone',
'from',
'by',
'via',
'with',
'id',
'for',
'recvdatetime',
'domain',
'routeaddr',
'group',
'phrase',
'route',
'at_domains',
'local',
'word',
'domword',
'atom',
'params',
'value']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'mp.y', 14
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'mp.y', 17
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 18
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 19
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 20
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 21
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 22
  def _reduce_9( val, _values, result )
 @field.keys.replace val[1]
   result
  end
.,.,

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

module_eval <<'.,.,', 'mp.y', 30
  def _reduce_15( val, _values, result )
                  mb = val[1]
                  @field.phrase = mb.phrase
                  @field.setroute mb.route
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 38
  def _reduce_16( val, _values, result )
                  mb = val[1]
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 47
  def _reduce_17( val, _values, result )
                  t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
                  result = (t + val[4] - val[5]).localtime
   result
  end
.,.,

 # reduce 18 omitted

 # reduce 19 omitted

module_eval <<'.,.,', 'mp.y', 56
  def _reduce_20( val, _values, result )
                  result = (val[0].to_i * 60 * 60) +
                           (val[2].to_i * 60)
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 61
  def _reduce_21( val, _values, result )
                  result = (val[0].to_i * 60 * 60) +
                           (val[2].to_i * 60) +
                           (val[4].to_i)
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 68
  def _reduce_22( val, _values, result )
                  result = ::TMail.zonestr2i( result )
   result
  end
.,.,

 # reduce 23 omitted

 # reduce 24 omitted

module_eval <<'.,.,', 'mp.y', 76
  def _reduce_25( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 80
  def _reduce_26( val, _values, result )
                  @field.from = Address.join( val[3] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 84
  def _reduce_27( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

 # reduce 28 omitted

module_eval <<'.,.,', 'mp.y', 90
  def _reduce_29( val, _values, result )
                  @field.by = Address.join( val[1] )
   result
  end
.,.,

 # reduce 30 omitted

module_eval <<'.,.,', 'mp.y', 96
  def _reduce_31( val, _values, result )
                  @field.via = val[1]
   result
  end
.,.,

 # reduce 32 omitted

module_eval <<'.,.,', 'mp.y', 102
  def _reduce_33( val, _values, result )
                  @field.with.push val[1]
   result
  end
.,.,

 # reduce 34 omitted

module_eval <<'.,.,', 'mp.y', 108
  def _reduce_35( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 112
  def _reduce_36( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

 # reduce 37 omitted

module_eval <<'.,.,', 'mp.y', 118
  def _reduce_38( val, _values, result )
                  @field.for_ = val[1].address
   result
  end
.,.,

 # reduce 39 omitted

module_eval <<'.,.,', 'mp.y', 125
  def _reduce_40( val, _values, result )
                  @field.date = val[1]
   result
  end
.,.,

 # reduce 41 omitted

module_eval <<'.,.,', 'mp.y', 131
  def _reduce_42( val, _values, result )
                  @field.route.replace result.route
                  @field.addr = result.addr
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 135
  def _reduce_43( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 136
  def _reduce_44( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 45 omitted

 # reduce 46 omitted

module_eval <<'.,.,', 'mp.y', 143
  def _reduce_47( val, _values, result )
                  result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 147
  def _reduce_48( val, _values, result )
                  result.push val[2]
   result
  end
.,.,

 # reduce 49 omitted

 # reduce 50 omitted

module_eval <<'.,.,', 'mp.y', 154
  def _reduce_51( val, _values, result )
                  val[1].phrase = HFdecoder.decode( result )
                  result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 160
  def _reduce_52( val, _values, result )
                  result = AddressGroup.new( result, val[2] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 166
  def _reduce_53( val, _values, result )
                  result = val[2]
                  result.route = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 171
  def _reduce_54( val, _values, result )
                  result = val[1]
   result
  end
.,.,

 # reduce 55 omitted

module_eval <<'.,.,', 'mp.y', 176
  def _reduce_56( val, _values, result )
 result = [ val[1] ]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 177
  def _reduce_57( val, _values, result )
 result.push val[3]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 179
  def _reduce_58( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 180
  def _reduce_59( val, _values, result )
 result = Address.new( result, nil )
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 182
  def _reduce_60( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 183
  def _reduce_61( val, _values, result )
 result.push val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 185
  def _reduce_62( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 186
  def _reduce_63( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 64 omitted

 # reduce 65 omitted

 # reduce 66 omitted

module_eval <<'.,.,', 'mp.y', 194
  def _reduce_67( val, _values, result )
                  val[1] = val[1].addr
                  result = val.join('')
   result
  end
.,.,

 # reduce 68 omitted

module_eval <<'.,.,', 'mp.y', 199
  def _reduce_69( val, _values, result )
 result << ' ' << val[1]
   result
  end
.,.,

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

module_eval <<'.,.,', 'mp.y', 210
  def _reduce_75( val, _values, result )
                  @field.encrypter = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 214
  def _reduce_76( val, _values, result )
                  @field.encrypter = val[0]
                  @field.keyword   = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 220
  def _reduce_77( val, _values, result )
                  @field.major = val[0].to_i
                  @field.minor = val[2].to_i
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 226
  def _reduce_78( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = val[2]
                  @field.params.replace decode_params(val[3])
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 232
  def _reduce_79( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = ''
                  @field.params.replace decode_params(val[3])
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 239
  def _reduce_80( val, _values, result )
                  result = {}
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 243
  def _reduce_81( val, _values, result )
                  result[ val[2].downcase ] = val[4]
   result
  end
.,.,

 # reduce 82 omitted

 # reduce 83 omitted

module_eval <<'.,.,', 'mp.y', 251
  def _reduce_84( val, _values, result )
                  @field.encoding = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'mp.y', 256
  def _reduce_85( val, _values, result )
                  @field.disposition = val[0]
                  @field.params.replace decode_params(val[1])
   result
  end
.,.,

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 def _reduce_none( val, _values, result )
  result
 end

  end   # class Parser

end   # module TMail
