#
# bench.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# usage:
#
#   str = 'test string'
#   benchmark( 'strdup', 10_0000 ) do
#     str = str.dup
#   end
#

if RUBY_VERSION < '1.7' then
  TIMES_MODULE = Time
else
  TIMES_MODULE = Process
end

def benchmark( label, times, &block )
  begtime = TIMES_MODULE.times.utime
  times.times( &block )
  endtime = TIMES_MODULE.times.utime
  $stderr.printf "%-10s: %f sec\n", label, endtime - begtime
end
