=begin

= fileutils.rb

  Copyright (c) 2000,2001 Minero Aoki <aamine@loveruby.net>

  This program is free software.
  You can distribute/modify this program under the terms of
  the Ruby License.

== module FileUtils

Ūʥե򽸤᤿⥸塼Ǥ⥸塼
̾Ȥ FileUtils::Normal ѰդƤޤ

=== ⥸塼ؿ

--- FileUtils#cd( dir )
--- FileUtils#cd( dir ) {|dir| .... }
  ǥ쥯ȥ dir ˰ưޤ
  ƥ졼ȤƸƤФ줿ϥ֥åλ
  Υǥ쥯ȥޤ

--- FileUtils#pwd
--- FileUtils#getwd
  ȥǥ쥯ȥ֤̾ޤ
  Dir.pwd ƱǤ

--- FileUtils#newest?( newer, older1, older2, ... )
--- FileUtils#uptodate?( newer, older1, older2, ... )
  newer Ƥ older 꿷Ȥ
  ¸ߤʤե̵¤˸ŤȤߤʤޤ

    FileUtils.newest? 'hello.o', 'hello.c', 'hello.h' or system 'make'

--- FileUtils#oldest?( older, newer1, newer2, ... )
  older Ƥ newer ŤȤ
  ¸ߤʤե̵¤˸ŤȤߤʤޤ

    FileUtils.oldest? ''

--- FileUtils#mkdir( dir1, dir2, ... )
  ǥ쥯ȥ dir1dir2 Ĥޤ

    FileUtils.mkdir 'test'
    FileUtils.mkdir 'script', 'text'

--- FileUtils#mkdir_p( dir1, dir2, ... )
  ǥ쥯ȥ dir1, dir2 ĤȤοƥǥ쥯ȥƺޤ
  㤨

    FileUtils.mkdir_p '/usr/local/lib/ruby'

  ϰʲǥ쥯ȥ(ʤ)ޤ
      * /usr
      * /usr/local
      * /usr/local/bin
      * /usr/local/bin/ruby

--- FileUtils#ln( old, new )
  old ؤΥϡɥ new ޤ
  new ǥ쥯ȥʤ new/old ޤ
--- FileUtils#ln( file1, file2 ..., dir )
  file1 ؤΥϡɥ dir/file1file2 ؤΥϡɥ dir/file2 
  ޤ

    FileUtils.ln '

--- FileUtils#ln_s( old, new )
  old ؤΥܥå new ޤ

    File.ln_s 'somefile', 'link_to_somefile'

--- FileUtils#ln_s( file1, file2 ..., dir )
  file1file2 ĤؤΥܥå dir/file1, dir/file2 Ĥ
  ޤdir ǥ쥯ȥǤʤ㳰 Errno::ENOTDIR 
  ȯޤ

--- FileUtils#cp( src, dest )
  ե src  dest ˥ԡޤdest ǥ쥯ȥʤ
  dest/src ˥ԡޤ

    File.cp 'eval.c', 'eval.c.org'

--- FileUtils#cp( file1, file2 ..., dir )
  file1  dir/file1 ˥ԡfile2  dir/file2 ˥ԡ
  Ȥ褦ˡǥ쥯ȥ dir ˥ե file1file2 Ĥ
  Ʊ̾ǥԡޤdir ǥ쥯ȥǤʤ㳰
  Errno::ENOTDIR ȯޤ

    File.cp 'cgi.rb', 'complex.rb', 'date.rb', '/usr/lib/ruby/1.6'

--- FileUtils#cp_r( src, dest )
  src  dest ˥ԡޤsrc ǥ쥯ȥǤäƵŪ
  ԡԤޤκ dest ǥ쥯ȥʤ dest/src 
  ԡޤ

    # installing package "mylib" under the site_ruby
    FileUtils.cp_r 'lib/', site_ruby + '/mylib'

--- FileUtils#cp_r( file1, file2 ..., dir )
  file1file2 Ĥǥ쥯ȥ dir ˥ԡޤ
  file ǥ쥯ȥʤƵŪ˥ԡޤ

    FileUtils.cp_r 'mail.rb', 'field.rb', 'debug/', site_ruby + '/tmail'

--- FileUtils#mv( src, dest )
  from  to ˰ưޤto ǥ쥯ȥʤ to/from 
  ưޤİʾΰͿȤϥǥ쥯ȥ dir 
  ˤ¾Υեưޤ

    FileUtils.mv 'badname.rb', 'goodname.rb'

--- FileUtils#mv( file1, file2 ..., dir )
  file1 file2 Ĥ dir/file1 dir/file2 Ĥ˰ưޤ
  ѡƥޤǰưȤϥԡޤ

    FileUtils.mv 'junk.rb', 'dust.rb', '.trash/'

--- FileUtils#rm( file1, file2, ... )
  file1file2 Ĥõޤ

    FileUtils.rm '/usr/bin/perl'   # :-)

--- FileUtils#rm_f( file1, file2, ... )
  file1file2 Ĥõޤǥ顼Ƥ̵뤷ޤ

    FileUtils.rm_f 'junk.rb', 'dust.rb'
    FileUtils.rm_f Dir['*.so'], Dir['*.o']   # nested array is OK.
    FileUtils.rm_f 'NotExistFile'            # no error

--- FileUtils#rm_rf( file1, file2, ... )
  եޤϥǥ쥯ȥ file1, file2 Ĥõޤ
  ǥ顼Ƥ̵뤷ޤ

    FileUtils.rm_rf '/home'  # if you want to destroy the world

--- FileUtils#cmp( a, b )
--- FileUtils#identical?( a, b )
  ե a  b ƤƱʤ鿿

    FileUtils.cmp 'somefile', 'somefile'  #=> true
    FileUtils.cmp '/bin/cp', '/bin/mv'    #=> maybe false.

--- FileUtils#install( src, dest, mode = <from's> )
  from  to Ƥ㤦Ȥ from  to ˥ԡޤ
  Τ⡼ɤ mode ꤷޤ

    FileUtils.install 'ruby', '/usr/local/bin/ruby', 0755
    FileUtils.install 'lib.rb', '/usr/local/lib/ruby/site_ruby'

--- FileUtils#chmod( mode, file1, file2, ... )
  file1 file2 ĤΥ⡼ɤ mode Ѥޤ
  mode ȬʿȤä chmod 0644, fname Τ褦Ϳޤ

    FileUtils.chmod 0644 'my.rb', 'your.rb'
    FileUtils.chmod 0755 'goodcmd'

== module FileUtils::Verbose

FileUtils::Normal Ʊ᥽åɤƤƱ
ư򤷤ޤ¹ˤ褦ȤƤ뤳Ȥɽޤ

=== ᥽å

---- fileutils_op
---- fileutils_op=( operator )
  ᥽åɤž륪֥ȤǤ
  ǥեȤ FileUtils::Normal Ǥ

---- fileutils_output
---- fileutils_output=( out )
  åϤ륪֥ȤǤ
  out  puts äƤʤФޤ
  ǥեȤ stderr Ǥ

---- fileutils_label
---- fileutils_label=( str )
  åκǽˤĤ٥Ǥ


== module FileUtils::NoWrite

FileUtils::Normal Ʊ᥽åɤƤޤ
ºݤ˥եѹϼ¹Ԥޤ

=end
