#
# pipeline.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'ftools'


def pipelining( fn )
  fn = File.expand_path( fn )
  dir = File.dirname( fn )

  tmpfn = "#{dir}/pipeliningtmp_#{$$}.#{Thread.current.id}"
  mod = File.stat( fn ).mode

  File.open( tmpfn, 'w' ) do |f|
  File.foreach( fn ) do |line|
    f << yield( line )
  end
  end

  File.mv tmpfn, fn
  File.chmod mod, fn
end
