#
# errutil.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#

def _print_bt_all( err )
  print err.to_s, " (#{err.type})\n"
  err.backtrace.each{|i| puts i }
end


def protect( place = nil )
  begin
    ret = yield
  rescue StandardError, NameError
    puts 'Error in ' + place if place
    _print_bt_all $!
    nil
  end

  ret
end
