
require 'racc/parser'
#
# mailp.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'tmail/mails'


module TMail

class Mailp < Racc::Parser

  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && Racc_debug_parser
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  def Mailp.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  NATIVE_ROUTINE = {
    'TMail::MsgidH' => :msgid_parse,
    'TMail::RefH' => :refs_parse
  }

  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    if mid = NATIVE_ROUTINE[ obj.type.name ] then
      send mid, str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = MailScanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]
      @pass_array = [nil, nil]

      do_parse
    end
  end


  private


  def next_token
    if @first then
      ret = @first
      @first = nil
      ret
    else
      @scanner.scan @pass_array
    end
  end
  
  def on_error( tok, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end



  def refs_parse( str )
    arr = []

    while mdata = ::TMail::MSGID.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      proc_phrase pre, arr unless pre.empty?
      arr.push mdata.to_s
    end
    str.strip!
    proc_phrase str, arr if not pre or pre.empty?

    @field.refs.replace arr
  end

  def proc_phrase( str, arr )
    while mdata = /"([^\\]*(?:\\.[^"\\]*)*)"/.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      arr.push pre unless pre.empty?
      arr.push mdata[1]
    end
    str.strip!
    arr.push unless str.empty?
  end


  def msgid_parse( str )
    if mdata = ::TMail::MSGID.match( str ) then
      @field.msgid = mdata.to_s
    else
      raise ParseError, "wrong Message-ID format: #{str}"
    end
  end

##### racc 1.0.0 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 2, 39, :_reduce_1,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_4,
 2, 39, :_reduce_5,
 2, 39, :_reduce_6,
 2, 39, :_reduce_7,
 2, 39, :_reduce_8,
 2, 39, :_reduce_9,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_15,
 2, 39, :_reduce_16,
 6, 40, :_reduce_17,
 0, 55, :_reduce_none,
 2, 55, :_reduce_none,
 3, 56, :_reduce_20,
 5, 56, :_reduce_21,
 1, 57, :_reduce_22,
 7, 41, :_reduce_none,
 0, 58, :_reduce_none,
 2, 58, :_reduce_25,
 4, 58, :_reduce_26,
 3, 58, :_reduce_27,
 0, 59, :_reduce_none,
 2, 59, :_reduce_29,
 0, 60, :_reduce_none,
 2, 60, :_reduce_31,
 0, 61, :_reduce_none,
 2, 61, :_reduce_33,
 0, 62, :_reduce_none,
 2, 62, :_reduce_35,
 2, 62, :_reduce_36,
 0, 63, :_reduce_none,
 2, 63, :_reduce_38,
 0, 64, :_reduce_none,
 2, 64, :_reduce_40,
 2, 42, :_reduce_none,
 1, 42, :_reduce_42,
 1, 43, :_reduce_43,
 3, 43, :_reduce_44,
 1, 44, :_reduce_none,
 1, 44, :_reduce_none,
 1, 45, :_reduce_47,
 3, 45, :_reduce_48,
 1, 46, :_reduce_none,
 1, 46, :_reduce_none,
 2, 46, :_reduce_51,
 4, 67, :_reduce_52,
 4, 66, :_reduce_53,
 3, 66, :_reduce_54,
 2, 69, :_reduce_none,
 2, 70, :_reduce_56,
 4, 70, :_reduce_57,
 3, 54, :_reduce_58,
 1, 54, :_reduce_59,
 1, 71, :_reduce_60,
 3, 71, :_reduce_61,
 1, 65, :_reduce_62,
 3, 65, :_reduce_63,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 3, 47, :_reduce_67,
 1, 68, :_reduce_none,
 2, 68, :_reduce_69,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 48, :_reduce_none,
 3, 48, :_reduce_none,
 1, 49, :_reduce_75,
 2, 49, :_reduce_76,
 3, 50, :_reduce_77,
 4, 51, :_reduce_78,
 2, 51, :_reduce_79,
 0, 75, :_reduce_none,
 5, 75, :_reduce_81,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 52, :_reduce_84,
 2, 53, :_reduce_85,
 0, 77, :_reduce_none,
 3, 77, :_reduce_none,
 0, 78, :_reduce_none,
 3, 78, :_reduce_89,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none ]

racc_reduce_n = 97

racc_shift_n = 162

racc_action_table = [
   -60,    25,    24,   148,   132,    23,    86,    98,    22,    21,
    20,    19,    18,   105,    31,    50,   129,    26,    25,    24,
   -60,    97,    23,   -60,   107,    22,    21,    20,    19,    18,
   -60,    31,   108,   -60,    26,    25,    24,    71,   109,    23,
   104,   103,    22,    21,    20,    19,    18,    72,    31,    25,
    24,    26,   110,    23,   116,   118,    22,    21,    20,    19,
    18,    95,    25,    24,   117,    26,    23,   145,   146,    22,
    21,    20,    19,    18,   112,    25,    24,    88,    26,    23,
    73,    86,    22,    21,    20,    19,    18,   145,   146,    89,
    84,    26,    25,    24,    82,    80,    23,   120,   122,    22,
    21,    20,    19,    18,   117,    25,    24,   117,    26,    23,
   123,   124,    22,    21,    20,    19,    18,   125,    25,    24,
   128,    26,    23,    70,    67,    22,    21,    20,    19,    18,
    64,    31,    25,    24,    26,    61,    23,   117,    99,    22,
    21,    20,    19,    18,   133,    31,    25,    24,    26,   135,
    23,    50,   137,    22,    21,    20,    19,    18,   109,    25,
    24,   138,    26,    23,   117,   139,    22,    21,    20,    19,
    18,   140,    31,    25,    24,    26,   142,    23,   117,    43,
    22,    21,    20,    19,    18,    41,    31,    25,    24,    26,
    87,    23,    39,   150,    22,    21,    20,    19,    18,   152,
    31,    25,    24,    26,   153,    23,    37,   156,    22,    21,
    20,    19,    18,   158,    31,    25,    24,    26,    67,    23,
   160,   161,    22,    21,    20,    19,    18,   nil,    25,    24,
   nil,    26,    23,   nil,   nil,    22,    21,    20,    19,    18,
   nil,    25,    24,   nil,    26,    23,   nil,   nil,    22,    21,
    20,    19,    18,   nil,    31,    25,    24,    26,   nil,    23,
   nil,   nil,    22,    21,    20,    19,    18,   nil,    25,    24,
   nil,    26,    23,   nil,   nil,    22,    21,    20,    19,    18,
   nil,    25,    24,   nil,    26,    23,   nil,   nil,    22,    21,
    20,    19,    18,   nil,    31,    25,    24,    26,   nil,    23,
   nil,   nil,    22,    21,    20,    19,    18,   nil,    25,    24,
   nil,    26,    23,    73,   nil,    22,    21,    20,    19,    18,
   nil,   nil,   nil,   nil,    26,    16,    15,    14,    13,    12,
    11,    10,     9,     8,     7,     6,     5,     4,     3,     2,
     1,    90,    24,   nil,   nil,    23,   nil,    91,    22,    21,
    20,    19,    18,    90,    24,   nil,   nil,    23,   nil,    91,
    22,    21,    20,    19,    18,    90,    24,   nil,   nil,    23,
   nil,    91,    22,    21,    20,    19,    18,    90,    24,   nil,
   nil,    23,   nil,    91,    22,    21,    20,    19,    18,    90,
    24,   nil,   nil,    23,   nil,    91,    22,    21,    20,    19,
    18,    90,    24,   nil,   nil,    23,   nil,    91,    22,    21,
    20,    19,    18,    90,    24,   nil,   nil,    23,   nil,    91,
    22,    21,    20,    19,    18 ]

racc_action_check = [
    32,    11,    11,   140,   120,    11,   114,    68,    11,    11,
    11,    11,    11,    75,    11,   140,   114,    11,     2,     2,
    32,    67,     2,    32,    79,     2,     2,     2,     2,     2,
    32,     2,    80,    32,     2,   150,   150,    29,    81,   150,
    74,    74,   150,   150,   150,   150,   150,    29,   150,    76,
    76,   150,    82,    76,    94,    94,    76,    76,    76,    76,
    76,    65,    84,    84,    94,    76,    84,   138,   138,    84,
    84,    84,    84,    84,    85,    61,    61,    60,    84,    61,
    61,    54,    61,    61,    61,    61,    61,   137,   137,    61,
    49,    61,     7,     7,    43,    41,     7,    96,    98,     7,
     7,     7,     7,     7,   100,     8,     8,   102,     7,     8,
   104,   106,     8,     8,     8,     8,     8,   107,    86,    86,
   109,     8,    86,    17,    16,    86,    86,    86,    86,    86,
    15,    86,    10,    10,    86,    14,    10,   119,    70,    10,
    10,    10,    10,    10,   121,    10,     1,     1,    10,   122,
     1,     9,   125,     1,     1,     1,     1,     1,   127,    12,
    12,   128,     1,    12,   130,   133,    12,    12,    12,    12,
    12,   134,    12,    13,    13,    12,   135,    13,   136,     6,
    13,    13,    13,    13,    13,     5,    13,    55,    55,    13,
    55,    55,     4,   141,    55,    55,    55,    55,    55,   142,
    55,    87,    87,    55,   143,    87,     3,   151,    87,    87,
    87,    87,    87,   152,    87,    50,    50,    87,   156,    50,
   158,   160,    50,    50,    50,    50,    50,   nil,   111,   111,
   nil,    50,   111,   nil,   nil,   111,   111,   111,   111,   111,
   nil,    88,    88,   nil,   111,    88,   nil,   nil,    88,    88,
    88,    88,    88,   nil,    88,    45,    45,    88,   nil,    45,
   nil,   nil,    45,    45,    45,    45,    45,   nil,    72,    72,
   nil,    45,    72,   nil,   nil,    72,    72,    72,    72,    72,
   nil,    33,    33,   nil,    72,    33,   nil,   nil,    33,    33,
    33,    33,    33,   nil,    33,    47,    47,    33,   nil,    47,
   nil,   nil,    47,    47,    47,    47,    47,   nil,    31,    31,
   nil,    47,    31,    31,   nil,    31,    31,    31,    31,    31,
   nil,   nil,   nil,   nil,    31,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   117,   117,   nil,   nil,   117,   nil,   117,   117,   117,
   117,   117,   117,    71,    71,   nil,   nil,    71,   nil,    71,
    71,    71,    71,    71,    71,   116,   116,   nil,   nil,   116,
   nil,   116,   116,   116,   116,   116,   116,    95,    95,   nil,
   nil,    95,   nil,    95,    95,    95,    95,    95,    95,    64,
    64,   nil,   nil,    64,   nil,    64,    64,    64,    64,    64,
    64,    73,    73,   nil,   nil,    73,   nil,    73,    73,    73,
    73,    73,    73,   123,   123,   nil,   nil,   123,   nil,   123,
   123,   123,   123,   123,   123 ]

racc_action_default = [
   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,
   -97,   -97,   -97,   -97,   -97,   -24,   -18,   -97,   -96,   -95,
   -94,   -93,   -92,   -91,   -90,   -72,   -71,   -70,   -60,   -59,
   -16,   -97,   -68,   -97,   -50,   -49,   -15,   -86,   -14,   -84,
   -13,   -80,   -12,   -97,   -11,   -75,   -10,   -73,   -68,    -9,
   -97,    -8,    -7,   -47,    -6,   -97,   -46,   -45,    -5,   -43,
    -4,   -97,   -42,    -3,   -97,   -28,    -2,   -97,   -97,    -1,
   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -69,   -51,   -85,
   -97,   -79,   -97,   -76,   -97,   -97,   -97,   -97,   -97,   -41,
   -66,   -65,   -64,   -62,   -25,   -97,   -30,   -19,   -97,   162,
   -58,   -61,   -56,   -55,   -97,   -54,   -97,   -88,   -80,   -97,
   -77,   -74,   -67,   -48,   -97,   -44,   -97,   -97,   -27,   -29,
   -97,   -32,   -97,   -97,   -53,   -97,   -87,   -78,   -97,   -52,
   -26,   -63,   -31,   -97,   -34,   -97,   -57,   -97,   -97,   -33,
   -97,   -37,   -97,   -97,   -89,   -83,   -82,   -81,   -36,   -35,
   -97,   -39,   -97,   -22,   -17,   -38,   -18,   -23,   -20,   -40,
   -97,   -21 ]

racc_action_pointer = [
   323,   128,     0,   171,   157,   150,   161,    74,    87,   120,
   114,   -17,   141,   155,   104,   108,   105,   123,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    14,
   nil,   290,     0,   263,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    59,   nil,    61,   nil,   237,   nil,   277,   nil,    70,
   197,   nil,   nil,   nil,    61,   169,   nil,   nil,   nil,   nil,
    57,    57,   nil,   nil,   371,    36,   nil,     1,   -11,   nil,
   138,   335,   250,   383,    20,   -19,    31,   nil,   nil,    -6,
    -3,     8,    34,   nil,    44,    42,   100,   183,   223,   nil,
   nil,   nil,   nil,   nil,    31,   359,    71,   nil,    79,   nil,
    71,   nil,    74,   nil,    87,   nil,    79,    82,   nil,    85,
   nil,   210,   nil,   nil,   -14,   nil,   347,   323,   nil,   104,
   -15,   117,   131,   395,   nil,   115,   nil,   128,   124,   nil,
   131,   nil,   nil,   146,   143,   158,   145,    53,    33,   nil,
   -16,   164,   178,   185,   nil,   nil,   nil,   nil,   nil,   nil,
    17,   177,   195,   nil,   nil,   nil,   199,   nil,   199,   nil,
   203,   nil ]

racc_goto_table = [
    47,    69,    58,    59,    55,    55,    51,    30,    28,    36,
    54,   154,    94,    38,    45,    48,    42,    52,    53,   100,
    81,   102,    92,   144,   147,    62,   143,    40,    65,    92,
    96,    92,   121,   134,   141,   151,   157,    75,    28,    44,
    77,    46,    49,   119,    78,    60,   131,    63,    66,    17,
    79,   126,    83,    92,    77,   nil,    85,    28,   nil,   nil,
   nil,   nil,    77,   nil,   130,   nil,    78,    75,    28,   nil,
   nil,   136,   nil,   nil,    92,    92,   111,   nil,   115,   101,
    55,    92,   106,    28,   nil,   nil,   114,   127,   nil,   nil,
   nil,    48,   nil,   113,    53,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    77,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   149,   nil,   nil,
   155,   159,    55 ]

racc_goto_check = [
    30,     2,     6,     6,    30,    30,     9,    16,    34,     8,
     7,    19,    27,    15,    34,    34,    13,     8,     8,    27,
    37,    27,    36,    38,    38,    28,    18,    14,    20,    36,
    21,    36,    22,    23,    24,    25,    26,    16,    34,    12,
    34,    11,    10,    27,    28,     5,    35,     4,     3,     1,
    39,    40,    34,    36,    34,   nil,    16,    34,   nil,   nil,
   nil,   nil,    34,   nil,    27,   nil,    28,    16,    34,   nil,
   nil,    27,   nil,   nil,    36,    36,    30,   nil,     6,    34,
    30,    36,    16,    34,   nil,   nil,     7,    37,   nil,   nil,
   nil,    34,   nil,     8,     8,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    34,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,     9,   nil,   nil,
     6,     2,    30 ]

racc_goto_pointer = [
   nil,    49,   -15,    33,    33,    32,   -10,    -1,     7,    -3,
    34,    34,    33,    11,    23,    10,     6,   nil,  -109,  -132,
    13,   -35,   -64,   -88,  -100,  -106,  -115,   -52,    11,   nil,
    -8,   nil,   nil,   nil,     7,   -71,   -42,   -21,  -114,    13,
   -56 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    57,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    35,    68,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    34,    56,
    33,    76,    74,    29,    32,    93,    27,   nil,   nil,   nil,
   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :KeyH => 10,
 :EncH => 11,
 :VersionH => 12,
 :CTypeH => 13,
 :CEncodingH => 14,
 :CDispositionH => 15,
 :Mbox => 16,
 :Spec => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37 }

racc_nt_base = 38

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n ]

Racc_debug_parser = false

##### racc system variables end #####


 # reduce 0 omitted

 module_eval( <<'.,.,', 'mailp.y', 14 )
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

 module_eval( <<'.,.,', 'mailp.y', 17 )
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 18 )
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 19 )
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 20 )
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 21 )
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 22 )
  def _reduce_9( val, _values, result )
 @field.keys.replace val[1]
   result
  end
.,.,

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 module_eval( <<'.,.,', 'mailp.y', 30 )
  def _reduce_15( val, _values, result )
                  mb = val[1]
                  @field.phrase = mb.phrase
                  @field.setroute mb.route
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 38 )
  def _reduce_16( val, _values, result )
                  mb = val[1]
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 48 )
  def _reduce_17( val, _values, result )
                  t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
                  result = (t + val[4] - val[5]).localtime
   result
  end
.,.,

 # reduce 18 omitted

 # reduce 19 omitted

 module_eval( <<'.,.,', 'mailp.y', 59 )
  def _reduce_20( val, _values, result )
                  result = (result.to_i * 60 * 60) + (val[2].to_i * 60)
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 63 )
  def _reduce_21( val, _values, result )
                  result = (result.to_i * 60 * 60) +
                           (val[2].to_i * 60)
                           + val[4].to_i
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 71 )
  def _reduce_22( val, _values, result )
                  result = ::TMail.zonestr2i( val[0] ) * 60
   result
  end
.,.,

 # reduce 23 omitted

 # reduce 24 omitted

 module_eval( <<'.,.,', 'mailp.y', 81 )
  def _reduce_25( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 85 )
  def _reduce_26( val, _values, result )
                  @field.from = Address.join( val[3] )
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 89 )
  def _reduce_27( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

 # reduce 28 omitted

 module_eval( <<'.,.,', 'mailp.y', 96 )
  def _reduce_29( val, _values, result )
                  @field.by = Address.join( val[1] )
   result
  end
.,.,

 # reduce 30 omitted

 module_eval( <<'.,.,', 'mailp.y', 103 )
  def _reduce_31( val, _values, result )
                  @field.via = val[1]
   result
  end
.,.,

 # reduce 32 omitted

 module_eval( <<'.,.,', 'mailp.y', 110 )
  def _reduce_33( val, _values, result )
                  @field.with.push val[1]
   result
  end
.,.,

 # reduce 34 omitted

 module_eval( <<'.,.,', 'mailp.y', 117 )
  def _reduce_35( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 121 )
  def _reduce_36( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

 # reduce 37 omitted

 module_eval( <<'.,.,', 'mailp.y', 128 )
  def _reduce_38( val, _values, result )
                  @field.for_ = val[1].address
   result
  end
.,.,

 # reduce 39 omitted

 module_eval( <<'.,.,', 'mailp.y', 136 )
  def _reduce_40( val, _values, result )
                  @field.date = val[1]
   result
  end
.,.,

 # reduce 41 omitted

 module_eval( <<'.,.,', 'mailp.y', 143 )
  def _reduce_42( val, _values, result )
                  @field.route.replace result.route
                  @field.addr = result.addr
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 148 )
  def _reduce_43( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 149 )
  def _reduce_44( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 45 omitted

 # reduce 46 omitted

 module_eval( <<'.,.,', 'mailp.y', 158 )
  def _reduce_47( val, _values, result )
                  result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 162 )
  def _reduce_48( val, _values, result )
                  result.push val[2]
   result
  end
.,.,

 # reduce 49 omitted

 # reduce 50 omitted

 module_eval( <<'.,.,', 'mailp.y', 170 )
  def _reduce_51( val, _values, result )
                  val[1].phrase = HFdecoder.decode( result )
                  result = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 177 )
  def _reduce_52( val, _values, result )
                  result = AddressGroup.new( result, val[2] )
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 184 )
  def _reduce_53( val, _values, result )
                  result = val[2]
                  result.route = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 189 )
  def _reduce_54( val, _values, result )
                  result = val[1]
   result
  end
.,.,

 # reduce 55 omitted

 module_eval( <<'.,.,', 'mailp.y', 196 )
  def _reduce_56( val, _values, result )
 result = [ val[1] ]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 197 )
  def _reduce_57( val, _values, result )
 result.push val[3]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 200 )
  def _reduce_58( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 201 )
  def _reduce_59( val, _values, result )
 result = Address.new( result, nil )
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 204 )
  def _reduce_60( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 205 )
  def _reduce_61( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 208 )
  def _reduce_62( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 209 )
  def _reduce_63( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 64 omitted

 # reduce 65 omitted

 # reduce 66 omitted

 module_eval( <<'.,.,', 'mailp.y', 219 )
  def _reduce_67( val, _values, result )
                  val[1] = val[1].addr
                  result = val.join('')
   result
  end
.,.,

 # reduce 68 omitted

 module_eval( <<'.,.,', 'mailp.y', 225 )
  def _reduce_69( val, _values, result )
 result << ' ' << val[1]
   result
  end
.,.,

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

 module_eval( <<'.,.,', 'mailp.y', 239 )
  def _reduce_75( val, _values, result )
                  @field.encrypter = val[0]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 243 )
  def _reduce_76( val, _values, result )
                  @field.encrypter = val[0]
                  @field.keyword   = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 250 )
  def _reduce_77( val, _values, result )
                  @field.major = val[0].to_i
                  @field.minor = val[2].to_i
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 257 )
  def _reduce_78( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = val[2]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 262 )
  def _reduce_79( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = ''
   result
  end
.,.,

 # reduce 80 omitted

 module_eval( <<'.,.,', 'mailp.y', 270 )
  def _reduce_81( val, _values, result )
                  @field.params[ val[2].downcase ] = val[4]
   result
  end
.,.,

 # reduce 82 omitted

 # reduce 83 omitted

 module_eval( <<'.,.,', 'mailp.y', 280 )
  def _reduce_84( val, _values, result )
                  @field.encoding = val[0]
   result
  end
.,.,

 module_eval( <<'.,.,', 'mailp.y', 286 )
  def _reduce_85( val, _values, result )
                  @field.disposition = val[0]
   result
  end
.,.,

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 module_eval( <<'.,.,', 'mailp.y', 298 )
  def _reduce_89( val, _values, result )
                  @field.params[ val[0].downcase ] = val[2]
   result
  end
.,.,

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

end

end   # module TMail
