#
# sendmail.rb
#

require 'tmail/tmail'
require 'net/smtp'
require 'nkf'


mail = TMail::Mail.load_from( ARGV[0] )
to = mail.dest_addrs
fr = mail.from_addrs(nil) || ENV['USER'] + '@' + ENV['HOSTNAME']
mail.delete 'bcc'
mail.delete 'received'
mail.date = Time.now
mail.delete_if {|n,v| v.empty? }
mail.add_header( 'Mime-Version', '1.0' )

textp = false
textp = (/text/i === mail.main_type)
body = mail.body
textp = (NKF.guess( body ) != NKF::BINARY)

if textp then
  mail.body = NKF.nkf( '-j -m0', body )
  mail.set_content_type( 'text', 'plain', {'charset' => 'iso-2022-jp'} )
  mail.encoding = '7bit'
else
  mail.body = [body].pack('m')
  mail.set_content_type( 'application', 'octet-stream' )
  mail.encoding = 'Base64'
end

Net::SMTP.start do |smtp|
  smtp.sendmail mail.encoded, to, fr
end
