#
# version.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#

require 'amstd/must'


class VersionNumber

  include Comparable

  def initialize( maj, min = nil, tee = nil )
    if String === maj then
      maj, min, tee = maj.scan( /(\d+)(?:\.(\d+)(?:\.(\d+))?)?/ )[0]
      maj = maj.to_i if maj
      min = min.to_i if min
      tee = tee.to_i if tee
    end
    maj.must Integer
    if min then
      min.must Integer
      if tee then
        tee.must Integer
      end
    else
      tee = nil
    end

    @major = maj
    @minor = min
    @teeny = tee
  end

  attr :major, true
  attr :minor, true
  attr :teeny

  def teeny=( n )
    @minor ||= 0
    @teeny = n
  end

  def <=>( other )
    if @major > other.major    then  1
    elsif @major < other.major then -1
    else
      if (@minor || 0) > (other.minor || 0)    then  1
      elsif (@minor || 0) < (other.minor || 0) then -1
      else
        if (@teeny || 0) > (other.teeny || 0)    then  1
        elsif (@teeny || 0) < (other.teeny || 0) then -1
        else                                           0
        end
      end
    end
  end

  def to_s
    [ @major, @minor, @teeny ].compact.join('.')
  end

  def inspect
    "\#<Version #{to_s}>"
  end

end
