#
# pipeline.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#

require 'ftools'

def pipelining( fn )
  fn = File.expand_path( fn )
  dir = File.dirname( fn )

  tmpfn = "#{dir}/pipeliningtmp_#{$$}.#{Thread.current.id}"
  mod = File.stat( fn ).mode

  File.open( tmpfn, 'w' ) do |f|
  File.foreach( fn ) do |line|
    f << yield( line )
  end
  end

  File.mv tmpfn, fn
  File.chmod mod, fn
end
