#
#  extmod.rb
#
#    Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#
# usage:
#
#   class State
#     abstract :next_state
#     # classes under State must have 'next_state' method
#   end
#
#   class Address
#     property :addr, String, true, true
#     # 'addr' attribute, type String, both Read and Write is permitted
#   end
#

require 'amstd/to_s'
require 'amstd/must'


class ImplementationError < StandardError ; end

class Module

  def abstract( name )
    mname = _name2str( name )

    module_eval %-
      def #{mname}( *args, &blk )
        raise ImplementationError, "abstract method '#{mname}' called"
      end
    -
  end

  def property( name, tipe, r, w )
    name = _name2str( name )
    tipe = _type2str( tipe )

    if r then
      attr name
    end
    if w then
      module_eval %-
        def #{name}=(arg)
          arg.must #{tipe}
          @#{name} = arg
          arg
        end
      -
    end
  end
  alias attribute property

end
