
require 'racc/parser'
#
# mailp.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'tmail/mails'


module TMail

class Mailp < Racc::Parser

  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && DEBUG_PARSER
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  def Mailp.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  NATIVE_ROUTINE = {
    'TMail::MsgidH' => :msgid_parse,
    'TMail::RefH' => :refs_parse
  }

  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    if mid = NATIVE_ROUTINE[ obj.type.name ] then
      send mid, str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = MailScanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]
      @pass_array = [nil, nil]

      do_parse
    end
  end


  private


  def next_token
    if @first then
      ret = @first
      @first = nil
      ret
    else
      @scanner.scan @pass_array
    end
  end
  
  def on_error( tok, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end



  def refs_parse( str )
    arr = []

    while mdata = ::TMail::MSGID.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      proc_phrase pre, arr unless pre.empty?
      arr.push mdata.to_s
    end
    str.strip!
    proc_phrase str, arr unless pre.empty?

    @field.refs.replace arr
  end

  def proc_phrase( str, arr )
    while mdata = /"([^\\]*(?:\\.[^"\\]*)*)"/.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      arr.push pre unless pre.empty?
      arr.push mdata[1]
    end
    str.strip!
    arr.push unless str.empty?
  end


  def msgid_parse( str )
    if mdata = ::TMail::MSGID.match( str ) then
      @field.msgid = mdata.to_s
    else
      raise ParseError, "wrong Message-ID format: #{str}"
    end
  end

##### racc 0.11.0 generates ###

Racc_reduce_table = [
 0, 0, :racc_error,
 2, 42, :_reduce_1,
 2, 42, :_reduce_none,
 2, 42, :_reduce_none,
 2, 42, :_reduce_4,
 2, 42, :_reduce_5,
 2, 42, :_reduce_6,
 2, 42, :_reduce_7,
 2, 42, :_reduce_8,
 2, 42, :_reduce_9,
 2, 42, :_reduce_10,
 2, 42, :_reduce_none,
 2, 42, :_reduce_none,
 2, 42, :_reduce_none,
 2, 42, :_reduce_none,
 2, 42, :_reduce_none,
 2, 42, :_reduce_16,
 2, 42, :_reduce_17,
 6, 41, :_reduce_18,
 0, 57, :_reduce_none,
 2, 57, :_reduce_none,
 3, 58, :_reduce_21,
 5, 58, :_reduce_22,
 1, 59, :_reduce_23,
 7, 43, :_reduce_24,
 0, 60, :_reduce_none,
 2, 60, :_reduce_26,
 4, 60, :_reduce_27,
 3, 60, :_reduce_28,
 0, 61, :_reduce_none,
 2, 61, :_reduce_30,
 0, 62, :_reduce_none,
 2, 62, :_reduce_32,
 0, 63, :_reduce_33,
 3, 63, :_reduce_34,
 0, 64, :_reduce_none,
 2, 64, :_reduce_36,
 2, 64, :_reduce_37,
 0, 65, :_reduce_none,
 2, 65, :_reduce_39,
 0, 66, :_reduce_none,
 2, 66, :_reduce_41,
 2, 44, :_reduce_none,
 1, 44, :_reduce_43,
 1, 45, :_reduce_44,
 3, 45, :_reduce_45,
 1, 46, :_reduce_none,
 1, 46, :_reduce_none,
 1, 47, :_reduce_48,
 3, 47, :_reduce_49,
 1, 48, :_reduce_none,
 1, 48, :_reduce_none,
 2, 48, :_reduce_52,
 4, 69, :_reduce_53,
 4, 68, :_reduce_54,
 3, 68, :_reduce_55,
 2, 71, :_reduce_none,
 2, 72, :_reduce_57,
 4, 72, :_reduce_58,
 3, 56, :_reduce_59,
 1, 56, :_reduce_60,
 1, 73, :_reduce_61,
 3, 73, :_reduce_62,
 1, 67, :_reduce_63,
 3, 67, :_reduce_64,
 1, 75, :_reduce_none,
 1, 75, :_reduce_none,
 1, 75, :_reduce_none,
 3, 49, :_reduce_68,
 1, 70, :_reduce_none,
 2, 70, :_reduce_70,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 50, :_reduce_none,
 3, 50, :_reduce_none,
 1, 51, :_reduce_76,
 2, 51, :_reduce_77,
 3, 52, :_reduce_78,
 4, 53, :_reduce_79,
 2, 53, :_reduce_80,
 0, 77, :_reduce_none,
 5, 77, :_reduce_82,
 1, 78, :_reduce_none,
 1, 78, :_reduce_none,
 1, 54, :_reduce_85,
 2, 55, :_reduce_86,
 0, 79, :_reduce_none,
 3, 79, :_reduce_none,
 0, 80, :_reduce_none,
 3, 80, :_reduce_90,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none ]

Racc_reduce_n = 98

Racc_shift_n = 164

Racc_action_table = [
     2,    18,     3,    17,     4,    16,     5,    15,     6,    14,
     7,    13,     8,    12,     9,    11,    10,    10,    12,     9,
    13,     8,    14,     7,    15,     6,    16,     5,    17,     4,
    18,     3,    19,     2,    -1,   -98,     0,    19,    -1,   -98,
    36,    32,    20,    31,    21,    30,    24,    29,    27,    28,
    28,    27,    29,    26,    30,    25,    31,    24,    -1,   -98,
    33,    38,    36,    32,    20,    31,    21,    30,    24,    29,
    27,    28,    28,    27,    29,    26,    30,    25,    31,    24,
    -1,   -98,    37,    40,    -1,   -98,    37,    42,    -1,   -98,
    37,    44,    -1,   -98,    20,    46,    -1,   -98,    36,    32,
    20,    31,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    36,    32,
    20,    31,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    11,    52,
    -1,   -98,    33,    54,    -1,   -98,    33,    38,    36,    32,
    20,    31,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    33,    38,
    36,    32,    20,    31,    21,    30,    24,    29,    27,    28,
    28,    27,    29,    26,    30,    25,    31,    24,    -1,   -98,
    33,    38,    36,    32,    20,    31,    21,    30,    24,    29,
    27,    28,    28,    27,    29,    26,    30,    25,    31,    24,
    -1,   -98,    33,    38,    36,    32,    20,    31,    21,    30,
    24,    29,    27,    28,    28,    27,    29,    26,    30,    25,
    31,    24,    -1,   -98,    33,    66,    -1,   -98,    24,    69,
    -1,   -25,    21,    72,    20,   -19,    -1,   -98,     0,    73,
    -1,   -98,    -1,   -71,    -1,   -61,    25,    74,    35,    75,
    -1,   -60,    -1,   -17,    -1,   -97,    -1,   -96,    -1,   -95,
    -1,   -94,    -1,   -93,    -1,   -92,    -1,   -91,    -1,   -73,
    -1,   -72,    25,   -61,     0,   -61,    32,   -61,    22,   -61,
    34,   -61,    35,   -61,    -1,   -69,    33,    38,    36,    32,
    20,    31,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    -1,   -51,
    -1,   -50,    -1,   -16,    25,    81,    36,    32,    20,    31,
    21,    30,    24,    29,    27,    28,    28,    27,    29,    26,
    30,    25,    31,    24,    -1,   -98,    -1,   -15,    -1,   -87,
    -1,   -14,    -1,   -85,    -1,   -13,    38,    83,    -1,   -81,
    -1,   -12,    35,    85,    -1,   -98,     0,   -76,    36,    32,
    20,    31,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    -1,   -11,
    36,    32,    20,    31,    21,    30,    24,    29,    27,    28,
    28,    27,    29,    26,    30,    25,    31,    24,    -1,   -74,
    -1,   -69,     0,   -10,    22,    87,    -1,   -98,    -1,    -9,
    -1,    -8,    36,    32,    20,    31,    21,    30,    24,    29,
    27,    28,    28,    27,    29,    26,    30,    25,    31,    24,
    -1,   -98,    -1,    -7,    -1,   -48,     0,    -6,    22,    89,
    -1,   -98,    23,    90,    33,    38,    36,    32,    20,    31,
    21,    30,    24,    29,    27,    28,    28,    27,    29,    26,
    30,    25,    31,    24,    -1,   -98,    -1,   -47,    -1,   -46,
    -1,    -5,    -1,   -44,     0,    -4,    22,    91,    -1,   -98,
    -1,   -43,    -1,    -3,    25,    81,    36,    32,    20,    31,
    21,    30,    24,    29,    27,    28,    28,    27,    29,    26,
    30,    25,    31,    24,    34,    92,    -1,   -98,    27,    94,
    -1,   -29,    -1,    -2,    26,    99,    20,    98,    21,    30,
    24,    29,    27,    28,    28,    27,    29,    26,    30,    25,
    31,    24,    -1,   -98,    20,   100,    -1,   -98,    -1,    -1,
    22,   101,    -1,   -98,    -1,   164,    26,    99,    20,    98,
    21,    30,    24,    29,    27,    28,    28,    27,    29,    26,
    30,    25,    31,    24,    -1,   -98,    36,    32,    20,    31,
    21,    30,    24,    29,    27,    28,    28,    27,    29,    26,
    30,    25,    31,    24,    -1,   -98,    -1,   -70,    -1,   -52,
    23,   104,    22,   105,    -1,   -98,    34,   106,    -1,   -98,
    36,    32,    20,    31,    21,    30,    24,    29,    27,    28,
    28,    27,    29,    26,    30,    25,    31,    24,    -1,   -98,
    26,    99,    20,    98,    21,    30,    24,    29,    27,    28,
    28,    27,    29,    26,    30,    25,    31,    24,    -1,   -98,
     0,   -86,    32,   109,    -1,   -98,    37,   110,    -1,   -98,
     0,   -80,    32,   111,    -1,   -98,    20,   112,    -1,   -98,
    -1,   -77,    36,    32,    20,    31,    21,    30,    24,    29,
    27,    28,    28,    27,    29,    26,    30,    25,    31,    24,
    -1,   -98,    34,   114,    -1,   -98,    33,    38,    36,    32,
    20,    31,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    33,    38,
    36,    32,    20,    31,    21,    30,    24,    29,    27,    28,
    28,    27,    29,    26,    30,    25,    31,    24,    -1,   -98,
    33,    38,    36,    32,    20,    31,    21,    30,    24,    29,
    27,    28,    28,    27,    29,    26,    30,    25,    31,    24,
    -1,   -98,    -1,   -42,    28,   119,    -1,   -31,    26,    99,
    20,    98,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    -1,   -65,
    -1,   -63,    25,   121,    26,   122,    35,   123,    -1,   -26,
    -1,   -67,    -1,   -66,    21,   124,    -1,   -98,    -1,   -20,
    35,   123,    -1,   -59,    -1,   -62,    -1,   -56,    25,   125,
    -1,   -98,    -1,   -55,    34,   126,    -1,   -98,    35,   123,
    -1,   -57,    37,   128,    -1,   -89,    -1,   -81,    37,   130,
    -1,   -98,    -1,   -78,    36,    32,    20,    31,    21,    30,
    24,    29,    27,    28,    28,    27,    29,    26,    30,    25,
    31,    24,    -1,   -75,    -1,   -68,    -1,   -49,    32,   131,
    22,    89,    -1,   -98,    -1,   -45,    -1,   -33,    21,   133,
    -1,   -98,    35,   123,    -1,   -30,    26,    99,    20,    98,
    21,    30,    24,    29,    27,    28,    28,    27,    29,    26,
    30,    25,    31,    24,    -1,   -98,    -1,   -28,    26,    99,
    20,    98,    21,    30,    24,    29,    27,    28,    28,    27,
    29,    26,    30,    25,    31,    24,    -1,   -98,    20,   136,
    -1,   -98,    26,    99,    20,    98,    21,    30,    24,    29,
    27,    28,    28,    27,    29,    26,    30,    25,    31,    24,
    -1,   -98,    -1,   -54,    -1,   -88,    39,   138,    -1,   -98,
     0,   -79,    32,   111,    -1,   -98,    39,   139,    -1,   -98,
    -1,   -53,    29,   142,    30,   141,    -1,   -35,    -1,   -32,
    35,   123,    -1,   -27,    -1,   -64,    20,   144,    -1,   -98,
    35,   123,    -1,   -58,    37,   147,    36,   146,    -1,   -98,
    37,   147,    36,   146,    -1,   -98,    31,   150,    -1,   -38,
    21,   152,    33,    54,    -1,   -98,    21,   153,    -1,   -98,
    21,   155,    -1,   -98,    23,   156,    -1,   -98,    -1,   -90,
    -1,   -84,    -1,   -83,    -1,   -82,     0,   -40,    32,   158,
    -1,   -98,    33,    38,    36,    32,    20,    31,    21,    30,
    24,    29,    27,    28,    28,    27,    29,    26,    30,    25,
    31,    24,    -1,   -98,    -1,   -36,    -1,   -37,    -1,   -34,
    -1,   -18,    -1,   -23,    20,   160,    -1,   -98,    -1,   -24,
    21,    72,    20,   -19,    -1,   -98,    -1,   -39,    23,   162,
    21,   -21,    -1,   -98,    -1,   -41,    20,   163,    -1,   -98,
    -1,   -22 ]

Racc_action_table_ptr = [
     0,    36,    40,    60,    82,    86,    90,    94,    98,   118,
   138,   142,   146,   168,   190,   212,   234,   238,   242,   248,
   252,   254,   256,   262,   264,   266,   268,   270,   272,   274,
   276,   278,   280,   282,   296,   318,   320,   322,   324,   346,
   348,   350,   352,   354,   356,   360,   362,   366,   388,   390,
   410,   412,   418,   420,   422,   442,   444,   446,   452,   476,
   478,   480,   482,   484,   490,   492,   494,   518,   522,   524,
   544,   548,   550,   554,   556,   576,   596,   598,   600,   606,
   610,   630,   650,   656,   660,   666,   670,   672,   692,   696,
   718,   740,   762,   764,   768,   788,   790,   792,   800,   802,
   804,   808,   810,   814,   816,   818,   822,   824,   828,   832,
   836,   838,   842,   844,   864,   866,   868,   874,   876,   878,
   882,   886,   906,   908,   928,   932,   952,   954,   956,   960,
   966,   970,   972,   978,   980,   984,   986,   990,   994,  1000,
  1006,  1010,  1016,  1020,  1024,  1028,  1030,  1032,  1034,  1036,
  1042,  1064,  1066,  1068,  1070,  1072,  1074,  1078,  1080,  1086,
  1088,  1094,  1096,  1100 ]


Racc_goto_table = [
    42,     1,    76,    20,    74,    21,    73,    22,    56,    23,
    76,    20,    74,    33,    73,    22,    70,    34,    68,    35,
    56,    36,    48,    37,    55,    39,    54,    41,    53,    43,
    52,    45,    74,    47,    76,    20,    51,    48,    76,    20,
    70,    49,    74,    50,    50,    51,    49,    53,    76,    20,
    74,    33,    73,    22,    70,    34,    68,    35,    56,    36,
    48,    55,    76,    20,    74,    33,    73,    22,    70,    34,
    68,    35,    56,    36,    48,    56,    47,    57,    76,    20,
    74,    33,    73,    22,    70,    58,    68,    35,    56,    36,
    69,    59,    48,    60,    46,    61,    76,    20,    74,    33,
    73,    22,    70,    58,    68,    35,    56,    36,    69,    59,
    48,    60,    46,    62,    45,    63,    68,    64,    44,    65,
    60,    67,    43,    68,    57,    70,    41,    71,    76,    20,
    74,    76,    68,    77,    76,    20,    74,    21,    73,    22,
    72,    78,    56,    79,    71,    80,    79,    82,    77,    84,
    74,    86,    76,    20,    76,    20,    74,    76,    76,    20,
    56,    88,    74,    21,    73,    22,    76,    20,    74,    76,
    68,    77,    76,    20,    74,    21,    73,    22,    72,    78,
    56,    79,    71,    80,    61,    93,    76,    95,    75,    96,
    67,    97,    76,    95,    75,    96,    67,   102,    76,    20,
    74,   103,    76,    20,    74,    21,    73,    22,    56,   107,
    76,    95,    75,    96,    67,   108,    76,    20,    70,   113,
    74,    50,    76,    20,    74,    33,    73,    22,    70,    34,
    68,    35,    56,    36,    48,   115,    76,    20,    74,    33,
    73,    22,    70,    34,    68,    35,    56,    36,    47,   116,
    48,    56,    76,    20,    74,    33,    73,    22,    70,    58,
    68,    35,    56,    36,    69,    59,    48,    60,    46,   117,
    62,   118,    76,    95,    75,    96,    67,   120,    80,   127,
    77,   129,    76,    20,    74,    76,    63,   132,    76,    95,
    75,    96,    67,   134,    76,    95,    75,   135,    76,    95,
    75,    96,    67,   137,    64,   140,    58,   143,    78,   145,
    78,   148,    65,   149,    49,   151,    59,   154,    66,   157,
    76,    20,    74,    33,    73,    22,    70,    58,    68,    35,
    56,    36,    69,    59,    48,    60,    46,   159,    41,   161,
    57,    70,    -1,    -1 ]

Racc_goto_table_ptr = [
     0,    -1,     2,    10,    24,    26,    28,    30,    32,    38,
    -1,    46,    48,    62,    78,    96,   116,   120,   124,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,   134,    -1,
   146,    -1,    -1,    -1,   148,    -1,    -1,   150,    -1,   154,
    -1,    -1,    -1,    -1,   158,    -1,    -1,    -1,   166,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,   172,   184,    -1,   186,
    -1,    -1,    -1,    -1,   192,   198,    -1,    -1,    -1,    -1,
   202,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   222,
   236,   252,    -1,   270,   272,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,
   280,    -1,    -1,   282,    -1,    -1,    -1,    -1,   286,    -1,
    -1,   288,    -1,   294,    -1,   298,    -1,    -1,    -1,    -1,
    -1,    -1,   304,    -1,    -1,    -1,   306,    -1,   308,   310,
   312,   314,    -1,   316,    -1,    -1,    -1,    -1,    -1,   318,
   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,
    -1,    -1,    -1,    -1 ]


Racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :RefH => 10,
 :refs => 11,
 :KeyH => 12,
 :EncH => 13,
 :VersionH => 14,
 :CTypeH => 15,
 :CEncodingH => 16,
 :CDispositionH => 17,
 :Mbox => 18,
 :Spec => 19,
 :DIGIT => 20,
 :ATOM => 21,
 "," => 22,
 ":" => 23,
 :FROM => 24,
 "@" => 25,
 :DOMLIT => 26,
 :BY => 27,
 :VIA => 28,
 :WITH => 29,
 :ID => 30,
 :FOR => 31,
 ";" => 32,
 "<" => 33,
 ">" => 34,
 "." => 35,
 :QUOTED => 36,
 :TOKEN => 37,
 "/" => 38,
 "=" => 39 }

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

 module_eval( '', 'mailp.y', 16 ) {
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
 }

 # reduce 2 omitted

 # reduce 3 omitted

 module_eval( '', 'mailp.y', 19 ) {
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 20 ) {
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 21 ) {
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 22 ) {
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 23 ) {
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 24 ) {
  def _reduce_9( val, _values, result )
 @field.refs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 25 ) {
  def _reduce_10( val, _values, result )
 @field.keys.replace val[1]
   result
  end
 }

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 # reduce 15 omitted

 module_eval( '', 'mailp.y', 33 ) {
  def _reduce_16( val, _values, result )
        mb = val[1]
        @field.phrase = mb.phrase
        @field.setroute mb.route
        @field.local  = mb.local
        @field.domain = mb.domain
   result
  end
 }

 module_eval( '', 'mailp.y', 41 ) {
  def _reduce_17( val, _values, result )
        mb = val[1]
        @field.local  = mb.local
        @field.domain = mb.domain
   result
  end
 }

 module_eval( '', 'mailp.y', 51 ) {
  def _reduce_18( val, _values, result )
      t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
   result
  end
 }

 # reduce 19 omitted

 # reduce 20 omitted

 module_eval( '', 'mailp.y', 61 ) {
  def _reduce_21( val, _values, result )
 result = (result.to_i * 60 * 60) + (val[2].to_i * 60)
   result
  end
 }

 module_eval( '', 'mailp.y', 63 ) {
  def _reduce_22( val, _values, result )
 result = (result.to_i * 60 * 60) + (val[2].to_i * 60) + val[4].to_i
   result
  end
 }

 module_eval( '', 'mailp.y', 66 ) {
  def _reduce_23( val, _values, result )
 result = ::TMail.zonestr2i( val[0] ) * 60
   result
  end
 }

 module_eval( '', 'mailp.y', 71 ) {
  def _reduce_24( val, _values, result )
        @field.from  = val[0] if val[0]
        @field.by    = val[1] if val[1]
        @field.via   = val[2] if val[2]
        @field.with.replace val[3]
        @field.msgid = val[4] if val[4]
        @field.for_  = val[5] if val[5]
        @field.date  = val[6] if val[6]
   result
  end
 }

 # reduce 25 omitted

 module_eval( '', 'mailp.y', 84 ) {
  def _reduce_26( val, _values, result )
        result = val[1].join('.')
   result
  end
 }

 module_eval( '', 'mailp.y', 88 ) {
  def _reduce_27( val, _values, result )
        result = val[3].join('.')
   result
  end
 }

 module_eval( '', 'mailp.y', 92 ) {
  def _reduce_28( val, _values, result )
        result = val[1].join('.')
   result
  end
 }

 # reduce 29 omitted

 module_eval( '', 'mailp.y', 99 ) {
  def _reduce_30( val, _values, result )
        result = val[1].join('.')
   result
  end
 }

 # reduce 31 omitted

 module_eval( '', 'mailp.y', 106 ) {
  def _reduce_32( val, _values, result )
        result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 112 ) {
  def _reduce_33( val, _values, result )
        result = []
   result
  end
 }

 module_eval( '', 'mailp.y', 116 ) {
  def _reduce_34( val, _values, result )
        result.push val[2]
   result
  end
 }

 # reduce 35 omitted

 module_eval( '', 'mailp.y', 123 ) {
  def _reduce_36( val, _values, result )
        result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 127 ) {
  def _reduce_37( val, _values, result )
        result = val[1]
   result
  end
 }

 # reduce 38 omitted

 module_eval( '', 'mailp.y', 132 ) {
  def _reduce_39( val, _values, result )
 result = val[1].address
   result
  end
 }

 # reduce 40 omitted

 module_eval( '', 'mailp.y', 136 ) {
  def _reduce_41( val, _values, result )
 result = val[1]
   result
  end
 }

 # reduce 42 omitted

 module_eval( '', 'mailp.y', 142 ) {
  def _reduce_43( val, _values, result )
        @field.route.replace result.route
        @field.addr = result.addr
   result
  end
 }

 module_eval( '', 'mailp.y', 147 ) {
  def _reduce_44( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 148 ) {
  def _reduce_45( val, _values, result )
 result.push val[2]
   result
  end
 }

 # reduce 46 omitted

 # reduce 47 omitted

 module_eval( '', 'mailp.y', 153 ) {
  def _reduce_48( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 154 ) {
  def _reduce_49( val, _values, result )
 result.push val[2]
   result
  end
 }

 # reduce 50 omitted

 # reduce 51 omitted

 module_eval( '', 'mailp.y', 161 ) {
  def _reduce_52( val, _values, result )
        val[1].phrase = HFdecoder.decode( result )
        result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 166 ) {
  def _reduce_53( val, _values, result )
 result = AddressGroup.new( result, val[2] )
   result
  end
 }

 module_eval( '', 'mailp.y', 173 ) {
  def _reduce_54( val, _values, result )
        result = val[2]
        result.route = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 178 ) {
  def _reduce_55( val, _values, result )
        result = val[1]
   result
  end
 }

 # reduce 56 omitted

 module_eval( '', 'mailp.y', 184 ) {
  def _reduce_57( val, _values, result )
 result = [ val[1] ]
   result
  end
 }

 module_eval( '', 'mailp.y', 185 ) {
  def _reduce_58( val, _values, result )
 result.push val[3]
   result
  end
 }

 module_eval( '', 'mailp.y', 188 ) {
  def _reduce_59( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
 }

 module_eval( '', 'mailp.y', 189 ) {
  def _reduce_60( val, _values, result )
 result = Address.new( result, nil )
   result
  end
 }

 module_eval( '', 'mailp.y', 194 ) {
  def _reduce_61( val, _values, result )
        result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 198 ) {
  def _reduce_62( val, _values, result )
        result.push val[2]
   result
  end
 }

 module_eval( '', 'mailp.y', 204 ) {
  def _reduce_63( val, _values, result )
        result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 208 ) {
  def _reduce_64( val, _values, result )
        result.push val[2]
   result
  end
 }

 # reduce 65 omitted

 # reduce 66 omitted

 # reduce 67 omitted

 module_eval( '', 'mailp.y', 219 ) {
  def _reduce_68( val, _values, result )
        val[1] = val[1].addr
        result = val.join('')
   result
  end
 }

 # reduce 69 omitted

 module_eval( '', 'mailp.y', 225 ) {
  def _reduce_70( val, _values, result )
 result << ' ' << val[1]
   result
  end
 }

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

 # reduce 75 omitted

 module_eval( '', 'mailp.y', 249 ) {
  def _reduce_76( val, _values, result )
        @field.encrypter = val[0]
   result
  end
 }

 module_eval( '', 'mailp.y', 253 ) {
  def _reduce_77( val, _values, result )
        @field.encrypter = val[0]
        @field.keyword   = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 260 ) {
  def _reduce_78( val, _values, result )
        @field.major = val[0].to_i
        @field.minor = val[2].to_i
   result
  end
 }

 module_eval( '', 'mailp.y', 267 ) {
  def _reduce_79( val, _values, result )
        @field.main = val[0]
        @field.sub  = val[2]
   result
  end
 }

 module_eval( '', 'mailp.y', 272 ) {
  def _reduce_80( val, _values, result )
        @field.main = val[0]
        @field.sub  = ''
   result
  end
 }

 # reduce 81 omitted

 module_eval( '', 'mailp.y', 280 ) {
  def _reduce_82( val, _values, result )
        @field.params[ val[2].downcase ] = val[4]
   result
  end
 }

 # reduce 83 omitted

 # reduce 84 omitted

 module_eval( '', 'mailp.y', 286 ) {
  def _reduce_85( val, _values, result )
 @field.encoding = val[0]
   result
  end
 }

 module_eval( '', 'mailp.y', 289 ) {
  def _reduce_86( val, _values, result )
 @field.disposition = val[0]
   result
  end
 }

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 module_eval( '', 'mailp.y', 297 ) {
  def _reduce_90( val, _values, result )
 @field.params[ val[0].downcase ] = val[2]
   result
  end
 }

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 # reduce 97 omitted

end

end   # module TMail
