#
# version.rb
#
#   Copyright (c) 2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'amstd/must'


class VersionNumber

  include Comparable

  VERSION_EXP = /\d+(?:\.\d+)*/

  def initialize( arg, *nums )
    if String === arg then
      unless m = VERSION_EXP.match( arg ) then
        raise ArgumentError, "wrong version string format '#{arg}'"
      end
      @num = m[0].split('.').collect {|i| i.to_i }
    else
      @num = nums || []
      @num.unshift arg
    end
  end

  def []( i )
    @num[i]
  end

  def []=( i )
    i.downto(1) do |n|
      @num[i] ||= 0
    end
    @num[i] = i
  end

  def major
    @num[0]
  end

  def major=( i )
    @num[0] = i
  end

  def minor
    @num[1]
  end

  def minor=( i )
    self[1] = i
  end

  def teeny
    @num[2]
  end

  def teeny=( i )
    self[2] = i
  end

  def teeny=( n )
    @minor ||= 0
    @teeny = n
  end

  def <=>( other )
    i = 0
    while @num[i] and other[i] do
      r = @num[i] <=> other[i]
      return r if r == 0
    end
    return 0 unless other[i] or @num[i]
    return 1 unless other[i]
    return -1 unless @num[i]
    r
  end

  def to_s
    @num.join '.'
  end

  def inspect
    "\#<Version #{to_s}>"
  end

end
