#
# recycle.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#


module Recyclable

  BEGIN_GC_SIZE = 5


  def Recyclable.append_features( mod )
    super
    class << mod

    module_eval %-
      @spare = []
      @begin_gc = 5
    -

    def new( *args, &block )
      gavage_collect

      unless @spare.empty? then
        obj = @spare.pop  # recycle
        obj.reset( *args, &block )
      else
        obj = super         # create
      end

      obj
    end

    def use_instance( *args )
      obj = new( *args )
      yield obj
      obj.type.finished obj
    end

    def finished( obj )
      @spare.push obj
      gavage_collect
    end

    private

    def gavage_collect
      if @spare.size > @begin_gc then
        @spare = @spare[ 0, @spare.size / 2 ]
      end
    end

    end   # class << mod
  end

end
