#
# strscan.rb
#
#   Copyright (c) 2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

unless defined? ScanError then
  class ScanError < StandardError; end
end

begin
  require 'strscan.so'
rescue LoadError


class StringScanner

  def initialize( str, dup = true )
    @rest = @str = dup ? str.dup : str
    @prev = nil
    @last_match = nil
  end

  attr :last_match

  def scan( re )
    if m = re.match( @rest ) then
      @last_match = m
      @prev = @rest
      @rest = m.post_match
      m[0]
    else
      @last_match = @prev = nil
      nil
    end
  end

  def skip( re )
    if m = re.match( @rest ) then
      @last_match = m
      @prev = @rest
      @rest = m.post_match
      m.end(0) - m.begin(0)
    else
      @prev = nil
      @last_match = nil
      nil
    end
  end

  def match?( re )
    if m = re.match( @rest ) then
      @last_match = m
      @prev = @rest
      m.end(0) - m.begin(0)
    else
      @prev = nil
      @last_match = nil
      nil
    end
  end

  def check( re )
    if m = re.match( @rest ) then
      @last_match = m
      @prev = @rest
      m[0]
    else
      @prev = @last_match = nil
      nil
    end
  end

  alias scan_until scan
  alias skip_until skip
  alias exist? match?
  alias check_until check

  def getch
    scan /./
  end

  def emtpy?
    @rest.empty?
  end

  def rest?
    not @rest.empty?
  end

  def rest
    @rest.dup
  end

  def restsize
    @rest.size
  end

  def matched?
    not @last_match.nil?
  end

  def matched
    @last_match[0]
  end

  def matchedsize
    m = @last_match
    m.end(0) - m.begin(0)
  end

  def [](n)
    @last_match[n]
  end

  def string
    @str.dup
  end

  def reset
    @rest = @str
    @prev = @last_match = nil
  end

  def clear
    @rest = ''
    @prev = @last_match = nil
  end

  def unscan
    unless @prev then
      raise ScanError, 'cannot unscan: not scanned yet'
    end
    @rest = @prev
    @prev = nil
  end

end   # class StringScanner


end   # ifndef strscan.so
