#
# version.rb
#
#   Copyright (c) 2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'amstd/must'


class VersionNumber

  include Comparable

  VERSION_EXP = /(\d+)(?:\.(\d+)(?:\.(\d+))?)?/

  def initialize( maj, min = nil, tee = nil )
    if String === maj then
      unless m = VERSION_EXP.match( maj ) then
        raise ArgumentError, "wrong version string format '#{maj}'"
      end
      maj = m[1]; min = m[2]; tee = m[3]
      maj = maj.to_i
      min = min.to_i unless min.empty?
      tee = tee.to_i unless tee.empty?
    end
    maj.must Integer
    if min then
      min.must Integer
      if tee then
        tee.must Integer
      end
    else
      tee = nil
    end

    @major = maj
    @minor = min
    @teeny = tee
  end

  attr :major, true
  attr :minor, true
  attr :teeny

  def teeny=( n )
    @minor ||= 0
    @teeny = n
  end

  def <=>( other )
    if @major > other.major    then  1
    elsif @major < other.major then -1
    else
      if (@minor || 0) > (other.minor || 0)    then  1
      elsif (@minor || 0) < (other.minor || 0) then -1
      else
        if (@teeny || 0) > (other.teeny || 0)    then  1
        elsif (@teeny || 0) < (other.teeny || 0) then -1
        else                                           0
        end
      end
    end
  end

  def to_s
    [ @major, @minor, @teeny ].compact.join('.')
  end

  def inspect
    "\#<Version #{to_s}>"
  end

end
