#
# to_s.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#


class Object

  private

  def _name2str( arg )
    if arg.respond_to? :id2name then
      arg.id2name
    else
      arg.to_s
    end
  end

  def _type2str( arg )
    if arg.respond_to? :id2name then
      arg = arg.id2name
    end
    case arg
    when String then arg
    when Array  then arg.collect{|i| _type2str i }.join(',')
    when Module then arg.name
    else
      raise TypeError,
        "wrong arg type #{arg.type} for expected String/Symbol/Module/Array"
    end
  end


  def _name2simbol( arg )
    if arg.respond_to? :id2name then
      arg
    else
      arg.to_s.intern
    end
  end

  def _type2simbol( arg )
    if arg.respond_to? :id2name then
      arg
    else
      arg.to_s.intern
    end
  end

end
