#
# rubyemu.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'amstd/rbparams'


module RubyEmuration

  WITH_EXT = /\.(?:rb|#{RubyParams::DLEXT})\z/o

  def find_feature( feature )
    with_ext( feature ) do |fn|
      $LOAD_PATH.each do |dir|
        path = dir + '/' + fn
        if File.file? path then
          return path
        end
      end
    end

    nil
  end

  def with_ext( feature )
    if WITH_EXT === feature then
      yield feature
    else
      ['rb', RubyParams::DLEXT].each do |ext|
        yield feature + '.' + ext
      end
    end
  end

  def provided?( feature )
    with_ext( feature ) do |fn|
      if $LOAD_PATH.index fn then
        return true
      end
    end

    false
  end
  alias required? provided?

  def provide( feature )
    $LOAD_PATH.push feature
  end

  module_function :find_feature, :required?, :with_ext

end
