#
# to_s.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#


class Object

  private

  def _name2str( arg )
    case arg
    when String then arg
    when Fixnum then arg.id2name
    else
      raise TypeError,
        "wrong arg type #{arg.type} for expected String/Fixnum"
    end
  end

  def _type2str( arg )
    case arg
    when String then arg
    when Fixnum then arg.id2name
    when Module then arg.name
    when Array
      arg.collect{|i| _type2str i }.join(',')
    else
      raise TypeError,
        "wrong arg type #{arg.type} for expected String/Fixnum/Module/Array"
    end
  end


  def _name2simbol( arg )
    case arg
    when Fixnum then arg
    when String then arg.intern
    else
      raise TypeError,
        "wrong arg type #{arg.type} for expected String/Fixnum"
    end
  end

  def _type2simbol( arg )
    case arg
    when String then arg.intern
    when Fixnum then arg
    when Module then arg.name.intern
    else
      raise TypeError,
        "wrong arg type #{arg.type} for expected String/Fixnum/Module"
    end
  end

end
