
require 'racc/parser'
require 'racc/scanner'

#
# mailp.rb
#
#     Copyright(c) 1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#

require 'tmail/mails'

class Mailp < Racc::Parser
  
  MAILP_DEBUG = false

  def initialize
    @scanner = nil
    self.debug = MAILP_DEBUG
  end


  def debug=( flag )
    @yydebug = flag && DEBUG_PARSER
    @scanner_debug = flag
  end


  def debug
    @yydebug
  end


  def Mailp.parse( header, str )
    new.parse( header, str )
  end


  def parse( header, str )
    return if /\A\s*\z/ === str

    @field = header

    case header
    when MsgidH then msgid_parse str
    when RefH   then refs_parse str
    else
      @scanner = MailScanner.new( str, header )
      @scanner.debug = @scanner_debug

      sim = header.type.to_s
      sim = sim.split('::')[-1].to_s.intern
      @first = [sim, nil]

      do_parse
    end
  end


  private


  def next_token
    if s = @first then
      @first = nil
    else
      s = @scanner.scan
    end

    s
  end

  
  def on_error( t, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end


  def refs_parse( str )
    arr = []

    while MsgidH::MSGID === str do
      p = $`
      m = $&
      str = $'

      p.strip!
      arr.push p
      arr.push m
    end
    str.strip!
    arr.push str unless str.empty?

    @field.refs.replace arr
  end


  def msgid_parse( str )
    if MsgidH::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError,
        "wrong Message-ID format: #{str}"
    end
  end


##### racc version 0.10.9 generates ###

LR_reduce_table = [
0, 0, :racc_error,
2, 41, :_reduce_1,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_4,
2, 41, :_reduce_5,
2, 41, :_reduce_6,
2, 41, :_reduce_7,
2, 41, :_reduce_8,
2, 41, :_reduce_9,
2, 41, :_reduce_10,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
6, 40, :_reduce_16,
0, 55, :_reduce_none,
2, 55, :_reduce_none,
3, 56, :_reduce_19,
5, 56, :_reduce_20,
1, 57, :_reduce_21,
7, 42, :_reduce_22,
0, 58, :_reduce_none,
2, 58, :_reduce_24,
4, 58, :_reduce_25,
3, 58, :_reduce_26,
0, 59, :_reduce_none,
2, 59, :_reduce_28,
0, 60, :_reduce_none,
2, 60, :_reduce_30,
0, 61, :_reduce_31,
3, 61, :_reduce_32,
0, 62, :_reduce_none,
2, 62, :_reduce_34,
2, 62, :_reduce_35,
0, 63, :_reduce_none,
2, 63, :_reduce_37,
0, 64, :_reduce_none,
2, 64, :_reduce_39,
2, 43, :_reduce_none,
1, 43, :_reduce_41,
1, 44, :_reduce_42,
3, 44, :_reduce_43,
1, 45, :_reduce_none,
1, 45, :_reduce_none,
1, 46, :_reduce_46,
3, 46, :_reduce_47,
1, 47, :_reduce_none,
1, 47, :_reduce_none,
2, 47, :_reduce_50,
4, 67, :_reduce_51,
4, 66, :_reduce_52,
3, 66, :_reduce_53,
2, 70, :_reduce_none,
2, 71, :_reduce_55,
4, 71, :_reduce_56,
3, 68, :_reduce_57,
1, 68, :_reduce_58,
1, 72, :_reduce_none,
3, 72, :_reduce_60,
1, 65, :_reduce_none,
3, 65, :_reduce_62,
1, 74, :_reduce_none,
1, 74, :_reduce_none,
1, 74, :_reduce_none,
3, 48, :_reduce_66,
1, 69, :_reduce_none,
2, 69, :_reduce_68,
1, 73, :_reduce_none,
1, 73, :_reduce_none,
1, 73, :_reduce_none,
1, 49, :_reduce_none,
3, 49, :_reduce_none,
1, 50, :_reduce_74,
2, 50, :_reduce_75,
3, 51, :_reduce_76,
4, 52, :_reduce_77,
2, 52, :_reduce_78,
0, 76, :_reduce_none,
5, 76, :_reduce_80,
1, 77, :_reduce_none,
1, 77, :_reduce_none,
1, 53, :_reduce_83,
2, 54, :_reduce_84,
0, 78, :_reduce_none,
3, 78, :_reduce_none,
0, 79, :_reduce_none,
3, 79, :_reduce_88,
3, 79, :_reduce_89,
3, 79, :_reduce_90,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none ]

LR_reduce_n = 98

LR_shift_n = 162

LR_action_table = [
     5,     1,     3,     2,    10,     4,    17,     3,     8,     6,
    15,     5,     6,     8,    13,     7,     4,     9,     2,    11,
    12,    12,     9,    14,    16,    13,     7,    16,    14,    15,
    -1,   -98,    26,    17,    22,    20,    29,    21,    25,    22,
    31,    28,    34,    27,    28,    26,    18,    32,    19,    31,
    27,    30,    -1,   -98,    22,    37,    -1,   -23,    35,    40,
    -1,   -98,    11,    42,    -1,   -98,    35,    43,    -1,   -98,
    26,    17,    22,    20,    29,    21,    25,    22,    31,    28,
    34,    27,    28,    26,    18,    32,    19,    31,    27,    30,
    -1,   -98,    26,    17,    22,    20,    29,    21,    25,    22,
    34,    27,    28,    26,    18,    32,    19,    31,    27,    30,
    -1,   -98,    26,    17,    22,    20,    29,    21,    25,    22,
    31,    28,    34,    27,    28,    26,    18,    32,    19,    31,
    27,    30,    -1,   -98,    31,    50,    -1,   -98,     0,    53,
    -1,   -98,    19,    55,    18,   -17,    -1,   -98,    26,    17,
    22,    20,    29,    21,    25,    22,    34,    27,    28,    26,
    18,    32,    19,    31,    27,    30,    -1,   -98,    35,    60,
    -1,   -98,    31,    63,    -1,   -98,    18,    65,    -1,   -98,
    26,    17,    22,    20,    29,    21,    25,    22,    31,    28,
    34,    27,    28,    26,    18,    32,    19,    31,    27,    30,
    -1,   -98,    -1,   -94,    33,    68,    23,    69,    -1,   -58,
    -1,   -48,    -1,   -92,    -1,   -97,    -1,   -93,    -1,   -45,
    -1,   -69,    20,    70,     0,    -4,    -1,   -98,    -1,   -96,
    -1,   -70,    26,    17,    22,    20,    29,    21,    25,    22,
    34,    27,    28,    26,    18,    32,    19,    31,    27,    30,
    23,    74,    -1,   -98,    -1,   -49,    -1,   -95,    -1,   -91,
    -1,   -71,    26,    17,    22,    20,    29,    21,    21,    76,
    25,    22,    31,    28,    34,    27,    28,    26,    18,    32,
    19,    31,    27,    30,    -1,   -98,    -1,   -44,    -1,   -42,
    20,   -59,     0,   -59,    33,   -59,    30,   -59,    32,   -59,
    23,   -59,    -1,   -67,    26,    17,    22,    20,    29,    21,
    25,    22,    28,    26,    24,    81,    18,    83,    19,    31,
    27,    30,    -1,   -98,    25,    85,    -1,   -27,    -1,    -2,
    -1,   -85,    -1,   -15,    -1,    -9,    36,    87,    -1,   -79,
    -1,   -13,    26,    17,    22,    20,    29,    21,    25,    22,
    31,    28,    34,    27,    28,    26,    18,    32,    19,    31,
    27,    30,    -1,   -98,    -1,    -7,    -1,   -11,    26,    17,
     0,   -74,    22,    20,    29,    21,    25,    22,    34,    27,
    28,    26,    18,    32,    19,    31,    27,    30,    -1,   -98,
    -1,    -5,    26,    17,    22,    20,    29,    21,    25,    22,
    34,    27,    28,    26,    32,    90,    18,    32,    19,    31,
    27,    30,    23,    74,    -1,   -98,    -1,   -41,    -1,    -3,
     0,    91,    -1,   -98,    -1,    -1,    20,    92,    -1,   -98,
    18,    93,    -1,   -98,    26,    17,    22,    20,    29,    21,
    25,    22,    34,    27,    28,    26,    18,    32,    19,    31,
    27,    30,    -1,   -72,    -1,   -67,    20,    94,     0,   -10,
    -1,   -98,    -1,   -83,    -1,   -14,    -1,    -8,    26,    17,
    22,    20,    29,    21,    25,    22,    34,    27,    28,    26,
    18,    32,    19,    31,    27,    30,    -1,   -98,    -1,   -12,
    33,    96,    -1,   -98,    20,    97,     0,    -6,    -1,   -98,
    -1,   -46,    26,    17,    22,    20,    29,    21,    25,    22,
    34,    27,    28,    26,    18,    32,    19,    31,    27,    30,
    -1,   -98,    26,    17,    22,    20,    29,    21,    25,    22,
    28,    26,    24,    81,    18,    83,    19,    31,    27,    30,
    -1,   -98,    26,    17,    22,    20,    29,    21,    25,    22,
    31,    28,    34,    27,    28,    26,    18,    32,    19,    31,
    27,    30,    -1,   -98,    32,   101,    -1,   -98,    20,   102,
    21,   103,    -1,   -98,    26,    17,    22,    20,    29,    21,
    25,    22,    34,    27,    28,    26,    18,    32,    19,    31,
    27,    30,    -1,   -98,    26,    17,    22,    20,    29,    21,
    25,    22,    28,    26,    24,    81,    18,    83,    19,    31,
    27,    30,    -1,   -98,    -1,   -59,    26,    17,    22,    20,
    29,    21,    25,    22,    31,    28,    34,    27,    28,    26,
    18,    32,    19,    31,    27,    30,    -1,   -98,    -1,   -50,
    -1,   -68,    -1,   -63,    33,   107,    24,   108,    23,   109,
    -1,   -24,    -1,   -64,    -1,   -61,    -1,   -65,    26,   110,
    -1,   -29,    26,    17,    22,    20,    29,    21,    25,    22,
    28,    26,    24,    81,    18,    83,    19,    31,    27,    30,
    -1,   -98,     0,   -84,    30,   113,    -1,   -98,    35,   114,
    -1,   -98,     0,   -78,    30,   115,    -1,   -98,    -1,   -75,
    -1,   -40,    -1,   162,    -1,   -18,    19,   116,    -1,   -98,
    26,    17,    22,    20,    29,    21,    25,    22,    34,    27,
    28,    26,    18,    32,    19,    31,    27,    30,    -1,   -98,
    32,   118,    -1,   -98,    18,   119,    -1,   -98,    26,    17,
    22,    20,    29,    21,    25,    22,    31,    28,    34,    27,
    28,    26,    18,    32,    19,    31,    27,    30,    -1,   -98,
    -1,   -60,    33,   107,    -1,   -57,    -1,   -43,    -1,   -53,
    23,   121,    -1,   -98,    -1,   -54,    32,   122,    -1,   -98,
    33,   107,    -1,   -55,    20,    97,    30,   123,    -1,   -98,
    26,    17,    22,    20,    29,    21,    25,    22,    28,    26,
    24,    81,    18,    83,    19,    31,    27,    30,    -1,   -98,
    -1,   -26,    26,    17,    22,    20,    29,    21,    25,    22,
    28,    26,    24,    81,    18,    83,    19,    31,    27,    30,
    -1,   -98,    19,   126,    -1,   -98,    -1,   -31,    33,   107,
    -1,   -28,    35,   128,    -1,   -87,    -1,   -79,    35,   131,
    -1,   -98,    18,   132,    -1,   -98,    26,    17,    22,    20,
    29,    21,    25,    22,    34,    27,    28,    26,    18,    32,
    19,    31,    27,    30,    -1,   -73,    -1,   -66,    -1,   -76,
    -1,   -47,    26,    17,    22,    20,    29,    21,    25,    22,
    28,    26,    24,    81,    18,    83,    19,    31,    27,    30,
    -1,   -98,    -1,   -52,    -1,   -51,    -1,   -62,    33,   107,
    -1,   -25,    -1,   -30,    28,   134,    27,   135,    -1,   -33,
    37,   137,    -1,   -98,    -1,   -86,     0,   -77,    30,   115,
    -1,   -98,    37,   138,    -1,   -98,    18,   140,    -1,   -98,
    33,   107,    -1,   -56,    31,    63,    19,   142,    -1,   -98,
    19,   143,    -1,   -98,    29,   144,    -1,   -36,    26,    17,
    22,    20,    29,    21,    25,    22,    38,   147,    34,   148,
    28,    26,    19,    31,    27,    30,    -1,   -98,    35,   149,
    34,   151,    -1,   -98,    19,   152,    -1,   -98,    21,   154,
    -1,   -98,    -1,   -34,    -1,   -35,    -1,   -32,    26,    17,
    22,    20,    29,    21,    25,    22,    31,    28,    34,    27,
    28,    26,    18,    32,    19,    31,    27,    30,    -1,   -98,
     0,   -38,    30,   157,    -1,   -98,    -1,   -90,    -1,   -89,
    -1,   -88,    -1,   -81,    -1,   -80,    -1,   -82,    -1,   -21,
    -1,   -16,    18,   158,    -1,   -98,    -1,   -37,    -1,   -22,
    19,    55,    18,   -17,    -1,   -98,    21,   160,    19,   -19,
    -1,   -98,    -1,   -39,    18,   161,    -1,   -98,    -1,   -20 ]

LR_action_table_ptr = [
     0,    32,    54,    58,    62,    66,    70,    92,   112,   134,
   138,   142,   148,   168,   172,   176,   180,   202,   204,   210,
   212,   214,   216,   218,   220,   222,   228,   230,   232,   254,
   256,   258,   260,   262,   286,   288,   290,   304,   324,   328,
   330,   332,   334,   336,   340,   342,   364,   366,   368,   390,
   392,   416,   418,   420,   424,   426,   430,   434,   454,   456,
   462,   464,   466,   468,   488,   490,   494,   500,   502,   522,
   542,   564,   568,   574,   594,   614,   616,   638,   640,   642,
   644,   652,   654,   656,   658,   662,   682,   688,   692,   698,
   700,   702,   704,   706,   710,   730,   734,   738,   760,   762,
   766,   768,   770,   774,   776,   780,   784,   790,   810,   812,
   832,   836,   838,   842,   846,   848,   852,   856,   876,   878,
   880,   882,   902,   904,   906,   908,   912,   914,   920,   924,
   926,   932,   936,   940,   944,   950,   954,   958,   978,   984,
   988,   992,   994,   996,   998,  1020,  1026,  1028,  1030,  1032,
  1034,  1036,  1038,  1040,  1042,  1046,  1048,  1050,  1056,  1062,
  1064,  1068 ]


LR_goto_table = [
    41,    10,    72,    18,    68,    19,    67,    23,    75,    24,
    44,    25,    66,    29,    69,    33,    47,    34,    45,    35,
    73,    36,    58,    38,    42,    39,    54,    41,    52,    44,
    72,    18,    68,    19,    75,    24,    66,    29,    69,    45,
    47,    46,    73,    36,    75,    24,    50,    47,    73,    48,
    72,    18,    68,    19,    67,    23,    75,    24,    66,    29,
    69,    33,    47,    34,    45,    49,    73,    36,    66,    51,
    43,    52,    40,    54,    55,    56,    75,    24,    69,    57,
    73,    58,    49,    59,    53,    61,    48,    62,    51,    64,
    72,    18,    68,    19,    46,    66,    75,    24,    66,    29,
    69,    45,    47,    67,    73,    36,    72,    18,    68,    71,
    71,    72,    75,    24,    70,    73,    73,    75,    75,    24,
    66,    77,    73,    78,    75,    79,    65,    80,    74,    82,
    59,    84,    78,    86,    76,    88,    75,    24,    66,    77,
    73,    78,    75,    24,    73,    89,    72,    18,    68,    71,
    71,    72,    75,    24,    70,    73,    73,    75,    75,    24,
    73,    78,    68,    95,    72,    18,    75,    24,    73,    75,
    75,    24,    73,    98,    75,    79,    65,    99,    74,    82,
    72,    18,    68,    19,    67,    23,    75,    24,    66,    29,
    69,    33,    47,    34,    45,   100,    73,    36,    72,    18,
    68,   104,    75,    24,    73,    75,    75,    79,    65,   105,
    74,    82,    72,    18,    68,    19,    46,   106,    75,    24,
    66,    29,    69,    45,    47,    67,    73,    36,    60,   111,
    75,    79,    65,   112,    74,    82,    75,    24,    69,   117,
    73,    58,    72,    18,    68,    19,    75,    24,    66,    29,
    69,    45,    47,   120,    73,    36,    75,    79,    74,   124,
    75,    79,    65,   125,    74,    82,    61,   127,    79,   129,
    76,   130,    75,    24,    73,    78,    75,    79,    65,   133,
    74,    82,    62,   136,    56,   139,    48,   141,    63,   145,
    75,   146,    77,   150,    57,   153,    72,    18,    68,    19,
    67,    23,    75,    24,    66,    29,    69,    33,    47,    34,
    45,   155,    73,    36,    64,   156,    40,   159,    55,    56,
    -1,    -1 ]

LR_goto_table_ptr = [
     0,     2,    22,    26,    -1,    28,    30,    44,    50,    68,
    -1,    72,    76,    84,    86,    88,    90,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,    -1,
    -1,    -1,    -1,   118,    -1,    -1,    -1,   124,   130,    -1,
   132,    -1,    -1,   134,    -1,   136,    -1,    -1,   142,    -1,
   146,    -1,    -1,    -1,    -1,    -1,    -1,   158,    -1,    -1,
    -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,   170,   174,
   180,    -1,    -1,   198,   206,    -1,   212,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   228,   230,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   236,    -1,    -1,   242,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   256,    -1,   260,
    -1,   266,    -1,   268,   270,    -1,    -1,   272,    -1,    -1,
    -1,   276,    -1,    -1,    -1,    -1,    -1,   282,    -1,    -1,
    -1,    -1,   284,    -1,   286,    -1,   288,   290,   292,   294,
    -1,    -1,    -1,    -1,   296,   314,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,    -1,
    -1,    -1 ]


LR_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :RefH => 10,
 :refs => 11,
 :KeyH => 12,
 :EncH => 13,
 :VersionH => 14,
 :CTypeH => 15,
 :CEncodingH => 16,
 :CDispositionH => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37,
 :VALUE => 38 }

DEBUG_PARSER = false

##### racc system variables end #####

 # reduce 0 omitted

 def _reduce_1( val, _values, result )
 @field.date = val[1]
  result
 end

 # reduce 2 omitted

 # reduce 3 omitted

 def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
  result
 end

 def _reduce_5( val, _values, result )
 @field.addr = val[1]
  result
 end

 def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
  result
 end

 def _reduce_7( val, _values, result )
 @field.addr = val[1]
  result
 end

 def _reduce_8( val, _values, result )
 @field.msgid = val[1]
  result
 end

 def _reduce_9( val, _values, result )
 @field.refs.replace val[1]
  result
 end

 def _reduce_10( val, _values, result )
 @field.keys.replace val[1]
  result
 end

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 # reduce 15 omitted

 def _reduce_16( val, _values, result )
      t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
  result
 end

 # reduce 17 omitted

 # reduce 18 omitted

 def _reduce_19( val, _values, result )
 result = (val[0].to_i * 60 * 60) + (val[2].to_i * 60)
  result
 end

 def _reduce_20( val, _values, result )
 result = (val[0].to_i * 60 * 60) + (val[2].to_i * 60) + val[4].to_i
  result
 end

 def _reduce_21( val, _values, result )
 result = DateH.zone_s2i( val[0] ) * 60
  result
 end

 def _reduce_22( val, _values, result )
        @field.from  = val[0]
        @field.by    = val[1]
        @field.via   = val[2]
        @field.with.replace val[3]
        @field.msgid = val[4]
        @field.ford  = val[5]
        @field.date  = val[6]
  result
 end

 # reduce 23 omitted

 def _reduce_24( val, _values, result )
      result = val[1]
  result
 end

 def _reduce_25( val, _values, result )
        result = val[3]
  result
 end

 def _reduce_26( val, _values, result )
        result = val[1]
  result
 end

 # reduce 27 omitted

 def _reduce_28( val, _values, result )
        result = val[1]
  result
 end

 # reduce 29 omitted

 def _reduce_30( val, _values, result )
        result = val[1]
  result
 end

 def _reduce_31( val, _values, result )
        result = []
  result
 end

 def _reduce_32( val, _values, result )
        result.push val[2]
  result
 end

 # reduce 33 omitted

 def _reduce_34( val, _values, result )
        result = val[1]
  result
 end

 def _reduce_35( val, _values, result )
        result = val[1]
  result
 end

 # reduce 36 omitted

 def _reduce_37( val, _values, result )
 result = val[1]
  result
 end

 # reduce 38 omitted

 def _reduce_39( val, _values, result )
 result = val[1]
  result
 end

 # reduce 40 omitted

 def _reduce_41( val, _values, result )
        @field.routes.replace result.routes
        @field.addr = result.addr
  result
 end

 def _reduce_42( val, _values, result )
 result = val
  result
 end

 def _reduce_43( val, _values, result )
 result.push val[2]
  result
 end

 # reduce 44 omitted

 # reduce 45 omitted

 def _reduce_46( val, _values, result )
 result = val
  result
 end

 def _reduce_47( val, _values, result )
 result.push val[2]
  result
 end

 # reduce 48 omitted

 # reduce 49 omitted

 def _reduce_50( val, _values, result )
        val[1].phrase = Bencode.decode( val[0] )
        result = val[1]
  result
 end

 def _reduce_51( val, _values, result )
 result = AddrGroup.new( val[0], val[2] )
  result
 end

 def _reduce_52( val, _values, result )
        val[2].route.replace val[1]
        result = val[2]
  result
 end

 def _reduce_53( val, _values, result )
 result = val[1]
  result
 end

 # reduce 54 omitted

 def _reduce_55( val, _values, result )
 result = [ val[1] ]
  result
 end

 def _reduce_56( val, _values, result )
 result.push val[3]
  result
 end

 def _reduce_57( val, _values, result )
 result = Mbox.new( val.join('') )
  result
 end

 def _reduce_58( val, _values, result )
 result = Mbox.new( val[0] )
  result
 end

 # reduce 59 omitted

 def _reduce_60( val, _values, result )
        result.concat val[1]
        result.concat val[2]
  result
 end

 # reduce 61 omitted

 def _reduce_62( val, _values, result )
        result.concat val[1]
        result.concat val[2]
  result
 end

 # reduce 63 omitted

 # reduce 64 omitted

 # reduce 65 omitted

 def _reduce_66( val, _values, result )
 result = '<' + val[1].addr + '>'
  result
 end

 # reduce 67 omitted

 def _reduce_68( val, _values, result )
 result << ' ' << val[1]
  result
 end

 # reduce 69 omitted

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 def _reduce_74( val, _values, result )
 @field.encrypter = val[0]
  result
 end

 def _reduce_75( val, _values, result )
        @field.encrypter = val[0]
        @field.keyword   = val[1]
  result
 end

 def _reduce_76( val, _values, result )
        @field.major = val[0].to_i
        @field.minor = val[2].to_i
  result
 end

 def _reduce_77( val, _values, result )
        @field.main = val[0]
        @field.sub  = val[2]
  result
 end

 def _reduce_78( val, _values, result )
        @field.main = val[0]
        @field.sub  = ''
  result
 end

 # reduce 79 omitted

 def _reduce_80( val, _values, result )
 @field.params.store( val[2].downcase, val[4] )
  result
 end

 # reduce 81 omitted

 # reduce 82 omitted

 def _reduce_83( val, _values, result )
 @field.encoding = val[0]
  result
 end

 def _reduce_84( val, _values, result )
 @field.disposition = val[0]
  result
 end

 # reduce 85 omitted

 # reduce 86 omitted

 # reduce 87 omitted

 def _reduce_88( val, _values, result )
 @field.params.store( val[0].downcase, val[2] )
  result
 end

 def _reduce_89( val, _values, result )
 @field.params.store( val[0].downcase, val[2] )
  result
 end

 def _reduce_90( val, _values, result )
 @field.params.store( val[0].downcase, val[2] )
  result
 end

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 # reduce 97 omitted

end
