  
  MAILP_DEBUG = false

  def initialize
    @scanner = nil
    self.debug = MAILP_DEBUG
  end


  def debug=( flag )
    @yydebug = flag && DEBUG_PARSER
    @scanner_debug = flag
  end


  def debug
    @yydebug
  end


  def Mailp.parse( header, str )
    new.parse( header, str )
  end


  def parse( header, str )
    return if /\A\s*\z/ === str

    @field = header

    case header
    when MsgidH then msgid_parse str
    when RefH   then refs_parse str
    else
      @scanner = MailScanner.new( str, header )
      @scanner.debug = @scanner_debug

      sim = header.type.to_s
      sim = sim.split('::')[-1].to_s.intern
      @first = [sim, nil]

      do_parse
    end
  end


  private


  def next_token
    if s = @first then
      @first = nil
    else
      s = @scanner.scan
    end

    s
  end

  
  def on_error( t, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end


  def refs_parse( str )
    arr = []

    while MsgidH::MSGID === str do
      p = $`
      m = $&
      str = $'

      p.strip!
      arr.push p
      arr.push m
    end
    str.strip!
    arr.push str unless str.empty?

    @field.refs.replace arr
  end


  def msgid_parse( str )
    if MsgidH::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError,
        "wrong Message-ID format: #{str}"
    end
  end

