#
# rbparam.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#

require 'rbconfig'


module RubyParams

  CONFIG     = Config::CONFIG

  RUBY       = CONFIG['ruby_install_name']

  BINDIR     = File.join( CONFIG['bindir'] )
  LIBDIR     = File.join( CONFIG['libdir'],
                          'ruby',
                          CONFIG['MAJOR'] + '.' + CONFIG['MINOR'] )
  SITELIBDIR = File.join( LIBDIR, 'site_ruby' )

  ARCH       = CONFIG['arch']

  RBDIR      = File.join( LIBDIR )
  SODIR      = File.join( LIBDIR, ARCH )

  SITE_RB    = File.join( SITELIBDIR )
  SITE_SO    = File.join( SITELIBDIR, ARCH )

  RUBY_PATH  = File.join( BINDIR, RUBY )

  DL_EXT     = CONFIG['DLEXT']
  Extentions = [ 'rb', DL_EXT ]

end
