
require 'racc/parser'
require 'racc/scanner'

#
# mailp.rb
#
#     Copyright(c) 1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#

require 'tmail/mails'

class Mailp < Racc::Parser
  
  MAILP_DEBUG = false

  def initialize
    @scanner = nil
    self.debug = MAILP_DEBUG
  end


  def debug=( flag )
    @yydebug = flag && DEBUG_PARSER
    @scanner_debug = flag
  end


  def debug
    @yydebug
  end


  def Mailp.parse( header, str )
    new.parse( header, str )
  end


  def parse( header, str )
    return if /\A\s+\z/ === str

    @field = header

    case header
    when MsgidH then msgid_parse str
    when RefH   then refs_parse str
    else
      @scanner = MailScanner.new( str, header )
      @scanner.debug = @scanner_debug

      sim = header.type.to_s
      sim = sim.split('::')[-1].to_s.intern
      @first = [sim, nil]

      do_parse
    end
  end


  private


  def next_token
    if s = @first then
      @first = nil
    else
      s = @scanner.scan
    end

    s
  end

  
  def on_error( t, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end


  def refs_parse( str )
    arr = []

    while MsgidH::MSGID === str do
      p = $`
      m = $&
      str = $'

      p.strip!
      arr.push p
      arr.push m
    end
    str.strip!
    arr.push str unless str.empty?

    @field.refs.replace arr
  end


  def msgid_parse( str )
    if MsgidH::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError,
        "wrong Message-ID format: #{str}"
    end
  end


##### racc version 0.10.8 generates ###

LR_reduce_table = [
0, 0, :racc_error,
2, 41, :_reduce_1,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_4,
2, 41, :_reduce_5,
2, 41, :_reduce_6,
2, 41, :_reduce_7,
2, 41, :_reduce_8,
2, 41, :_reduce_9,
2, 41, :_reduce_10,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
2, 41, :_reduce_none,
6, 40, :_reduce_16,
0, 55, :_reduce_none,
2, 55, :_reduce_none,
3, 56, :_reduce_19,
5, 56, :_reduce_20,
1, 57, :_reduce_21,
7, 42, :_reduce_22,
0, 58, :_reduce_none,
2, 58, :_reduce_24,
4, 58, :_reduce_25,
3, 58, :_reduce_26,
0, 59, :_reduce_none,
2, 59, :_reduce_28,
0, 60, :_reduce_none,
2, 60, :_reduce_30,
0, 61, :_reduce_31,
3, 61, :_reduce_32,
0, 62, :_reduce_none,
2, 62, :_reduce_34,
2, 62, :_reduce_35,
0, 63, :_reduce_none,
2, 63, :_reduce_37,
0, 64, :_reduce_none,
2, 64, :_reduce_39,
2, 43, :_reduce_none,
1, 43, :_reduce_41,
1, 44, :_reduce_42,
3, 44, :_reduce_43,
1, 45, :_reduce_none,
1, 45, :_reduce_none,
1, 46, :_reduce_46,
3, 46, :_reduce_47,
1, 47, :_reduce_none,
1, 47, :_reduce_none,
2, 47, :_reduce_50,
4, 67, :_reduce_51,
4, 66, :_reduce_52,
3, 66, :_reduce_53,
2, 70, :_reduce_none,
2, 71, :_reduce_55,
4, 71, :_reduce_56,
3, 68, :_reduce_57,
1, 68, :_reduce_58,
1, 72, :_reduce_none,
3, 72, :_reduce_60,
1, 65, :_reduce_none,
3, 65, :_reduce_62,
1, 74, :_reduce_none,
1, 74, :_reduce_none,
1, 74, :_reduce_none,
3, 48, :_reduce_66,
1, 69, :_reduce_none,
2, 69, :_reduce_68,
1, 73, :_reduce_none,
1, 73, :_reduce_none,
1, 73, :_reduce_none,
1, 49, :_reduce_none,
3, 49, :_reduce_none,
1, 50, :_reduce_74,
2, 50, :_reduce_75,
3, 51, :_reduce_76,
4, 52, :_reduce_77,
2, 52, :_reduce_78,
0, 76, :_reduce_none,
5, 76, :_reduce_80,
1, 77, :_reduce_none,
1, 77, :_reduce_none,
1, 53, :_reduce_83,
2, 54, :_reduce_84,
0, 78, :_reduce_none,
3, 78, :_reduce_none,
0, 79, :_reduce_none,
3, 79, :_reduce_88,
3, 79, :_reduce_89,
3, 79, :_reduce_90,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none ]

LR_reduce_n = 98

LR_shift_n = 162

LR_action_table = [
     6,     2,    13,     1,     4,     3,     2,     5,    12,     6,
     9,     8,    16,     7,     7,    10,    14,     9,     5,    11,
     3,    12,    10,    14,    17,    13,     8,    16,    15,    15,
    -1,   -98,    34,    18,    28,    17,    18,    20,    27,    19,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    34,    18,    28,    17,    18,    20,    27,    19,
    31,    35,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    31,    39,    -1,   -98,     0,    41,
    -1,   -98,    18,   -17,    19,    43,    -1,   -98,    34,    18,
    28,    17,    18,    20,    27,    19,    19,    22,    26,    24,
    22,    25,    29,    26,    25,    27,    -1,   -98,    35,    48,
    -1,   -98,    31,    50,    -1,   -98,    18,    52,    -1,   -98,
    34,    18,    28,    17,    18,    20,    27,    19,    31,    35,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    34,    18,    28,    17,    18,    20,    27,    19,
    31,    35,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    22,    60,    -1,   -23,    35,    63,
    -1,   -98,    11,    64,    -1,   -98,    35,    65,    -1,   -98,
    34,    18,    28,    17,    18,    20,    27,    19,    31,    35,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    -1,   -96,    -1,   -70,    -1,   -95,    -1,   -71,
    -1,   -11,    -1,   -91,    34,    18,    28,    17,    18,    20,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
     0,   -74,    25,    27,    -1,   -98,    -1,   -94,    -1,   -92,
    -1,   -97,    -1,   -93,    -1,   -69,    -1,   -49,    33,    69,
    23,    70,    -1,   -58,    34,    18,    28,    17,    21,    72,
    18,    20,    27,    19,    31,    35,    19,    22,    26,    24,
    22,    25,    29,    26,    25,    27,    -1,   -98,    -1,   -44,
    -1,    -5,    20,   -59,    33,   -59,    30,   -59,    32,   -59,
     0,   -59,    23,   -59,    -1,   -67,    34,    18,    28,    17,
    18,    20,    27,    19,    19,    22,    26,    24,    22,    25,
    29,    26,    23,    78,    25,    27,    -1,   -98,    -1,   -48,
    -1,   -45,    -1,   -41,    34,    18,    28,    17,    18,    20,
    27,    19,    19,    22,    26,    24,    32,    79,    22,    25,
    29,    26,    23,    78,    25,    27,    -1,   -98,    -1,    -3,
     0,    80,    -1,   -98,    18,    81,    -1,   -98,    20,    82,
    -1,   -98,    -1,    -1,    34,    18,    28,    17,    18,    20,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -72,    -1,   -67,    20,    83,     0,   -10,
    -1,   -98,    -1,   -83,    -1,   -14,    34,    18,    28,    17,
    18,    20,    27,    19,    19,    22,    26,    24,    22,    25,
    29,    26,    25,    27,    -1,   -98,    -1,    -8,    33,    85,
    -1,   -98,    -1,   -12,    34,    18,    28,    17,    18,    20,
    27,    19,    31,    35,    19,    22,    26,    24,    22,    25,
    29,    26,    25,    27,    -1,   -98,    -1,   -46,    20,    86,
     0,    -6,    -1,   -98,    -1,   -42,    20,    87,     0,    -4,
    -1,   -98,    -1,    -2,    28,    17,    24,    89,    18,    91,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    25,    94,    -1,   -27,    -1,   -15,
    -1,   -85,    -1,    -9,    36,    96,    -1,   -79,    -1,   -13,
    -1,    -7,    -1,   -75,    34,    18,    28,    17,    18,    20,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    28,    17,    24,    89,    18,    91,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    -1,   -50,    34,    18,    28,    17,
    18,    20,    27,    19,    31,    35,    19,    22,    26,    24,
    22,    25,    29,    26,    25,    27,    -1,   -98,    -1,   -68,
    34,    18,    28,    17,    18,    20,    27,    19,    19,    22,
    26,    24,    22,    25,    29,    26,    25,    27,    -1,   -98,
    -1,   -59,    32,   102,    -1,   -98,    20,   103,    21,   104,
    -1,   -98,    28,    17,    24,    89,    18,    91,    27,    19,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    -1,   -40,    -1,   162,    19,   106,    -1,   -98,
    -1,   -18,    34,    18,    28,    17,    18,    20,    27,    19,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    32,   108,    -1,   -98,    18,   109,    -1,   -98,
    34,    18,    28,    17,    18,    20,    27,    19,    31,    35,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    34,    18,    28,    17,    18,    20,    27,    19,
    31,    35,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    24,   112,    33,   113,    23,   114,
    -1,   -24,    -1,   -64,    -1,   -61,    -1,   -65,    -1,   -63,
    26,   116,    -1,   -29,    28,    17,    24,    89,    18,    91,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    -1,   -98,    30,   118,     0,   -84,    -1,   -98,
    35,   119,    -1,   -98,    30,   120,     0,   -78,    -1,   -98,
    -1,   -60,    33,   113,    -1,   -57,    20,    86,    30,   121,
    -1,   -98,    32,   122,    -1,   -98,    -1,   -53,    23,   123,
    -1,   -98,    -1,   -54,    33,   113,    -1,   -55,    18,   124,
    -1,   -98,    34,    18,    28,    17,    18,    20,    27,    19,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -73,    -1,   -66,    -1,   -76,    -1,   -47,    -1,   -43,
    -1,   -26,    28,    17,    24,    89,    18,    91,    27,    19,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    28,    17,    24,    89,    18,    91,    27,    19,
    19,    22,    26,    24,    22,    25,    29,    26,    25,    27,
    -1,   -98,    -1,   -31,    19,   128,    -1,   -98,    33,   113,
    -1,   -28,    35,   129,    -1,   -87,    -1,   -79,    35,   132,
    -1,   -98,    -1,   -51,    -1,   -52,    28,    17,    24,    89,
    18,    91,    27,    19,    19,    22,    26,    24,    22,    25,
    29,    26,    25,    27,    -1,   -98,    18,   134,    -1,   -98,
    -1,   -62,    33,   113,    -1,   -25,    28,   136,    27,   137,
    -1,   -33,    -1,   -30,    37,   139,    -1,   -98,    -1,   -86,
    30,   120,     0,   -77,    -1,   -98,    37,   140,    -1,   -98,
    33,   113,    -1,   -56,    21,   141,    -1,   -98,    19,   143,
    -1,   -98,    19,   144,    31,    50,    -1,   -98,    19,   146,
    -1,   -98,    29,   147,    -1,   -36,    34,   149,    28,    17,
    27,    19,    19,    22,    26,    24,    22,    25,    29,    26,
    25,    27,    38,   151,    -1,   -98,    34,   152,    35,   154,
    -1,   -98,    18,   155,    -1,   -98,    -1,   -16,    -1,   -21,
    -1,   -35,    -1,   -34,    -1,   -32,    34,    18,    28,    17,
    18,    20,    27,    19,    31,    35,    19,    22,    26,    24,
    22,    25,    29,    26,    25,    27,    -1,   -98,    30,   157,
     0,   -38,    -1,   -98,    -1,   -88,    -1,   -90,    -1,   -89,
    -1,   -82,    -1,   -80,    -1,   -81,    21,   159,    19,   -19,
    -1,   -98,    -1,   -37,    18,   -17,    19,    43,    -1,   -98,
    -1,   -22,    18,   161,    -1,   -98,    -1,   -39,    -1,   -20 ]

LR_action_table_ptr = [
     0,    32,    52,    74,    78,    82,    88,   108,   112,   116,
   120,   142,   164,   168,   172,   176,   180,   202,   204,   206,
   208,   210,   212,   214,   236,   238,   240,   242,   244,   246,
   248,   254,   278,   280,   282,   296,   318,   320,   322,   324,
   348,   350,   354,   358,   362,   364,   384,   386,   392,   394,
   396,   416,   418,   422,   424,   446,   448,   454,   456,   462,
   464,   484,   488,   490,   492,   494,   498,   500,   502,   504,
   524,   544,   546,   568,   570,   590,   592,   596,   602,   622,
   624,   626,   630,   632,   652,   656,   660,   682,   704,   712,
   714,   716,   718,   720,   724,   744,   750,   754,   760,   762,
   766,   772,   776,   778,   782,   784,   788,   792,   812,   814,
   816,   818,   820,   822,   842,   862,   864,   868,   872,   876,
   878,   882,   884,   886,   906,   910,   912,   916,   922,   924,
   928,   930,   936,   940,   944,   948,   952,   958,   962,   966,
   986,   992,   996,   998,  1000,  1002,  1004,  1006,  1028,  1034,
  1036,  1038,  1040,  1042,  1044,  1046,  1052,  1054,  1060,  1062,
  1066,  1068 ]


LR_goto_table = [
    41,     4,    50,    21,    73,    23,    75,    28,    66,    29,
    72,    30,    69,    31,    47,    32,    45,    33,    73,    34,
    68,    36,    67,    37,    75,    28,    66,    38,    43,    40,
    55,    42,    40,    44,    69,    45,    73,    46,    49,    47,
    75,    28,    53,    49,    48,    51,    51,    53,    66,    29,
    72,    30,    69,    54,    47,    55,    73,    34,    68,    36,
    46,    56,    75,    28,    66,    29,    72,    30,    69,    31,
    47,    32,    45,    57,    73,    34,    68,    36,    67,    37,
    75,    28,    44,    58,    42,    59,    58,    61,    54,    62,
    52,    66,    66,    29,    72,    30,    69,    54,    47,    67,
    73,    34,    68,    36,    75,    28,    73,    68,    75,    28,
    66,    71,    73,    73,    75,    28,    70,    74,    72,    30,
    73,    75,    68,    76,    71,    77,    75,    28,    70,    74,
    72,    30,    73,    75,    68,    76,    71,    77,    75,    28,
    73,    73,    75,    28,    72,    30,    73,    75,    68,    84,
    75,    28,    66,    71,    73,    73,    75,    28,    65,    88,
    74,    90,    75,    92,    59,    93,    78,    95,    76,    97,
    73,    98,    75,    28,    65,    99,    74,    90,    75,    92,
    66,    29,    72,    30,    69,    54,    47,    55,    73,    34,
    68,    36,    46,   100,    75,    28,    72,    30,    73,    75,
    68,   101,    75,    28,    65,   105,    74,    90,    75,    92,
    69,   107,    73,    46,    75,    28,    66,    29,    72,    30,
    69,    54,    47,   110,    73,    34,    68,    36,    75,    28,
    66,    29,    72,    30,    69,    31,    47,    32,    45,   111,
    73,    34,    68,    36,    67,    37,    75,    28,    60,   115,
    65,   117,    74,    90,    75,    92,    73,    73,    75,    28,
    74,   125,    75,    92,    65,   126,    74,    90,    75,    92,
    61,   127,    79,   130,    76,   131,    65,   133,    74,    90,
    75,    92,    56,   135,    62,   138,    57,   142,    48,   145,
    63,   148,    75,   150,    77,   153,    66,    29,    72,    30,
    69,    31,    47,    32,    45,   156,    73,    34,    68,    36,
    67,    37,    75,    28,    64,   158,    55,    42,    40,   160,
    -1,    -1 ]

LR_goto_table_ptr = [
     0,     2,     8,    26,    -1,    30,    34,    42,    44,    46,
    48,    64,    84,    88,    -1,    90,    92,    -1,    -1,    -1,
    -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   110,    -1,    -1,    -1,   116,    -1,    -1,    -1,   128,
    -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,
   144,    -1,    -1,    -1,   152,    -1,    -1,    -1,    -1,    -1,
   158,   164,    -1,   166,    -1,   168,    -1,    -1,    -1,   170,
   174,    -1,   180,    -1,   196,    -1,    -1,    -1,   204,    -1,
    -1,    -1,    -1,   210,    -1,    -1,   216,   230,    -1,    -1,
    -1,    -1,    -1,   248,   250,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,
    -1,    -1,    -1,   260,   264,   270,    -1,    -1,   272,   274,
    -1,    -1,    -1,   276,   282,    -1,    -1,   284,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   286,   288,    -1,   290,   292,
   294,    -1,    -1,    -1,    -1,    -1,    -1,   296,   314,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,    -1,
    -1,    -1 ]


LR_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :RefH => 10,
 :refs => 11,
 :KeyH => 12,
 :EncH => 13,
 :VersionH => 14,
 :CTypeH => 15,
 :CEncodingH => 16,
 :CDispositionH => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37,
 :VALUE => 38 }

DEBUG_PARSER = false

##### racc system variables end #####

 # reduce 0 omitted

 def _reduce_1( val, _values, result )
 @field.date = val[1]
  result
 end

 # reduce 2 omitted

 # reduce 3 omitted

 def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
  result
 end

 def _reduce_5( val, _values, result )
 @field.addr = val[1]
  result
 end

 def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
  result
 end

 def _reduce_7( val, _values, result )
 @field.addr = val[1]
  result
 end

 def _reduce_8( val, _values, result )
 @field.msgid = val[1]
  result
 end

 def _reduce_9( val, _values, result )
 @field.refs.replace val[1]
  result
 end

 def _reduce_10( val, _values, result )
 @field.keys.replace val[1]
  result
 end

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 # reduce 15 omitted

 def _reduce_16( val, _values, result )
      t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
  result
 end

 # reduce 17 omitted

 # reduce 18 omitted

 def _reduce_19( val, _values, result )
 result = (val[0].to_i * 60 * 60) + (val[2].to_i * 60)
  result
 end

 def _reduce_20( val, _values, result )
 result = (val[0].to_i * 60 * 60) + (val[2].to_i * 60) + val[4].to_i
  result
 end

 def _reduce_21( val, _values, result )
 result = DateH.zone_s2i( val[0] ) * 60
  result
 end

 def _reduce_22( val, _values, result )
        @field.from  = val[0]
        @field.by    = val[1]
        @field.via   = val[2]
        @field.with.replace val[3]
        @field.msgid = val[4]
        @field.ford  = val[5]
        @field.date  = val[6]
  result
 end

 # reduce 23 omitted

 def _reduce_24( val, _values, result )
      result = val[1]
  result
 end

 def _reduce_25( val, _values, result )
        result = val[3]
  result
 end

 def _reduce_26( val, _values, result )
        result = val[1]
  result
 end

 # reduce 27 omitted

 def _reduce_28( val, _values, result )
        result = val[1]
  result
 end

 # reduce 29 omitted

 def _reduce_30( val, _values, result )
        result = val[1]
  result
 end

 def _reduce_31( val, _values, result )
        result = []
  result
 end

 def _reduce_32( val, _values, result )
        result.push val[2]
  result
 end

 # reduce 33 omitted

 def _reduce_34( val, _values, result )
        result = val[1]
  result
 end

 def _reduce_35( val, _values, result )
        result = val[1]
  result
 end

 # reduce 36 omitted

 def _reduce_37( val, _values, result )
 result = val[1]
  result
 end

 # reduce 38 omitted

 def _reduce_39( val, _values, result )
 result = val[1]
  result
 end

 # reduce 40 omitted

 def _reduce_41( val, _values, result )
        @field.routes.replace result.routes
        @field.addr = result.addr
  result
 end

 def _reduce_42( val, _values, result )
 result = val
  result
 end

 def _reduce_43( val, _values, result )
 result.push val[2]
  result
 end

 # reduce 44 omitted

 # reduce 45 omitted

 def _reduce_46( val, _values, result )
 result = val
  result
 end

 def _reduce_47( val, _values, result )
 result.push val[2]
  result
 end

 # reduce 48 omitted

 # reduce 49 omitted

 def _reduce_50( val, _values, result )
        val[1].phrase = Bencode.decode( val[0] )
        result = val[1]
  result
 end

 def _reduce_51( val, _values, result )
 result = AddrGroup.new( val[0], val[2] )
  result
 end

 def _reduce_52( val, _values, result )
        val[2].route.replace val[1]
        result = val[2]
  result
 end

 def _reduce_53( val, _values, result )
 result = val[1]
  result
 end

 # reduce 54 omitted

 def _reduce_55( val, _values, result )
 result = [ val[1] ]
  result
 end

 def _reduce_56( val, _values, result )
 result.push val[3]
  result
 end

 def _reduce_57( val, _values, result )
 result = Mbox.new( val.join('') )
  result
 end

 def _reduce_58( val, _values, result )
 result = Mbox.new( val[0] )
  result
 end

 # reduce 59 omitted

 def _reduce_60( val, _values, result )
        result.concat val[1]
        result.concat val[2]
  result
 end

 # reduce 61 omitted

 def _reduce_62( val, _values, result )
        result.concat val[1]
        result.concat val[2]
  result
 end

 # reduce 63 omitted

 # reduce 64 omitted

 # reduce 65 omitted

 def _reduce_66( val, _values, result )
 result = '<' + val[1].addr + '>'
  result
 end

 # reduce 67 omitted

 def _reduce_68( val, _values, result )
 result << ' ' << val[1]
  result
 end

 # reduce 69 omitted

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 def _reduce_74( val, _values, result )
 @field.encrypter = val[0]
  result
 end

 def _reduce_75( val, _values, result )
        @field.encrypter = val[0]
        @field.keyword   = val[1]
  result
 end

 def _reduce_76( val, _values, result )
        @field.major = val[0].to_i
        @field.minor = val[2].to_i
  result
 end

 def _reduce_77( val, _values, result )
        @field.main = val[0]
        @field.sub  = val[2]
  result
 end

 def _reduce_78( val, _values, result )
        @field.main = val[0]
        @field.sub  = ''
  result
 end

 # reduce 79 omitted

 def _reduce_80( val, _values, result )
 @field.params.store( val[2].downcase, val[4] )
  result
 end

 # reduce 81 omitted

 # reduce 82 omitted

 def _reduce_83( val, _values, result )
 @field.encoding = val[0]
  result
 end

 def _reduce_84( val, _values, result )
 @field.disposition = val[0]
  result
 end

 # reduce 85 omitted

 # reduce 86 omitted

 # reduce 87 omitted

 def _reduce_88( val, _values, result )
 @field.params.store( val[0].downcase, val[2] )
  result
 end

 def _reduce_89( val, _values, result )
 @field.params.store( val[0].downcase, val[2] )
  result
 end

 def _reduce_90( val, _values, result )
 @field.params.store( val[0].downcase, val[2] )
  result
 end

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 # reduce 97 omitted

end
