#
# packing.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#

require 'amstd/environ'
require 'amstd/futils'
require 'amstd/to_s'


class PackEnv < Environment

  include FileUtils

  def a( *args )
    args.flatten!
    indir g(:dir), args
  end

  alias d indir

end

class PackEnvStack < EnvironmentStack
  item_type PackEnv
end


$Packing_Main_Stack = PackEnvStack.new

def environ( nm, &block )
  $Packing_Main_Stack.environ nm, &block
end

def packing_do( task, recvname = nil )
  if recvname then
    recv = $Packing_Main_Stack[ recvname ]
  else
    recv = $Packing_Main_Stack.prev
  end
  unless recv.respond_to? task then
    raise NameError,
      "task #{_name2str task} is not implemented for #{recv.name}"
  end
  recv.send task
end
