#
# to_s.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#


def _name2str( arg )
  case arg
  when String then arg
  when Fixnum then arg.id2name
  else
    raise TypeError, "wrong arg type #{arg.type} for expected String/Fixnum"
  end
end

def _type2str( arg )
  case arg
  when String then arg
  when Fixnum then arg.id2name
  when Module then arg.name
  when Array
    arg.collect{|i| _type2str i }.join(',')
  else
    raise TypeError,
      "wrong arg type #{arg.type} for expected String/Fixnum/Module/Array"
  end
end
