#
# rbparam.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#

require 'rbconfig'


module RubyParams

  def RubyParams.sepjoin( *args )
    File.join( *args )
  end

  CONFIG     = Config::CONFIG

  RUBY       = CONFIG['ruby_install_name']

  BINDIR     = sepjoin( CONFIG['bindir'] )
  LIBDIR     = sepjoin( CONFIG['libdir'],
                        'ruby',
                        CONFIG['MAJOR'] + '.' + CONFIG['MINOR'] )
  SITELIBDIR = sepjoin( LIBDIR,
                        'site_ruby' )

  ARCH       = CONFIG['arch']

  RBDIR      = sepjoin( SITELIBDIR )
  SODIR      = sepjoin( SITELIBDIR, ARCH )

  RUBY_PATH  = sepjoin( BINDIR, RUBY )

  DL_EXT     = CONFIG['DLEXT']
  Extentions = [ 'rb', DL_EXT ]

end
