#
# packing.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#

require 'amstd/environ'
require 'amstd/futils'


class Environment

  include FileUtils

  def do_initialize
    @verbose = false
  end

  def a( arg )
    indir g(:dir), arg
  end

  alias d indir

end


$Packing_Main_Stack = EnvironmentStack.new

def environ( nm, &block )
  $Packing_Main_Stack.environ nm, &block
end

def packing_do( task )
  recv = $Packing_Main_Stack.prev
  unless recv.respond_to? task then
    raise NameError, "task #{_name2str(task)} is not implemented"
  end
  recv.send task
end
