#
# inst.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#

require 'tempfile'

require 'amstd/futils'
require 'amstd/rbparams'


class Installer

  extend FileUtils
  include FileUtils

  include RubyParams


  def initialize
    @verbose = true
  end


  def Installer.execute
    obj = self.new
    if not ARGV[0] then
      obj.try_setup;   puts 'setup ok, entering installation step ...'
      obj.try_install; puts 'done installation.'

    elsif ARGV[0] == 'setup'   then obj.try_setup
    elsif ARGV[0] == 'install' then obj.try_install
    else
      puts 'usage: ruby setup.rb [setup|install]'
      exit 1
    end
  end


  def try_setup
    begin
      com_setup
    rescue
      puts 'setup failed'
      raise
    end
  end

  def try_install
    begin
      com_install
    rescue
      puts 'install failed'
      raise
    end
  end


  def setup_library( libn )
    compile_all_in libn
  end

  def install_library( libn )
    lib_install( libn ) do |rb_to, so_to|
      install_rb rb_to
      each_dir do |ext|
        if so_dir? '.' then
          make_install so_to
        end
      end
    end
  end

  def lib_install( libname )
    chdir( libname ) do
      yield isdir( fjoin(RubyParams::RBDIR, libname) ),
			      isdir( fjoin(RubyParams::SODIR, libname) )
    end
  end


  def install_rb( to )
    Dir.foreach( '.' ) do |fn|
      if /\.rb\z/o === fn and file? fn then
        install fn, to, 0644
      end
    end
  end


  def extconf
    unless is_newer? 'Makefile', 'extconf.rb' then
      system 'ruby extconf.rb'
    end
  end

  def make
    system 'make'
  end

  def compile_all_in( dir )
    chdir( dir ) do
      each_sodir do |extname|
        extconf
        make
      end
    end
  end

  def make_install( to )
    find_so('.').each do |fn|
      install fn, to, 0555
    end
  end

  def find_so( dir = '.' )
    fnames = nil
    Dir.open( dir ) {|d| fnames = d.to_a }
    %w( so sl dll o ).each do |ext|
      exp = /\.#{ext}\z/
      a = fnames.find_all {|f| exp === f }
      return a if Array === a
    end
    
    raise ArgumentError,
      "can't find ruby extention library in '#{expand dir}'"
  end

  def so_dir?( dn = '.' )
    file? fjoin( dn, 'MANIFEST' )
  end

  def each_sodir
    each_dir do |dn|
      if so_dir? then
        yield dn
      end
    end
  end
        
  def each_dir
    Dir.foreach( '.' ) do |fn|
      next if /\A\./o === fn
      if directory? fn then
        chdir( fn ) do
          yield fn
        end
      end
    end
  end


  def install_all( to )
    Dir.foreach( '.' ) do |fn|
      if file? fn then
        install fn, to, 644
      end
    end
  end


  def add_rubypath( fn, opt = '' )
    opt = ' ' + opt unless opt.empty?

    tmpf = Tempfile.open( 'rbinst' )
    File.open( fn ) do |f|
      first = f.gets
      tmpf.puts "\#!#{RubyParams::RUBY_PATH}#{opt}"
      tmpf << first unless /\A\#\!/o === first
      f.each {|i| tmpf << i }
    end
    tmpf.close
    
    mod = File.stat( fn ).mode
    tmpf.open
    open( fn, 'w' ) do |wf|
      tmpf.each {|i| wf << i }
    end
    chmod mod, fn

    tmpf.close true
  end

end
