#
# mailp.rb
#
#     Copyright(c) 1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#

require 'amstd/recycle'

require 'racc/parser'
require 'racc/scanner'


$mailpdebugflag = false

class Mailp < Parser
  include Recyclable

  def initialize
    @scanner = MailScanner.new
  end


  def reset
    self.debug = $mailpdebugflag
  end


  def debug=( flag )
    @yydebug = flag
    @scanner.debug = @yydebug && DEBUG_PARSER
  end


  def debug
    @yydebug
  end


  def Mailp.parse( hder, str )
    use_instance do |inst|
      inst.parse( hder, str )
    end
  end


  def parse( hder, str )
    hder.must HeaderField
    str.must String

    if /\A\s+\z/ === str then return end
    str = str.dup

    @field  = hder

    case hder
    when MsgidH
      msgid_parse( str )
    when RefH
      refs_parse( str )
    else
      @scanner.reset( str, @field )

      sim = hder.type.to_s
      sim = sim.split('::')[-1].to_s.intern
      @cache = [sim, nil]

      do_parse
    end
  end


  private


  def next_token
    if ret = @cache then
      @cache = nil
    else
      ret = @scanner.scan
    end
    ret
  end


=begin c
  def next_value
    if @valarr.size == 0 then
      @scanner.scan
    end
    return @valarr.shift
  end


  def peep_token
    if @simarr.size == 0 then
      ret = @scanner.scan( false )
    else
      ret = @simarr[0]
    end

    return ret
  end
=end c

  
  def on_error( tok, val, _tstack, _vstack, _state )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end


  def refs_parse( str )
    temp = []

    while MsgidH::MSGID === str do
      temp.push( ($`).strip )
      temp.push( $& )
      str = $'
    end
    temp.push str

    @field.refs.replace temp
  end


  def msgid_parse( str )
    if MsgidH::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError,
        "wrong Message-ID format: #{str}"
    end
  end



  class MailScanner < Scanner

    # mode

    MODE_NONE = :MODE_NONE

    MODE_822  = :MODE_822
    MODE_MIME = :MODE_MIME

    MODE_RECV = :MODE_RECV


    def reset( str, fld )
      super( str )
      @header = fld

      @m_atom = MODE_822
      @m_recv = MODE_NONE

      case fld
      when CTypeH
        @m_atom = MODE_MIME
      when CEncodingH, CDispositionH
        @m_atom = MODE_MIME
      when RecvH
        @m_recv = MODE_RECV
      end
    end


    # exp

    atomchars  = Regexp.quote( "\#!$%&`'*+{|}~^/=?" ) + '\\-'
    tokenchars = Regexp.quote( "\#!$%&`'*+{|}~^." )   + '\\-'
    eucchars   = "\xa1\xa1-\xf3\xfe"
    jisstr     = "\\e..[^\\e]*\\e.."

    ATOM    = /\A[\w#{atomchars}#{eucchars}]+|#{jisstr}/o
    TOKEN   = /\A[\w#{tokenchars}#{eucchars}]+|#{jisstr}/o
    DIGIT   = /\A\d+\z/o

    LWSP    = /\A(?:\n|\r\n|\r)?[ \t]+/o

    BACKSLASH = /\A\\/o

    BEGIN_Q = /\A"/o
    Q_ENT   = /\A[^"\\\e]+|#{jisstr}/o
    END_Q   = /\A"/o

    BEGIN_C = /\A\(/o
    C_ENT   = /\A[^\)\(\\\e]+|#{jisstr}/o
    END_C   = /\A\)/o

    BEGIN_D = /\A\[/o
    D_ENT   = /\A[^\]\\]+|#{jisstr}/o
    END_D   = /\A\]/o


    OMIT = '$omit'

    def scan( cut = true )
      sret = nil
      vret = OMIT

      until sret do
        unless @scan.rest? then
          sret = false; vret = false
          break
        end

        @scan.skip LWSP

        if @m_atom == MODE_822 then
          if vret = @scan.fullscan( ATOM, true, cut ) then
            sret = :ATOM

            if DIGIT === vret then
              sret = :DIGIT
              vret = vret

            elsif @m_recv = MODE_RECV then
              case vret.downcase
              when 'from' then sret = :FROM
              when 'by'   then sret = :BY
              when 'via'  then sret = :VIA
              when 'with' then sret = :WITH
              when 'id'   then sret = :ID
              when 'for'  then sret = :FOR
              end
            end
            break
          end

        elsif @m_atom == MODE_MIME then
          if vret = @scan.fullscan( TOKEN, cut, cut ) then
            sret = :TOKEN
            break
          end
        else
          bug! 'atom mode is not 822/MIME'
        end

        if @scan.fullscan( BEGIN_Q, cut, cut ) then
          sret = :QUOTED
          vret = quoted if cut

        elsif @scan.skip( BEGIN_C ) then
          @header.comments.push comment

        elsif @scan.fullscan( BEGIN_D, cut, cut ) then
          sret = :DOMLIT
          vret = domlit if cut

        else
          sret = vret = @scan.getch
          unless cut then
            @scan.unscan
          end
        end
      end

      ret = [sret, vret]
      debug_report( ret ) if @debug
      ret
    end



    private


    def quoted
      ret = ''
      while true do
        if    temp = @scan.scan( Q_ENT ) then ret << temp
        elsif @scan.skip( END_Q )        then break
        elsif @scan.skip( BACKSLASH )    then ret << @scan.getch
        else
          unless @scan.rest? then
            scan_error! "found unterminated quoted-string"
          end
          bug! 'in quoted, no match'
        end
      end

      return ret
    end

    
    def comment
      ret = ''
      nest = 1

      while nest > 0 and @scan.rest? do
        if    temp = @scan.scan( C_ENT ) then ret << temp
        elsif @scan.skip( END_C )        then nest -= 1
        elsif @scan.skip( BEGIN_C )      then nest += 1
        elsif @scan.skip( BACKSLASH )    then ret << @scan.getch
        else
          unless @scan.rest? then
            scan_error! "found unterminated comment"
          end
          bug! 'in comment, no match'
        end
      end
      if nest > 0 then
        scan_error! "found unterminated comment"
      end

      return ret
    end

    
    def domlit
      ret = ''

      while true do
        if temp = @scan.scan( D_ENT ) then
          ret << temp
        end
        if    @scan.skip( END_D )     then break
        elsif @scan.skip( BACKSLASH ) then ret << @scan.getch
        else
          unless @scan.rest? then
            scan_error! "found unterminated domain literal"
          end
          bug! 'in domlit, no match'
        end
      end

      return ret
    end


    def report_ret( sret, ret )
      if Integer === sret then
        puts "sret #{sret.id2name || sret}"
      else
        puts "sret #{sret.inspect}"
      end
      puts "vret #{ret}"
    end

  end

##### racc generated code begin ###

shift_1 = 1
shift_3 = 3
shift_4 = 4
shift_5 = 5
shift_6 = 6
shift_7 = 7
shift_8 = 8
shift_9 = 9
shift_10 = 10
shift_11 = 11
shift_12 = 12
shift_13 = 13
shift_14 = 14
shift_15 = 15
shift_16 = 16
shift_19 = 19
shift_20 = 20
shift_21 = 21
shift_24 = 24
shift_25 = 25
shift_26 = 26
shift_29 = 29
shift_30 = 30
shift_32 = 32
shift_33 = 33
shift_35 = 35
shift_36 = 36
shift_37 = 37
shift_39 = 39
shift_41 = 41
shift_47 = 47
shift_56 = 56
shift_60 = 60
shift_61 = 61
shift_63 = 63
shift_71 = 71
shift_72 = 72
shift_74 = 74
shift_75 = 75
shift_77 = 77
shift_79 = 79
shift_81 = 81
shift_82 = 82
shift_83 = 83
shift_84 = 84
shift_85 = 85
shift_86 = 86
shift_88 = 88
shift_92 = 92
shift_94 = 94
shift_97 = 97
shift_98 = 98
shift_99 = 99
shift_102 = 102
shift_104 = 104
shift_105 = 105
shift_111 = 111
shift_112 = 112
shift_113 = 113
shift_115 = 115
shift_117 = 117
shift_118 = 118
shift_119 = 119
shift_120 = 120
shift_121 = 121
shift_122 = 122
shift_123 = 123
shift_127 = 127
shift_129 = 129
shift_131 = 131
shift_133 = 133
shift_135 = 135
shift_136 = 136
shift_138 = 138
shift_139 = 139
shift_140 = 140
shift_141 = 141
shift_143 = 143
shift_144 = 144
shift_146 = 146
shift_148 = 148
shift_150 = 150
shift_151 = 151
shift_153 = 153
shift_154 = 154
shift_156 = 156
shift_158 = 158
shift_160 = 160

reduce_0 = [2, Accept, :_action_for_reduce_0]
reduce_1 = [2, :content, :_action_for_reduce_1]
reduce_2 = [2, :content, :_action_for_reduce_2]
reduce_3 = [2, :content, :_action_for_reduce_3]
reduce_4 = [2, :content, :_action_for_reduce_4]
reduce_5 = [2, :content, :_action_for_reduce_5]
reduce_6 = [2, :content, :_action_for_reduce_6]
reduce_7 = [2, :content, :_action_for_reduce_7]
reduce_8 = [2, :content, :_action_for_reduce_8]
reduce_9 = [2, :content, :_action_for_reduce_9]
reduce_10 = [2, :content, :_action_for_reduce_10]
reduce_11 = [2, :content, :_action_for_reduce_11]
reduce_12 = [2, :content, :_action_for_reduce_12]
reduce_13 = [2, :content, :_action_for_reduce_13]
reduce_14 = [2, :content, :_action_for_reduce_14]
reduce_15 = [2, :content, :_action_for_reduce_15]
reduce_16 = [6, :datetime, :_action_for_reduce_16]
reduce_17 = [0, :day, :_action_for_reduce_17]
reduce_18 = [2, :day, :_action_for_reduce_18]
reduce_19 = [3, :hour, :_action_for_reduce_19]
reduce_20 = [5, :hour, :_action_for_reduce_20]
reduce_21 = [1, :zone, :_action_for_reduce_21]
reduce_22 = [7, :received, :_action_for_reduce_22]
reduce_23 = [0, :from, :_action_for_reduce_23]
reduce_24 = [2, :from, :_action_for_reduce_24]
reduce_25 = [4, :from, :_action_for_reduce_25]
reduce_26 = [3, :from, :_action_for_reduce_26]
reduce_27 = [0, :by, :_action_for_reduce_27]
reduce_28 = [2, :by, :_action_for_reduce_28]
reduce_29 = [0, :via, :_action_for_reduce_29]
reduce_30 = [2, :via, :_action_for_reduce_30]
reduce_31 = [0, :with, :_action_for_reduce_31]
reduce_32 = [3, :with, :_action_for_reduce_32]
reduce_33 = [0, :id, :_action_for_reduce_33]
reduce_34 = [2, :id, :_action_for_reduce_34]
reduce_35 = [2, :id, :_action_for_reduce_35]
reduce_36 = [0, :for, :_action_for_reduce_36]
reduce_37 = [2, :for, :_action_for_reduce_37]
reduce_38 = [0, :recvdatetime, :_action_for_reduce_38]
reduce_39 = [2, :recvdatetime, :_action_for_reduce_39]
reduce_40 = [2, :returnpath, :_action_for_reduce_40]
reduce_41 = [1, :returnpath, :_action_for_reduce_41]
reduce_42 = [1, :addrs, :_action_for_reduce_42]
reduce_43 = [3, :addrs, :_action_for_reduce_43]
reduce_44 = [1, :addr, :_action_for_reduce_44]
reduce_45 = [1, :addr, :_action_for_reduce_45]
reduce_46 = [1, :mboxes, :_action_for_reduce_46]
reduce_47 = [3, :mboxes, :_action_for_reduce_47]
reduce_48 = [1, :mbox, :_action_for_reduce_48]
reduce_49 = [1, :mbox, :_action_for_reduce_49]
reduce_50 = [2, :mbox, :_action_for_reduce_50]
reduce_51 = [4, :group, :_action_for_reduce_51]
reduce_52 = [4, :routeaddr, :_action_for_reduce_52]
reduce_53 = [3, :routeaddr, :_action_for_reduce_53]
reduce_54 = [2, :route, :_action_for_reduce_54]
reduce_55 = [2, :at_domains, :_action_for_reduce_55]
reduce_56 = [4, :at_domains, :_action_for_reduce_56]
reduce_57 = [3, :spec, :_action_for_reduce_57]
reduce_58 = [1, :spec, :_action_for_reduce_58]
reduce_59 = [1, :local, :_action_for_reduce_59]
reduce_60 = [3, :local, :_action_for_reduce_60]
reduce_61 = [1, :domain, :_action_for_reduce_61]
reduce_62 = [3, :domain, :_action_for_reduce_62]
reduce_63 = [1, :domword, :_action_for_reduce_63]
reduce_64 = [1, :domword, :_action_for_reduce_64]
reduce_65 = [1, :domword, :_action_for_reduce_65]
reduce_66 = [3, :msgid, :_action_for_reduce_66]
reduce_67 = [1, :phrase, :_action_for_reduce_67]
reduce_68 = [2, :phrase, :_action_for_reduce_68]
reduce_69 = [1, :word, :_action_for_reduce_69]
reduce_70 = [1, :word, :_action_for_reduce_70]
reduce_71 = [1, :word, :_action_for_reduce_71]
reduce_72 = [1, :keys, :_action_for_reduce_72]
reduce_73 = [3, :keys, :_action_for_reduce_73]
reduce_74 = [1, :enc, :_action_for_reduce_74]
reduce_75 = [2, :enc, :_action_for_reduce_75]
reduce_76 = [3, :version, :_action_for_reduce_76]
reduce_77 = [4, :ctype, :_action_for_reduce_77]
reduce_78 = [2, :ctype, :_action_for_reduce_78]
reduce_79 = [0, :params, :_action_for_reduce_79]
reduce_80 = [5, :params, :_action_for_reduce_80]
reduce_81 = [1, :value, :_action_for_reduce_81]
reduce_82 = [1, :value, :_action_for_reduce_82]
reduce_83 = [1, :cencode, :_action_for_reduce_83]
reduce_84 = [2, :cdisp, :_action_for_reduce_84]
reduce_85 = [0, :disp_params, :_action_for_reduce_85]
reduce_86 = [3, :disp_params, :_action_for_reduce_86]
reduce_87 = [0, :disp_param, :_action_for_reduce_87]
reduce_88 = [3, :disp_param, :_action_for_reduce_88]
reduce_89 = [3, :disp_param, :_action_for_reduce_89]
reduce_90 = [3, :disp_param, :_action_for_reduce_90]
reduce_91 = [1, :atom, :_action_for_reduce_91]
reduce_92 = [1, :atom, :_action_for_reduce_92]
reduce_93 = [1, :atom, :_action_for_reduce_93]
reduce_94 = [1, :atom, :_action_for_reduce_94]
reduce_95 = [1, :atom, :_action_for_reduce_95]
reduce_96 = [1, :atom, :_action_for_reduce_96]
reduce_97 = [1, :atom, :_action_for_reduce_97]

LR_action_table = [
# state 0
{ :RetpathH => shift_1,
  :DateH => shift_3,
  :KeyH => shift_4,
  :MsgidH => shift_6,
  :CEncodingH => shift_5,
  :MmboxH => shift_8,
  :VersionH => shift_7,
  :MaddrH => shift_9,
  :RecvH => shift_10,
  :RefH => shift_12,
  :CDispositionH => shift_11,
  :SmboxH => shift_14,
  :CTypeH => shift_13,
  :SaddrH => shift_16,
  :EncH => shift_15 },
# state 1
{ "<" => shift_19 },
# state 2
{ Anchor => shift_20 },
# state 3
{ :ATOM => shift_21,
  :DIGIT => reduce_17 },
# state 4
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 5
{ :TOKEN => shift_37 },
# state 6
{ "<" => shift_39 },
# state 7
{ :DIGIT => shift_41 },
# state 8
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 9
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 10
{ Anchor => reduce_23,
  :WITH => reduce_23,
  ";" => reduce_23,
  :VIA => reduce_23,
  :FROM => shift_56,
  :FOR => reduce_23,
  :BY => reduce_23,
  :ID => reduce_23 },
# state 11
{ :TOKEN => shift_60 },
# state 12
{ :refs => shift_61 },
# state 13
{ :TOKEN => shift_63 },
# state 14
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 15
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 16
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 17
{ Default => reduce_41 },
# state 18
{ Default => reduce_3 },
# state 19
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  ">" => shift_71,
  :FOR => shift_32,
  :BY => shift_33,
  "@" => shift_72,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 20
{ Default => reduce_0 },
# state 21
{ "," => shift_74 },
# state 22
{ Default => reduce_1 },
# state 23
{ :DIGIT => shift_75 },
# state 24
{ Default => reduce_91 },
# state 25
{ Default => reduce_95 },
# state 26
{ Default => reduce_71 },
# state 27
{ :ATOM => shift_24,
  Anchor => reduce_72,
  "," => reduce_72,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 28
{ Default => reduce_67 },
# state 29
{ Default => reduce_94 },
# state 30
{ Default => reduce_92 },
# state 31
{ "," => shift_77,
  Anchor => reduce_10 },
# state 32
{ Default => reduce_97 },
# state 33
{ Default => reduce_93 },
# state 34
{ Default => reduce_69 },
# state 35
{ Default => reduce_96 },
# state 36
{ Default => reduce_70 },
# state 37
{ Default => reduce_83 },
# state 38
{ Default => reduce_14 },
# state 39
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 40
{ Default => reduce_8 },
# state 41
{ "." => shift_79 },
# state 42
{ Default => reduce_12 },
# state 43
{ Default => reduce_49 },
# state 44
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 45
{ Default => reduce_46 },
# state 46
{ :ATOM => reduce_67,
  "," => reduce_59,
  Anchor => reduce_59,
  :DIGIT => reduce_67,
  :WITH => reduce_67,
  "." => reduce_59,
  ":" => reduce_67,
  ";" => reduce_59,
  "<" => reduce_67,
  :VIA => reduce_67,
  :FROM => reduce_67,
  :FOR => reduce_67,
  ">" => reduce_59,
  :BY => reduce_67,
  "@" => reduce_59,
  :QUOTED => reduce_67,
  :ID => reduce_67 },
# state 47
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  "@" => shift_72,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 48
{ Default => reduce_48 },
# state 49
{ "," => shift_81,
  Anchor => reduce_6 },
# state 50
{ Anchor => reduce_58,
  "," => reduce_58,
  "." => shift_82,
  ";" => reduce_58,
  ">" => reduce_58,
  "@" => shift_83 },
# state 51
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  ":" => shift_84,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 52
{ Default => reduce_44 },
# state 53
{ Default => reduce_42 },
# state 54
{ Default => reduce_45 },
# state 55
{ "," => shift_85,
  Anchor => reduce_4 },
# state 56
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 57
{ Anchor => reduce_27,
  :WITH => reduce_27,
  ";" => reduce_27,
  :VIA => reduce_27,
  :FOR => reduce_27,
  :BY => shift_92,
  :ID => reduce_27 },
# state 58
{ Default => reduce_2 },
# state 59
{ Default => reduce_15 },
# state 60
{ Anchor => reduce_85,
  ";" => reduce_85 },
# state 61
{ Default => reduce_9 },
# state 62
{ Default => reduce_13 },
# state 63
{ Anchor => reduce_79,
  "/" => shift_94,
  ";" => reduce_79 },
# state 64
{ Default => reduce_7 },
# state 65
{ Default => reduce_11 },
# state 66
{ :ATOM => shift_24,
  Anchor => reduce_74,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 67
{ Default => reduce_5 },
# state 68
{ Default => reduce_59 },
# state 69
{ ">" => shift_97 },
# state 70
{ "," => shift_98,
  ":" => shift_99 },
# state 71
{ Default => reduce_40 },
# state 72
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 73
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 74
{ Default => reduce_18 },
# state 75
{ :ATOM => shift_102 },
# state 76
{ Default => reduce_68 },
# state 77
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 78
{ ">" => shift_104 },
# state 79
{ :DIGIT => shift_105 },
# state 80
{ Default => reduce_50 },
# state 81
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 82
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 83
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 84
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 85
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 86
{ Default => reduce_64 },
# state 87
{ Default => reduce_61 },
# state 88
{ Default => reduce_65 },
# state 89
{ Default => reduce_63 },
# state 90
{ :DOMLIT => shift_111,
  Anchor => reduce_24,
  "." => shift_112,
  :WITH => reduce_24,
  ";" => reduce_24,
  :VIA => reduce_24,
  :FOR => reduce_24,
  :BY => reduce_24,
  "@" => shift_113,
  :ID => reduce_24 },
# state 91
{ Anchor => reduce_29,
  :WITH => reduce_29,
  ";" => reduce_29,
  :VIA => shift_115,
  :FOR => reduce_29,
  :ID => reduce_29 },
# state 92
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 93
{ Anchor => reduce_84,
  ";" => shift_117 },
# state 94
{ :TOKEN => shift_118 },
# state 95
{ Anchor => reduce_78,
  ";" => shift_119 },
# state 96
{ Default => reduce_75 },
# state 97
{ Default => reduce_53 },
# state 98
{ "@" => shift_120 },
# state 99
{ Default => reduce_54 },
# state 100
{ "," => reduce_55,
  "." => shift_112,
  ":" => reduce_55 },
# state 101
{ ">" => shift_121 },
# state 102
{ :DIGIT => shift_122 },
# state 103
{ :ATOM => shift_24,
  Anchor => reduce_73,
  "," => reduce_73,
  :DIGIT => shift_26,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 104
{ Default => reduce_66 },
# state 105
{ Default => reduce_76 },
# state 106
{ Default => reduce_47 },
# state 107
{ Default => reduce_60 },
# state 108
{ Anchor => reduce_57,
  "," => reduce_57,
  "." => shift_112,
  ";" => reduce_57,
  ">" => reduce_57 },
# state 109
{ "," => shift_81,
  ";" => shift_123 },
# state 110
{ Default => reduce_43 },
# state 111
{ Default => reduce_26 },
# state 112
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 113
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 114
{ Anchor => reduce_31,
  :WITH => reduce_31,
  ";" => reduce_31,
  :FOR => reduce_31,
  :ID => reduce_31 },
# state 115
{ :ATOM => shift_127 },
# state 116
{ Anchor => reduce_28,
  "." => shift_112,
  :WITH => reduce_28,
  ";" => reduce_28,
  :VIA => reduce_28,
  :FOR => reduce_28,
  :ID => reduce_28 },
# state 117
{ Anchor => reduce_87,
  :TOKEN => shift_129,
  ";" => reduce_87 },
# state 118
{ Anchor => reduce_79,
  ";" => reduce_79 },
# state 119
{ :TOKEN => shift_131 },
# state 120
{ :DOMLIT => shift_86,
  :ATOM => shift_24,
  :DIGIT => shift_88,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :ID => shift_35 },
# state 121
{ Default => reduce_52 },
# state 122
{ :DIGIT => shift_133 },
# state 123
{ Default => reduce_51 },
# state 124
{ Default => reduce_62 },
# state 125
{ Anchor => reduce_25,
  "." => shift_112,
  :WITH => reduce_25,
  ";" => reduce_25,
  :VIA => reduce_25,
  :FOR => reduce_25,
  :BY => reduce_25,
  :ID => reduce_25 },
# state 126
{ Anchor => reduce_33,
  :WITH => shift_135,
  ";" => reduce_33,
  :FOR => reduce_33,
  :ID => shift_136 },
# state 127
{ Default => reduce_30 },
# state 128
{ Default => reduce_86 },
# state 129
{ "=" => shift_138 },
# state 130
{ Anchor => reduce_77,
  ";" => shift_119 },
# state 131
{ "=" => shift_139 },
# state 132
{ "," => reduce_56,
  "." => shift_112,
  ":" => reduce_56 },
# state 133
{ ":" => shift_140 },
# state 134
{ :ATOM => shift_141 },
# state 135
{ :ATOM => shift_143 },
# state 136
{ :ATOM => shift_144,
  "<" => shift_39 },
# state 137
{ Anchor => reduce_36,
  ";" => reduce_36,
  :FOR => shift_146 },
# state 138
{ :ATOM => shift_24,
  :VALUE => shift_148,
  :WITH => shift_25,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_150,
  :ID => shift_35 },
# state 139
{ :TOKEN => shift_151,
  :QUOTED => shift_153 },
# state 140
{ :DIGIT => shift_154 },
# state 141
{ Default => reduce_21 },
# state 142
{ Default => reduce_16 },
# state 143
{ Default => reduce_32 },
# state 144
{ Default => reduce_35 },
# state 145
{ Default => reduce_34 },
# state 146
{ :ATOM => shift_24,
  :DIGIT => shift_26,
  :WITH => shift_25,
  "<" => shift_47,
  :VIA => shift_29,
  :FROM => shift_30,
  :FOR => shift_32,
  :BY => shift_33,
  :QUOTED => shift_36,
  :ID => shift_35 },
# state 147
{ Anchor => reduce_38,
  ";" => shift_156 },
# state 148
{ Default => reduce_89 },
# state 149
{ Default => reduce_90 },
# state 150
{ Default => reduce_88 },
# state 151
{ Default => reduce_81 },
# state 152
{ Default => reduce_80 },
# state 153
{ Default => reduce_82 },
# state 154
{ :ATOM => reduce_19,
  ":" => shift_158 },
# state 155
{ Default => reduce_37 },
# state 156
{ :ATOM => shift_21,
  :DIGIT => reduce_17 },
# state 157
{ Default => reduce_22 },
# state 158
{ :DIGIT => shift_160 },
# state 159
{ Default => reduce_39 },
# state 160
{ Default => reduce_20 }
]   # LR action table

LR_goto_table = [
# state 0
{ :content => 2 },
# state 1
{ :routeaddr => 17,
  :returnpath => 18 },
# state 2
nil,
# state 3
{ :datetime => 22,
  :day => 23 },
# state 4
{ :phrase => 27,
  :word => 28,
  :keys => 31,
  :atom => 34 },
# state 5
{ :cencode => 38 },
# state 6
{ :msgid => 40 },
# state 7
{ :version => 42 },
# state 8
{ :routeaddr => 43,
  :phrase => 44,
  :mbox => 45,
  :word => 46,
  :spec => 48,
  :mboxes => 49,
  :atom => 34,
  :local => 50 },
# state 9
{ :routeaddr => 43,
  :phrase => 51,
  :mbox => 52,
  :addr => 53,
  :word => 46,
  :spec => 48,
  :group => 54,
  :atom => 34,
  :local => 50,
  :addrs => 55 },
# state 10
{ :from => 57,
  :received => 58 },
# state 11
{ :cdisp => 59 },
# state 12
nil,
# state 13
{ :ctype => 62 },
# state 14
{ :routeaddr => 43,
  :phrase => 44,
  :mbox => 64,
  :word => 46,
  :spec => 48,
  :atom => 34,
  :local => 50 },
# state 15
{ :enc => 65,
  :word => 66,
  :atom => 34 },
# state 16
{ :routeaddr => 43,
  :phrase => 51,
  :mbox => 52,
  :addr => 67,
  :word => 46,
  :spec => 48,
  :group => 54,
  :atom => 34,
  :local => 50 },
# state 17
nil,
# state 18
nil,
# state 19
{ :word => 68,
  :spec => 69,
  :at_domains => 70,
  :atom => 34,
  :local => 50,
  :route => 73 },
# state 20
nil,
# state 21
nil,
# state 22
nil,
# state 23
nil,
# state 24
nil,
# state 25
nil,
# state 26
nil,
# state 27
{ :word => 76,
  :atom => 34 },
# state 28
nil,
# state 29
nil,
# state 30
nil,
# state 31
nil,
# state 32
nil,
# state 33
nil,
# state 34
nil,
# state 35
nil,
# state 36
nil,
# state 37
nil,
# state 38
nil,
# state 39
{ :word => 68,
  :spec => 78,
  :atom => 34,
  :local => 50 },
# state 40
nil,
# state 41
nil,
# state 42
nil,
# state 43
nil,
# state 44
{ :routeaddr => 80,
  :word => 76,
  :atom => 34 },
# state 45
nil,
# state 46
nil,
# state 47
{ :word => 68,
  :spec => 69,
  :at_domains => 70,
  :atom => 34,
  :local => 50,
  :route => 73 },
# state 48
nil,
# state 49
nil,
# state 50
nil,
# state 51
{ :routeaddr => 80,
  :word => 76,
  :atom => 34 },
# state 52
nil,
# state 53
nil,
# state 54
nil,
# state 55
nil,
# state 56
{ :domword => 87,
  :atom => 89,
  :domain => 90 },
# state 57
{ :by => 91 },
# state 58
nil,
# state 59
nil,
# state 60
{ :disp_params => 93 },
# state 61
nil,
# state 62
nil,
# state 63
{ :params => 95 },
# state 64
nil,
# state 65
nil,
# state 66
{ :word => 96,
  :atom => 34 },
# state 67
nil,
# state 68
nil,
# state 69
nil,
# state 70
nil,
# state 71
nil,
# state 72
{ :domword => 87,
  :atom => 89,
  :domain => 100 },
# state 73
{ :word => 68,
  :spec => 101,
  :atom => 34,
  :local => 50 },
# state 74
nil,
# state 75
nil,
# state 76
nil,
# state 77
{ :phrase => 103,
  :word => 28,
  :atom => 34 },
# state 78
nil,
# state 79
nil,
# state 80
nil,
# state 81
{ :routeaddr => 43,
  :phrase => 44,
  :mbox => 106,
  :word => 46,
  :spec => 48,
  :atom => 34,
  :local => 50 },
# state 82
{ :word => 107,
  :atom => 34 },
# state 83
{ :domword => 87,
  :atom => 89,
  :domain => 108 },
# state 84
{ :routeaddr => 43,
  :phrase => 44,
  :mbox => 45,
  :word => 46,
  :spec => 48,
  :mboxes => 109,
  :atom => 34,
  :local => 50 },
# state 85
{ :routeaddr => 43,
  :phrase => 51,
  :mbox => 52,
  :addr => 110,
  :word => 46,
  :spec => 48,
  :group => 54,
  :atom => 34,
  :local => 50 },
# state 86
nil,
# state 87
nil,
# state 88
nil,
# state 89
nil,
# state 90
nil,
# state 91
{ :via => 114 },
# state 92
{ :domword => 87,
  :atom => 89,
  :domain => 116 },
# state 93
nil,
# state 94
nil,
# state 95
nil,
# state 96
nil,
# state 97
nil,
# state 98
nil,
# state 99
nil,
# state 100
nil,
# state 101
nil,
# state 102
nil,
# state 103
{ :word => 76,
  :atom => 34 },
# state 104
nil,
# state 105
nil,
# state 106
nil,
# state 107
nil,
# state 108
nil,
# state 109
nil,
# state 110
nil,
# state 111
nil,
# state 112
{ :domword => 124,
  :atom => 89 },
# state 113
{ :domword => 87,
  :atom => 89,
  :domain => 125 },
# state 114
{ :with => 126 },
# state 115
nil,
# state 116
nil,
# state 117
{ :disp_param => 128 },
# state 118
{ :params => 130 },
# state 119
nil,
# state 120
{ :domword => 87,
  :atom => 89,
  :domain => 132 },
# state 121
nil,
# state 122
{ :hour => 134 },
# state 123
nil,
# state 124
nil,
# state 125
nil,
# state 126
{ :id => 137 },
# state 127
nil,
# state 128
nil,
# state 129
nil,
# state 130
nil,
# state 131
nil,
# state 132
nil,
# state 133
nil,
# state 134
{ :zone => 142 },
# state 135
nil,
# state 136
{ :msgid => 145 },
# state 137
{ :for => 147 },
# state 138
{ :atom => 149 },
# state 139
{ :value => 152 },
# state 140
nil,
# state 141
nil,
# state 142
nil,
# state 143
nil,
# state 144
nil,
# state 145
nil,
# state 146
{ :routeaddr => 43,
  :phrase => 51,
  :mbox => 52,
  :addr => 155,
  :word => 46,
  :spec => 48,
  :group => 54,
  :atom => 34,
  :local => 50 },
# state 147
{ :recvdatetime => 157 },
# state 148
nil,
# state 149
nil,
# state 150
nil,
# state 151
nil,
# state 152
nil,
# state 153
nil,
# state 154
nil,
# state 155
nil,
# state 156
{ :datetime => 159,
  :day => 23 },
# state 157
nil,
# state 158
nil,
# state 159
nil,
# state 160
nil
]   # LR goto table

DEBUG_PARSER = false

def _action_for_reduce_0( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_1( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.date = val[1] 
 result
end

def _action_for_reduce_2( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_3( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_4( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.addrs.replace val[1] 
 result
end

def _action_for_reduce_5( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.addr = val[1] 
 result
end

def _action_for_reduce_6( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.addrs.replace val[1] 
 result
end

def _action_for_reduce_7( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.addr = val[1] 
 result
end

def _action_for_reduce_8( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.msgid = val[1] 
 result
end

def _action_for_reduce_9( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.refs.replace val[1] 
 result
end

def _action_for_reduce_10( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.keys.replace val[1] 
 result
end

def _action_for_reduce_11( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_12( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_13( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_14( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_15( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_16( tok, val, _tokens, _values, _states )
 result = val[0]

      t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
    
 result
end

def _action_for_reduce_17( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_18( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_19( tok, val, _tokens, _values, _states )
 result = val[0]
 result = (val[0].to_i * 60 * 60) + (val[2].to_i * 60) 
 result
end

def _action_for_reduce_20( tok, val, _tokens, _values, _states )
 result = val[0]
 result = (val[0].to_i * 60 * 60) + (val[2].to_i * 60) + val[4].to_i 
 result
end

def _action_for_reduce_21( tok, val, _tokens, _values, _states )
 result = val[0]
 result = DateH.zone_s2i( val[0] ) * 60 
 result
end

def _action_for_reduce_22( tok, val, _tokens, _values, _states )
 result = val[0]

        @field.from  = val[0]
        @field.by    = val[1]
        @field.via   = val[2]
        @field.with.replace val[3]
        @field.msgid = val[4]
        @field.ford  = val[5]
        @field.date  = val[6]
      
 result
end

def _action_for_reduce_23( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_24( tok, val, _tokens, _values, _states )
 result = val[0]

      result = val[1]
      
 result
end

def _action_for_reduce_25( tok, val, _tokens, _values, _states )
 result = val[0]

        result = val[3]
      
 result
end

def _action_for_reduce_26( tok, val, _tokens, _values, _states )
 result = val[0]

        result = val[1]
      
 result
end

def _action_for_reduce_27( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_28( tok, val, _tokens, _values, _states )
 result = val[0]

        result = val[1]
      
 result
end

def _action_for_reduce_29( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_30( tok, val, _tokens, _values, _states )
 result = val[0]

        result = val[1]
      
 result
end

def _action_for_reduce_31( tok, val, _tokens, _values, _states )
 result = val[0]

        result = []
      
 result
end

def _action_for_reduce_32( tok, val, _tokens, _values, _states )
 result = val[0]

        result.push val[2]
      
 result
end

def _action_for_reduce_33( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_34( tok, val, _tokens, _values, _states )
 result = val[0]

        result = val[1]
      
 result
end

def _action_for_reduce_35( tok, val, _tokens, _values, _states )
 result = val[0]

        result = val[1]
      
 result
end

def _action_for_reduce_36( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_37( tok, val, _tokens, _values, _states )
 result = val[0]
 result = val[1] 
 result
end

def _action_for_reduce_38( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_39( tok, val, _tokens, _values, _states )
 result = val[0]
 result = val[1] 
 result
end

def _action_for_reduce_40( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_41( tok, val, _tokens, _values, _states )
 result = val[0]

        @field.routes.replace result.routes
        @field.addr = result.addr
      
 result
end

def _action_for_reduce_42( tok, val, _tokens, _values, _states )
 result = val[0]
 result = val 
 result
end

def _action_for_reduce_43( tok, val, _tokens, _values, _states )
 result = val[0]
 result.push val[2] 
 result
end

def _action_for_reduce_44( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_45( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_46( tok, val, _tokens, _values, _states )
 result = val[0]
 result = val 
 result
end

def _action_for_reduce_47( tok, val, _tokens, _values, _states )
 result = val[0]
 result.push val[2] 
 result
end

def _action_for_reduce_48( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_49( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_50( tok, val, _tokens, _values, _states )
 result = val[0]

        val[1].phrase = Bencode.decode( val[0] )
        result = val[1]
      
 result
end

def _action_for_reduce_51( tok, val, _tokens, _values, _states )
 result = val[0]
 result = AddrGroup.new( val[0], val[2] ) 
 result
end

def _action_for_reduce_52( tok, val, _tokens, _values, _states )
 result = val[0]

        val[2].route.replace val[1]
        result = val[2]
      
 result
end

def _action_for_reduce_53( tok, val, _tokens, _values, _states )
 result = val[0]
 result = val[1] 
 result
end

def _action_for_reduce_54( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_55( tok, val, _tokens, _values, _states )
 result = val[0]
 result = [ val[1] ] 
 result
end

def _action_for_reduce_56( tok, val, _tokens, _values, _states )
 result = val[0]
 result.push val[3] 
 result
end

def _action_for_reduce_57( tok, val, _tokens, _values, _states )
 result = val[0]
 result = Mbox.new( val.join('') ) 
 result
end

def _action_for_reduce_58( tok, val, _tokens, _values, _states )
 result = val[0]
 result = Mbox.new( val[0] ) 
 result
end

def _action_for_reduce_59( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_60( tok, val, _tokens, _values, _states )
 result = val[0]

        result.concat val[1]
        result.concat val[2]
      
 result
end

def _action_for_reduce_61( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_62( tok, val, _tokens, _values, _states )
 result = val[0]

        result.concat val[1]
        result.concat val[2]
      
 result
end

def _action_for_reduce_63( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_64( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_65( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_66( tok, val, _tokens, _values, _states )
 result = val[0]
 result = '<' + val[1].addr + '>' 
 result
end

def _action_for_reduce_67( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_68( tok, val, _tokens, _values, _states )
 result = val[0]
 result << ' ' << val[1] 
 result
end

def _action_for_reduce_69( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_70( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_71( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_72( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_73( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_74( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.encrypter = val[0] 
 result
end

def _action_for_reduce_75( tok, val, _tokens, _values, _states )
 result = val[0]

        @field.encrypter = val[0]
        @field.keyword   = val[1]
      
 result
end

def _action_for_reduce_76( tok, val, _tokens, _values, _states )
 result = val[0]

        @field.major = val[0].to_i
        @field.minor = val[2].to_i
      
 result
end

def _action_for_reduce_77( tok, val, _tokens, _values, _states )
 result = val[0]

        @field.main = val[0]
        @field.sub  = val[2]
      
 result
end

def _action_for_reduce_78( tok, val, _tokens, _values, _states )
 result = val[0]

        @field.main = val[0]
        @field.sub  = ''
      
 result
end

def _action_for_reduce_79( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_80( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.params.store( val[2].downcase, val[4] ) 
 result
end

def _action_for_reduce_81( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_82( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_83( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.encoding = val[0] 
 result
end

def _action_for_reduce_84( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.disposition = val[0] 
 result
end

def _action_for_reduce_85( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_86( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_87( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_88( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.params.store( val[0].downcase, val[2] ) 
 result
end

def _action_for_reduce_89( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.params.store( val[0].downcase, val[2] ) 
 result
end

def _action_for_reduce_90( tok, val, _tokens, _values, _states )
 result = val[0]
 @field.params.store( val[0].downcase, val[2] ) 
 result
end

def _action_for_reduce_91( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_92( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_93( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_94( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_95( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_96( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end

def _action_for_reduce_97( tok, val, _tokens, _values, _states )
 result = val[0]

 result
end
##### racc generated code end #####
end
