  include Recyclable

  def initialize
    @scanner = MailScanner.new
  end


  def reset
    self.debug = $mailpdebugflag
  end


  def debug=( flag )
    @yydebug = flag
    @scanner.debug = @yydebug && DEBUG_PARSER
  end


  def debug
    @yydebug
  end


  def Mailp.parse( hder, str )
    use_instance do |inst|
      inst.parse( hder, str )
    end
  end


  def parse( hder, str )
    hder.must HeaderField
    str.must String

    if /\A\s+\z/ === str then return end
    str = str.dup

    @field  = hder

    case hder
    when MsgidH
      msgid_parse( str )
    when RefH
      refs_parse( str )
    else
      @scanner.reset( str, @field )

      sim = hder.type.to_s
      sim = sim.split('::')[-1].to_s.intern
      @cache = [sim, nil]

      do_parse
    end
  end


  private


  def next_token
    if ret = @cache then
      @cache = nil
    else
      ret = @scanner.scan
    end
    ret
  end


=begin c
  def next_value
    if @valarr.size == 0 then
      @scanner.scan
    end
    return @valarr.shift
  end


  def peep_token
    if @simarr.size == 0 then
      ret = @scanner.scan( false )
    else
      ret = @simarr[0]
    end

    return ret
  end
=end c

  
  def on_error( tok, val, _tstack, _vstack, _state )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end


  def refs_parse( str )
    temp = []

    while MsgidH::MSGID === str do
      temp.push( ($`).strip )
      temp.push( $& )
      str = $'
    end
    temp.push str

    @field.refs.replace temp
  end


  def msgid_parse( str )
    if MsgidH::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError,
        "wrong Message-ID format: #{str}"
    end
  end

