
require 'rbconfig'
require 'ftools'

class TMAILinstaller < File

	include Config

	LIBDIR = [ CONFIG['libdir'], CONFIG['ruby_install_name'],
		         CONFIG['MAJOR'] + '.' + CONFIG['MINOR'], 'site_ruby' ].join( '/' )

	class << self

		def setup
			lib_install( 'tmail' ) do |to|
				install_rb to
			end

			lib_install( 'amstd' ) do |to|
				install_rb to
			end

			lib_install( 'racc' ) do |to|
				install_rb to

				chdir( 'strscan' ) do
					system "ruby extconf.rb && make && make install"
				end
			end
		end

		def chdir( dir )
			cur = Dir.pwd
			Dir.chdir dir
			yield
			Dir.chdir cur
		end

		def lib_install( libname )
			chdir( libname ) do
				dn = LIBDIR + '/' + libname
				mkpath dn
				yield dn
			end
		end

		def install_rb( to )
			Dir.glob( '*.rb' ) do |fn|
				if File.file? fn then
					install fn, to
				end
			end
		end
	
	end

end

if $0 == __FILE__ then
  TMAILinstaller.setup
end
