#
# tmail version 0.7.3
#
#     Copyright(c) 1998-1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#

require 'nkf'

require 'bug'
require 'must'
require 'extmod'

require 'tmail/field'
require 'tmail/port'
require 'tmail/loader'


class LostBoundary < StandardError ; end


class TTMail

  Version = '0.7.3'


  def initialize( port )
    @header   = {}
    @body     = ''
    @epilogue = ''
    @parts    = []

    @parsed   = false
    @parsing  = false

    @port = (port.must Port)
    parse_header
  end


  class << self

    def boundary
      return 'mimepart_' + random_tag
    end

    def msgid
      tmp = random_tag
      if (host = ENV['HOSTNAME']) then
        "<#{tmp}@#{host}>"
      else
        "<#{tmp}@tmail.on.ruby>"
      end
    end

    def random_tag
      ret = ('%x' % Time.now.strftime('%Y%m%d%H%M%S').to_i) + '_'
      1.upto(8){ srand ; ret << ('%x' % rand(255)) }
      return ret
    end
  
    def parse_on_rw( mname, r, w )
      nam = _name2str( mname )

      if r then
        module_eval %-
          def #{nam}
            unless @parsed then
              parse_body if @port
              @parsed = true
            end
            return @#{nam}
          end
        -
      end
      if w then
        module_eval %-
          def #{nam}=( str )
            str.must String
            unless @parsed then
              parse_body if @port
              @parsed = true
            end
            @#{nam} = str
          end
        -
      end
    end

  end



  ### body

  parse_on_rw :body,     true, true
  parse_on_rw :epilogue, true, true
  parse_on_rw :parts,    true, false

  alias preamble body

  class << self
    undef parse_on_rw
  end



  ### all

  def to_s( eol = "\n", hedsep = '' )
    conv_to_string( :to_s, eol, hedsep )
  end

  def inspect( eol = "\n", hedsep = '' )
    conv_to_string( :inspect, eol, hedsep )
  end

  def conv_to_string( sim, eol, hedsep )
    ret = ''
    multipart = (parts.size > 0)

    if multipart then
      bound = TMail.boundary
      store 'Content-Type', %|multipart/mixed; boundary="#{bound}"|
    end

    sep = eol + ' '
    each_pair do |k,v|
      ret << v.send( sim, sep ) << eol
    end
    ret << hedsep << eol << self.body

    if multipart then
      bnd = eol + '--' + bound + eol
      parts.each do |pa|
        ret << bnd << pa.send( sim, eol, '' )
      end
      ret << (eol + '--' + bound + '--' + eol)
      ret << self.epilogue
    end
    if ret.size < 2 or not /\n|\r/ === ret[-1,1] then
      ret << eol
    end

    return ret
  end
  private :conv_to_string



  ### header

  USE_ARRAY = [ 'received' ]


  def fetch( key, initbody = nil, &block )
    key.must String

    dkey = key.downcase
    ret = @header.fetch( dkey, initbody, &block )

    case ret
    when String
      ret = HeaderField.new( *ret.split(':', 2) )
      @header[dkey] = ret
    when Array
      ret.filter do |s|
        if String === s then
          HeaderField.new( *s.split(':', 2) )
        else
          s
        end
      end
    end

    ret
  end
  alias [] fetch


  def store( key, val )
    dkey = key.must(String).downcase

    if val == nil then
      @header[dkey] = nil
      return
    end

    case val
    when String
      val = HeaderField.new( key, val )
    when Array
      if USE_ARRAY.include? dkey then
        val.each{|i| i.must String, HeaderField }
      else
        raise ArgumentError, "#{key}: Header must not be multiple"
      end
    else
      val.must String, Array
    end

    @header[dkey] = val
  end
  alias []= store


  def each( &block )
    @header.each_key do |key|
      v = fetch( key )
      if Array === v then
        v.each{|i| yield key, i }
      else
        yield key, v
      end
    end
  end
  alias each_pair each

  def each_key( &block )
    @header.each_key( &block )
  end

  def each_value( &block )
    @header.each_key do |key|
      v = fetch( key )
      if Array === v then
        v.each( &block )
      else
        yield v
      end
    end
  end


  def direct_fetch( key )       # undoc
    @header[key.downcase]
  end

  def direct_store( key, val )  # undoc
    @header[key.downcase] = val
  end


  def clear
    @header.clear
  end

  def delete( key )
    @header.delete key.downcase
  end

  def delete_if
    @header.delete_if do |key,v|
      v = fetch( key )
      if Array === v then
        v.delete_if{|f| yield key, f }
        (v.size == 0)
      else
        yield key, v
      end
    end
  end


  def keys
    @header.keys
  end

  def has_key?( key )
    @header.has_key?( key.must(String).downcase )
  end
  alias include? has_key?
  alias key?     has_key?


  def values
    ret = []
    each_value{|v| ret.push v }
    return ret
  end

  def has_value?( val )
    return false unless HeaderField === val

    key = val.name.downcase
    v = fetch( key )
    if Array === v then v.include? val
    else                v ? true : false
    end
  end
  alias value? has_value?


  def indexes( *args )
    ret = []
    temp = nil
    args.each do |k|
      case temp = fetch(k)
      when Array
        ret.concat temp
      else
        ret.push temp
      end
    end
    return ret
  end
  alias indices indexes


  private


  def parse_header
    mhead = nil
    fname = nil
    errlog = []
    src = @stream = @port.ropen

    while line = src.gets do    # DON'T USE each loop !!!
      case line
      when /\A[ \t]/o   # continue from prev line
        unless mhead then
          errlog.push 'mail is began by space or tab'
          next
        end
        line.strip!
        mhead << ' ' << line

      else              # new header line
        if mhead then
          begin
            /\A[^\: \t]+/o === mhead
            fname = $&
            fname.downcase!

            if USE_ARRAY.include? fname then
              if tmp = @header[fname] then
                tmp.push mhead
              else
                @header[fname] = [mhead]
              end
            else
              @header[fname] = mhead
            end
          rescue
            errlog.push "wrong mail header: '#{mhead}'"
          end
        end
        line.strip!

        break if /\A\-*\z/o === line   # end of header
        mhead = line
      end
    end
    if errlog.size > 0 then
      raise ParseError, errlog.join("\n")
    end

    src.interrupt
  end


  def parse_body
    @stream.restart
    if multipart? then
      parsemulti( @stream, self['content-type'].params['boundary'] )
    else
      @body = @stream.readall
    end
    @stream.close
    @stream = nil
  end


  def parsemulti( src, bound )
    is_sep = /\A\-\-#{Regexp.quote(bound)}(?:\-\-)?[ \t]*(?:\n|\r\n|\r)/

    arr = []
    tmp = ''
    continu = true
    lastbound = '--' + bound + '--'

    while line = src.gets do
      if is_sep === line then
        tmp.chop!
        arr.push tmp
        tmp = ''

        line.strip!
        break if line == lastbound
      else
        tmp << line
      end
    end
    src.each{|line| tmp << line }

    @epilogue = tmp
    @body = arr.shift

    arr.filter do |i|
      self.type.new( StringPort.new(i) )
    end
    @parts = arr
  end

end



module TMailEasyAccess

  def to( dflt = '' )
    if hed = self[ 'to' ] then
      if ad = hed.addrs[0] then
        return ad.addr
      end
    end
    return dflt
  end

  def to=( addr )
    store 'To', addr
  end


  def from( dflt = '' )
    if hed = self[ 'from' ] then
      if ad = hed.addrs[0] then
        if ret = ad.addr then
          return ret
        end
      end
    end

    dflt
  end

  def from_phrase( dflt = '' )
    if hed = self[ 'from' ] then
      if ad = hed.addrs[0] then
        if ret = ad.phrase then
          return ret unless ret.empty?
        end
      end
    end

    dflt
  end

  def from=( addr )
    store 'From', addr
  end


  def subject( dflt = '' )
    if hed = self[ 'subject' ] then
      hed.body or dflt
    else
      return (dflt or nil)
    end
  end

  def subject=( str )
    store 'Subject', str
  end


  def msgid( dflt = '' )
    if hed = self[ 'message-id' ] then
      hed.msgid or dflt
    else
      dflt
    end
  end

  def msgid=( str )
    store 'Message-ID', str
  end


  def maintype( dflt = '' )
    if hed = self[ 'content-type' ] then
      hed.main or dflt
    else
      dflt
    end
  end

  def subtype( dflt = '' )
    if hed = self[ 'content-type' ] then
      hed.sub or dflt
    else
      dflt
    end
  end

  def set_contenttype( main, sub, param = nil )
    if hed = self['content-type'] then
      hed.main = main
      hed.sub  = sub
    else
      store 'Content-Type', main + '/' + sub
      if param then
        self['content-type'].params.replace param
      end
    end
  end


  def charset( dflt = '' )
    if hed = self[ 'content-type' ] then
      if ret = hed.params[ 'charset' ] then
        return ret
      end
    end
    return dflt
  end

  def charset=( str )
    if hed = self[ 'content-type' ] then
      hed.params.store 'charset', str
    else
      store "text/plain ; charset=#{str}"
    end
  end


  def encoding( dflt = '' )
    if hed = self[ 'content-transfer-encoding' ] then
      hed.encoding
    else
      dflt
    end
  end

  def encoding=( str )
    store 'Content-Transfer-Encoding', str
  end


  def each_dest( &block )
    self.indexes( 'to', 'cc', 'bcc' ).each do |temp|
      if temp then
        temp.addrs.each( &block )
      end
    end
  end

  def multipart?
    self.maintype.downcase == 'multipart'
  end

end



class TMail < TTMail

  include TMailEasyAccess
  property :filename, String, true, true

  class << self

    alias tmail_original_new new

    def new( arg = nil )
      tmail_original_new( arg ? Port.new( arg ) : StringPort.new( '' ) )
    end

    def loadfrom( fname )
      tm = tmail_original_new( FilePort.new fname )
      tm.filename = fname
      return tm
    end

  end

end
