
require 'rbconfig'
require 'ftools'

class TMAILinstaller < File

	include Config

	LIBDIR = [ CONFIG['libdir'], CONFIG['ruby_install_name'],
					   VERSION, 'site_ruby' ].join( '/' )

  def TMAILinstaller.setup
		tmdir = LIBDIR + '/tmail'
		mkpath tmdir
		Dir.glob( '*.rb' ) do |fn|
		  install fn, tmdir unless fn == 'setup.rb'
		end

		chdir( 'racc' ) do
			rcdir = LIBDIR + '/racc'
			mkpath rcdir
			Dir.glob( '*.rb' ) do |fn|
			  install fn, rcdir
			end

		  chdir( 'strscan' ) do
			  system "ruby extconf.rb && make && make install"
			end
		end
	end

	def TMAILinstaller.chdir( dir )
	  cur = Dir.pwd
		Dir.chdir dir
		yield
		Dir.chdir cur
	end

end

if $0 == __FILE__ then
  TMAILinstaller.setup
end
