#
#  extmod.rb
#
#    Copyright(c) 1999 Minero Aoki
#    aamine@dp.u-netsurf.ne.jp
#

require 'must'


class ImplementationError < StandardError ; end

class Module

  def abstract( name )
    mname = _name2str( name )

    module_eval %-
      def #{mname}( *args, &blk )
        raise ImplementationError, "abstract method '#{mname}' is called"
      end
    -
  end

  def property( name, tipe, r, w )
    name = _name2str( name )
    tipe = _type2str( tipe )

    if r then
			attr name
    end
    if w then
      module_eval %-
        def #{name}=(arg)
					arg.must #{tipe}
          @#{name} = arg
          arg
        end
      -
    end
  end
  alias attribute property

end


def _name2str( arg )
  case arg
  when String  then return arg
  when Integer then return arg.id2name
  else
    arg.must String, Integer
  end
end

def _type2str( arg )
  case arg
  when String  then return arg
  when Integer then return arg.id2name
  when Module  then return arg.to_s
  when Array
    return arg.collect{|i| _type2str i }.join(',')
  else
    arg.must String, Integer, Module, Array
  end
end
