
# mailp.y

class Mailp

rule

  content:

      DateH         datetime { @field.date = val[1] }
    | RecvH         received
    | RetpathH      returnpath
    | MaddrH        addrs { @field.addrs.replace val[1] }
    | SaddrH        addr { @field.addr = val[1] }
    | MsgidH        msgid { @field.msgid = val[1] }
    | RefH          refs { @field.refs.replace val[1] }
    | KeyH          keys { @field.keys.replace val[1] }
    | EncH          enc
    | VersionH      version
    | CTypeH        ctype
    | CEncodingH    cencode
    | CDispositionH cdisp
    ;
  
  datetime: day DIGIT ATOM DIGIT hour zone
    #       0   1     2    3     4    5
    #           day  month year
    {
      t = Time.gm( val[3], val[2], val[1], 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
    }
    ;
  
  day:  /* none */
    | ATOM ','
    ;
  
  hour: DIGIT ':' DIGIT
      { result = (val[0] * 60 * 60) + (val[2] * 60) }
    | DIGIT ':' DIGIT ':' DIGIT
      { result = (val[0] * 60 * 60) + (val[2] * 60) + val[4] }
    ;
  
  zone: ATOM { result = DateH.zone_s2i( val[0] ) * 60 };
  
  received: from by via with id for recvdatetime
      {
        @field.from  = val[0]
        @field.by    = val[1]
        @field.via   = val[2]
        @field.with.replace val[3]
        @field.msgid = val[4]
        @field.ford  = val[5]
        @field.date  = val[6]
      } ;

  from: /* none */
    | FROM domain
      {
      result = val[1]
      }
    | FROM domain '@' domain
      {
        result = val[3]
      }
    | FROM domain DOMLIT
      {
        result = val[1]
      }
    ;
  
  by:  /* none */
    | BY domain
      {
        result = val[1]
      }
    ;
  
  via:  /* none */
    | VIA ATOM
      {
        result = val[1]
      }
    ;
  
  with:  /* none */
      {
        result = []
      }
    | with WITH ATOM
      {
        result.push val[2]
      } ;
  
  id:  /* none */
    | ID msgid
      {
        result = val[1]
      }
    | ID ATOM
      {
        result = val[1]
      } ;
  
  for:  /* none */
    | FOR addr { result = val[1] } ;
  
  recvdatetime:  /* none */
    | ';' datetime { result = val[1] } ;
  
  returnpath: '<' '>'
    | routeaddr
      {
        @field.routes.replace result.routes
        @field.addr = result.addr
      }
    ;

  addrs: addr { result = [ result ] }
    | addrs ',' addr { result.push val[2] } ;

  addr: spec
    | routeaddr
    | phrase routeaddr
      {
        val[1].phrase = Bencode.decode( val[0] )
        result = val[1]
      }
    | group
    ;

  group: phrase ':' addrs ';' { result = AddrGroup.new( val[0], val[2] ) }
    |    phrase ':'       ';' { result = AddrGroup.new( val[0] ) }
    ;
  
  routeaddr: '<' route spec '>'
      {
        val[2].route.replace val[1]
        result = val[2]
      }
    | '<' spec '>' { result = val[1] }
    ;
  
  route: at_domains ':' ;
  
  at_domains: '@' domain { result = [ val[1] ] }
    | at_domains ',' '@' domain { result.push val[3] }
    ;
  
  spec: local '@' domain { result = Mbox.new( val.join('') ) }
    ;
  
  local: word
    | local '.' word
      {
        result.concat val[1]
        result.concat val[2]
      } ;
  
  domain: domword
    | domain '.' domword
      {
        result.concat val[1]
        result.concat val[2]
      } ;

  domword: atom
    | DOMLIT
    | DIGIT { result = result.to_s }
    ;

  msgid: '<' spec '>' { result = '<' + val[1].addr + '>' }
    ;
  
  phrase: word
    | phrase word { result << ' ' << val[1] }
    ;
  
  word: atom
    | QUOTED
    | DIGIT { result = result.to_s }
    ;

  keys: phrase
    | keys ',' phrase
    ;
  
/*
  now using normal code

  refs:
    .
      result = []
    .
    | refs ref
    .
      result.push val[1]
    .
    ;

  ref: phrase | msgid ;
*/

  enc: word { @field.encrypter = val[0] }
    | word word
      {
        @field.encrypter = val[0]
        @field.keyword   = val[1]
      } ;

  version: DIGIT '.' DIGIT
      {
        @field.major = val[0]
        @field.minor = val[2]
      } ;

  ctype: TOKEN '/' TOKEN params
      {
        @field.main = val[0]
        @field.sub  = val[2]
      }
    | TOKEN params
      {
        @field.main = val[0]
        @field.sub  = ''
      } ;
  
  params: /* none */
    | params ';' TOKEN '=' value
      { @field.params.store( val[2].downcase, val[4] ) }
    ;

  value: TOKEN | QUOTED ;

  cencode: TOKEN { @field.encoding = val[0] } ;

  cdisp: TOKEN disp_params { @field.disposition = val[0] } ;
  
  disp_params:  /* none */
    | disp_params ';' disp_param
    ;

  disp_param:
    | TOKEN '=' QUOTED { @field.params.store( val[0].downcase, val[2] ) }
    | TOKEN '=' VALUE  { @field.params.store( val[0].downcase, val[2] ) }
    | TOKEN '=' atom   { @field.params.store( val[0].downcase, val[2] ) }
    ;
  
  atom: ATOM | FROM | BY | VIA | WITH | ID | FOR ;
  
end   # rule

end   # class


---- prepare = tab.head.rb

---- inner = tab.inner.rb tab.scan.rb
