#
# recycle.rb
#
#     Copyright(c) 1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#
#
# usage:
#
# class A
#   include Recyclable
#   :
# end
#
# a = A.new( arg, to, class_a )
# puts a.id                                 #--> 5489
# A.finished a
#    :
# A.use_instance( arg, to, class_a ) do |a|
#   puts a.id                               #--> 5489
# end
#
# A.use_instance( arg, to, class_a ) do |a|
#   puts a.id                               #--> 5489
# end
#


module Recyclable

  BEGIN_GC_SIZE = 5

  def Recyclable.append_features( mod )
    super

    def mod.new( *args, &block )
      unless @spare then @spare = [] end

      gavage_collect

      if @spare.size > 0 then
        psr = @spare.shift  # recycle
        psr.reset( *args, &block )
      else
        psr = super         # make new
      end

      return psr
    end


    def mod.use_instance( *args, &block )
      inst = new( *args, &block )
      yield inst
      inst.type.finished inst
    end


    def mod.finished( inst )
      @spare.push inst
      gavage_collect
    end


    def mod.gavage_collect
      if @spare.size > Recyclable::BEGIN_GC_SIZE then
        @spare = @spare[ 0, @spare.size / 2 ]
      end
    end
  
  end

end
