require 'parser'
require 'recycle'
require 'scanner'

#
# mailp.rb
#
#     Copyright(c) 1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#

$mailpdebugflag = false



class Mailp < Parser

  include Recyclable

  def initialize
    @scanner = MailScanner.new
  end


  def reset
    self.debug = $mailpdebugflag
  end


  def debug=( flag )
    @__debug__ = flag
    @scanner.debug = @__debug__ && DEBUG_PARSER
  end


  def debug() @__debug__ end


  def Mailp.parse( hder, str )
    use_instance do |inst|
      inst.parse( hder, str )
    end
  end


  def parse( hder, str )
    hder.must HeaderField
    str.must String

    if /\A\s+\z/ === str then return end
    str = str.dup

    @field  = hder

    case hder
    when MsgidH
      msgid_parse( str )
    when RefH
      refs_parse( str )
    else
      @scanner.reset( str, @field )

      sim = hder.type.to_s
      sim = sim.split('::')[-1].to_s.intern
      @simarr = @scanner.spipe
      @valarr = @scanner.vpipe
      @simarr.push sim
      @valarr.push nil

      do_parse
    end
  end


  private


  def next_token
    if @simarr.size == 0 then
      @scanner.scan
    end
    return @simarr.shift
  end


  def next_value
    if @valarr.size == 0 then
      @scanner.scan
    end
    return @valarr.shift
  end


  def peep_token
    if @simarr.size == 0 then
      ret = @scanner.scan( false )
    else
      ret = @simarr[0]
    end

    return ret
  end

  
  def on_error( etok, sstack, vstack, __state__ )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{etok.inspect}"
  end


  def refs_parse( str )
    temp = []

    while MsgidH::MSGID === str do
      temp.push( ($`).strip )
      temp.push( $& )
      str = $'
    end
    temp.push str

    @field.refs.replace temp
  end


  def msgid_parse( str )
    if MsgidH::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError,
        "wrong Message-ID format: #{str}"
    end
  end



  class MailScanner < Scanner

    # mode

    MODE_NONE = :MODE_NONE

    MODE_822  = :MODE_822
    MODE_MIME = :MODE_MIME

    MODE_RECV = :MODE_RECV


    def reset( str, fld )
      super( str )
      @header = fld

      @m_atom = MODE_822
      @m_recv = MODE_NONE

      case fld
      when CTypeH
        @m_atom = MODE_MIME
      when CEncodingH, CDispositionH
        @m_atom = MODE_MIME
      when RecvH
        @m_recv = MODE_RECV
      end
    end


    # exp

    atomchars  = Regexp.quote( "\#!$%&`'*+{|}~^/=?" ) + '\\-'
    tokenchars = Regexp.quote( "\#!$%&`'*+{|}~^." )   + '\\-'
    eucchars   = "\xa1\xa1-\xf3\xfe"
    jisstr     = "\\e..[^\\e]*\\e.."

    ATOM    = /\A[\w#{atomchars}#{eucchars}]+|#{jisstr}/o
    TOKEN   = /\A[\w#{tokenchars}#{eucchars}]+|#{jisstr}/o
    DIGIT   = /\A\d+\z/o

    LWSP    = /\A(?:\n|\r\n|\r)?[ \t]+/o

    BACKSLASH = /\A\\/o

    BEGIN_Q = /\A"/o
    Q_ENT   = /\A[^"\\\e]+|#{jisstr}/o
    END_Q   = /\A"/o

    BEGIN_C = /\A\(/o
    C_ENT   = /\A[^\)\(\\\e]+|#{jisstr}/o
    END_C   = /\A\)/o

    BEGIN_D = /\A\[/o
    D_ENT   = /\A[^\]\\]+|#{jisstr}/o
    END_D   = /\A\]/o


    OMIT = '$omit'

    def scan( cut = true )
      sret = nil
      vret = OMIT

      until sret do
        unless @scan.rest? then
          @spipe.push false ; @vpipe.push nil
          @spipe.push false ; @vpipe.push nil
          break
        end

        @scan.skip LWSP

        if @m_atom == MODE_822 then
          if vret = @scan.fullscan( ATOM, true, cut ) then
            sret = :ATOM

            if DIGIT === vret then
              sret = :DIGIT
              vret = vret.to_i

            elsif @m_recv = MODE_RECV then
              case vret.downcase
              when 'from' then sret = :FROM
              when 'by'   then sret = :BY
              when 'via'  then sret = :VIA
              when 'with' then sret = :WITH
              when 'id'   then sret = :ID
              when 'for'  then sret = :FOR
              end
            end
            break
          end

        elsif @m_atom == MODE_MIME then
          if vret = @scan.fullscan( TOKEN, cut, cut ) then
            sret = :TOKEN
            break
          end
        else
          bug! 'atom mode is not 822/MIME'
        end

        if @scan.fullscan( BEGIN_Q, cut, cut ) then
          sret = :QUOTED
          vret = quoted if cut

        elsif @scan.skip( BEGIN_C ) then
          @header.comments.push comment

        elsif @scan.fullscan( BEGIN_D, cut, cut ) then
          sret = :DOMLIT
          vret = domlit if cut

        else
          sret = vret = @scan.getch
          unless cut then
            @scan.unscan
          end
        end
      end

      if cut then
        @spipe.push sret
        @vpipe.push vret
      end
      report_ret( sret, vret ) if @debug

      return sret
    end



    private


    def quoted
      ret = ''
      while true do
        if    temp = @scan.scan( Q_ENT ) then ret << temp
        elsif @scan.skip( END_Q )        then break
        elsif @scan.skip( BACKSLASH )    then ret << @scan.getch
        else
          unless @scan.rest? then
            scan_error! "found unterminated quoted-string"
          end
          bug! 'in quoted, no match'
        end
      end

      return ret
    end

    
    def comment
      ret = ''
      nest = 1

      while nest > 0 and @scan.rest? do
        if    temp = @scan.scan( C_ENT ) then ret << temp
        elsif @scan.skip( END_C )        then nest -= 1
        elsif @scan.skip( BEGIN_C )      then nest += 1
        elsif @scan.skip( BACKSLASH )    then ret << @scan.getch
        else
          unless @scan.rest? then
            scan_error! "found unterminated comment"
          end
          bug! 'in comment, no match'
        end
      end
      if nest > 0 then
        scan_error! "found unterminated comment"
      end

      return ret
    end

    
    def domlit
      ret = ''

      while true do
        if temp = @scan.scan( D_ENT ) then
          ret << temp
        end
        if    @scan.skip( END_D )     then break
        elsif @scan.skip( BACKSLASH ) then ret << @scan.getch
        else
          unless @scan.rest? then
            scan_error! "found unterminated domain literal"
          end
          bug! 'in domlit, no match'
        end
      end

      return ret
    end


    def report_ret( sret, ret )
      if Integer === sret then
        puts "sret #{sret.id2name || sret}"
      else
        puts "sret #{sret.inspect}"
      end
      puts "vret #{ret}"
    end

  end

##### racc generated code begin ###
LR_action_table = [
# state 0
Shift,
# state 1
Shift,
# state 2
Shift,
# state 3
Shift,
# state 4
Shift,
# state 5
Shift,
# state 6
{
:VIA => :__reduce_with_rule_21,
Anchor => :__reduce_with_rule_21,
:FROM => Shift,
:FOR => :__reduce_with_rule_21,
:BY => :__reduce_with_rule_21,
";" => :__reduce_with_rule_21,
:ID => :__reduce_with_rule_21,
:WITH => :__reduce_with_rule_21,
Default => :__reduce_with_rule_21
},
# state 7
Shift,
# state 8
Shift,
# state 9
Shift,
# state 10
Shift,
# state 11
Shift,
# state 12
Shift,
# state 13
Shift,
# state 14
{
:DIGIT => :__reduce_with_rule_15,
:ATOM => Shift,
Default => :__reduce_with_rule_15
},
# state 15
:__reduce_with_rule_89,
# state 16
:__reduce_with_rule_66,
# state 17
{
:VIA => Shift,
:DIGIT => Shift,
Anchor => :__reduce_with_rule_67,
"," => :__reduce_with_rule_67,
:FROM => Shift,
:FOR => Shift,
:BY => Shift,
:ID => Shift,
:QUOTED => Shift,
:ATOM => Shift,
:WITH => Shift,
Default => :__reduce_with_rule_67
},
# state 18
:__reduce_with_rule_87,
# state 19
:__reduce_with_rule_92,
# state 20
:__reduce_with_rule_88,
# state 21
:__reduce_with_rule_64,
# state 22
{
"," => Shift,
Anchor => :__reduce_with_rule_8,
Default => :__reduce_with_rule_8
},
# state 23
:__reduce_with_rule_91,
# state 24
:__reduce_with_rule_65,
# state 25
:__reduce_with_rule_86,
# state 26
:__reduce_with_rule_90,
# state 27
:__reduce_with_rule_62,
# state 28
:__reduce_with_rule_78,
# state 29
:__reduce_with_rule_12,
# state 30
Shift,
# state 31
:__reduce_with_rule_6,
# state 32
Shift,
# state 33
:__reduce_with_rule_10,
# state 34
Shift,
# state 35
:__reduce_with_rule_40,
# state 36
:__reduce_with_rule_42,
# state 37
Shift,
# state 38
:__reduce_with_rule_43,
# state 39
{
"," => Shift,
Anchor => :__reduce_with_rule_4,
Default => :__reduce_with_rule_4
},
# state 40
:__reduce_with_rule_45,
# state 41
Shift,
# state 42
{
:DIGIT => :__reduce_with_rule_62,
:VIA => :__reduce_with_rule_62,
:FROM => :__reduce_with_rule_62,
:FOR => :__reduce_with_rule_62,
"." => :__reduce_with_rule_54,
":" => :__reduce_with_rule_62,
:BY => :__reduce_with_rule_62,
"<" => :__reduce_with_rule_62,
:QUOTED => :__reduce_with_rule_62,
:ID => :__reduce_with_rule_62,
:ATOM => :__reduce_with_rule_62,
:WITH => :__reduce_with_rule_62,
Default => :__reduce_with_rule_54,
"@" => :__reduce_with_rule_54
},
# state 43
Shift,
# state 44
{
Anchor => :__reduce_with_rule_25,
:VIA => :__reduce_with_rule_25,
:FOR => :__reduce_with_rule_25,
:BY => Shift,
";" => :__reduce_with_rule_25,
:ID => :__reduce_with_rule_25,
:WITH => :__reduce_with_rule_25,
Default => :__reduce_with_rule_25
},
# state 45
:__reduce_with_rule_2,
# state 46
{
Anchor => :__reduce_with_rule_80,
";" => :__reduce_with_rule_80,
Default => :__reduce_with_rule_80
},
# state 47
:__reduce_with_rule_13,
# state 48
:__reduce_with_rule_7,
# state 49
{
Anchor => :__reduce_with_rule_74,
"/" => Shift,
";" => :__reduce_with_rule_74,
Default => :__reduce_with_rule_74
},
# state 50
:__reduce_with_rule_11,
# state 51
:__reduce_with_rule_5,
# state 52
:__reduce_with_rule_9,
# state 53
{
:VIA => Shift,
:DIGIT => Shift,
Anchor => :__reduce_with_rule_69,
:FROM => Shift,
:FOR => Shift,
:BY => Shift,
:ID => Shift,
:QUOTED => Shift,
:ATOM => Shift,
:WITH => Shift,
Default => :__reduce_with_rule_69
},
# state 54
:__reduce_with_rule_3,
# state 55
Shift,
# state 56
:__reduce_with_rule_39,
# state 57
:__reduce_with_rule_0,
# state 58
:__reduce_with_rule_1,
# state 59
Shift,
# state 60
Shift,
# state 61
:__reduce_with_rule_63,
# state 62
Shift,
# state 63
Shift,
# state 64
:__reduce_with_rule_54,
# state 65
Shift,
# state 66
Shift,
# state 67
:__reduce_with_rule_44,
# state 68
Shift,
# state 69
Shift,
# state 70
Shift,
# state 71
Shift,
# state 72
Shift,
# state 73
Shift,
# state 74
Shift,
# state 75
:__reduce_with_rule_60,
# state 76
:__reduce_with_rule_58,
# state 77
{
:VIA => :__reduce_with_rule_22,
Anchor => :__reduce_with_rule_22,
"." => Shift,
:FOR => :__reduce_with_rule_22,
:BY => :__reduce_with_rule_22,
";" => :__reduce_with_rule_22,
:ID => :__reduce_with_rule_22,
:DOMLIT => Shift,
:WITH => :__reduce_with_rule_22,
Default => :__reduce_with_rule_22,
"@" => Shift
},
# state 78
:__reduce_with_rule_59,
# state 79
:__reduce_with_rule_56,
# state 80
{
:VIA => Shift,
Anchor => :__reduce_with_rule_27,
:FOR => :__reduce_with_rule_27,
";" => :__reduce_with_rule_27,
:ID => :__reduce_with_rule_27,
:WITH => :__reduce_with_rule_27,
Default => :__reduce_with_rule_27
},
# state 81
Shift,
# state 82
{
Anchor => :__reduce_with_rule_79,
";" => Shift,
Default => :__reduce_with_rule_79
},
# state 83
Shift,
# state 84
{
Anchor => :__reduce_with_rule_73,
";" => Shift,
Default => :__reduce_with_rule_73
},
# state 85
:__reduce_with_rule_70,
# state 86
:__reduce_with_rule_38,
# state 87
:__reduce_with_rule_16,
# state 88
Shift,
# state 89
{
:VIA => Shift,
:DIGIT => Shift,
Anchor => :__reduce_with_rule_68,
"," => :__reduce_with_rule_68,
:FROM => Shift,
:FOR => Shift,
:BY => Shift,
:ID => Shift,
:QUOTED => Shift,
:ATOM => Shift,
:WITH => Shift,
Default => :__reduce_with_rule_68
},
# state 90
:__reduce_with_rule_61,
# state 91
:__reduce_with_rule_71,
# state 92
:__reduce_with_rule_47,
# state 93
Shift,
# state 94
Shift,
# state 95
:__reduce_with_rule_50,
# state 96
:__reduce_with_rule_49,
# state 97
Shift,
# state 98
{
"," => :__reduce_with_rule_51,
"." => Shift,
":" => :__reduce_with_rule_51,
Default => :__reduce_with_rule_51
},
# state 99
:__reduce_with_rule_41,
# state 100
:__reduce_with_rule_55,
# state 101
{
Anchor => :__reduce_with_rule_53,
"," => :__reduce_with_rule_53,
"." => Shift,
";" => :__reduce_with_rule_53,
">" => :__reduce_with_rule_53,
Default => :__reduce_with_rule_53
},
# state 102
Shift,
# state 103
:__reduce_with_rule_24,
# state 104
Shift,
# state 105
Shift,
# state 106
{
Anchor => :__reduce_with_rule_29,
:FOR => :__reduce_with_rule_29,
";" => :__reduce_with_rule_29,
:ID => :__reduce_with_rule_29,
:WITH => :__reduce_with_rule_29,
Default => :__reduce_with_rule_29
},
# state 107
{
Anchor => :__reduce_with_rule_26,
:VIA => :__reduce_with_rule_26,
"." => Shift,
:FOR => :__reduce_with_rule_26,
";" => :__reduce_with_rule_26,
:ID => :__reduce_with_rule_26,
:WITH => :__reduce_with_rule_26,
Default => :__reduce_with_rule_26
},
# state 108
{
:TOKEN => Shift,
Anchor => :__reduce_with_rule_82,
";" => :__reduce_with_rule_82,
Default => :__reduce_with_rule_82
},
# state 109
{
Anchor => :__reduce_with_rule_74,
";" => :__reduce_with_rule_74,
Default => :__reduce_with_rule_74
},
# state 110
Shift,
# state 111
Shift,
# state 112
:__reduce_with_rule_46,
# state 113
Shift,
# state 114
:__reduce_with_rule_48,
# state 115
:__reduce_with_rule_57,
# state 116
{
:VIA => :__reduce_with_rule_23,
Anchor => :__reduce_with_rule_23,
"." => Shift,
:FOR => :__reduce_with_rule_23,
:BY => :__reduce_with_rule_23,
";" => :__reduce_with_rule_23,
:ID => :__reduce_with_rule_23,
:WITH => :__reduce_with_rule_23,
Default => :__reduce_with_rule_23
},
# state 117
:__reduce_with_rule_28,
# state 118
{
Anchor => :__reduce_with_rule_31,
:FOR => :__reduce_with_rule_31,
";" => :__reduce_with_rule_31,
:ID => Shift,
:WITH => Shift,
Default => :__reduce_with_rule_31
},
# state 119
Shift,
# state 120
:__reduce_with_rule_81,
# state 121
{
Anchor => :__reduce_with_rule_72,
";" => Shift,
Default => :__reduce_with_rule_72
},
# state 122
Shift,
# state 123
Shift,
# state 124
{
"," => :__reduce_with_rule_52,
"." => Shift,
":" => :__reduce_with_rule_52,
Default => :__reduce_with_rule_52
},
# state 125
Shift,
# state 126
Shift,
# state 127
{
Anchor => :__reduce_with_rule_34,
:FOR => Shift,
";" => :__reduce_with_rule_34,
Default => :__reduce_with_rule_34
},
# state 128
Shift,
# state 129
Shift,
# state 130
Shift,
# state 131
Shift,
# state 132
:__reduce_with_rule_32,
# state 133
:__reduce_with_rule_33,
# state 134
:__reduce_with_rule_30,
# state 135
Shift,
# state 136
{
Anchor => :__reduce_with_rule_36,
";" => Shift,
Default => :__reduce_with_rule_36
},
# state 137
:__reduce_with_rule_85,
# state 138
:__reduce_with_rule_84,
# state 139
:__reduce_with_rule_83,
# state 140
:__reduce_with_rule_76,
# state 141
:__reduce_with_rule_75,
# state 142
:__reduce_with_rule_77,
# state 143
Shift,
# state 144
:__reduce_with_rule_19,
# state 145
:__reduce_with_rule_14,
# state 146
:__reduce_with_rule_35,
# state 147
:__reduce_with_rule_20,
# state 148
{
:DIGIT => :__reduce_with_rule_15,
:ATOM => Shift,
Default => :__reduce_with_rule_15
},
# state 149
{
":" => Shift,
:ATOM => :__reduce_with_rule_17,
Default => :__reduce_with_rule_17
},
# state 150
:__reduce_with_rule_37,
# state 151
Shift,
# state 152
:__reduce_with_rule_18
]   # LR action table

LR_goto_table = [
# state 0
{
:KeyH => 1,
:MsgidH => 3,
:CEncodingH => 2,
:MaddrH => 5,
:VersionH => 4,
:RecvH => 6,
:RefH => 8,
:CDispositionH => 7,
:SaddrH => 10,
:CTypeH => 9,
:content => 13,
:RetpathH => 12,
:EncH => 11,
:DateH => 14
},
# state 1
{
:phrase => 17,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:keys => 22,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 27
},
# state 2
{
:TOKEN => 28,
:cencode => 29
},
# state 3
{
:msgid => 31,
"<" => 30
},
# state 4
{
:DIGIT => 32,
:version => 33
},
# state 5
{
:addr => 35,
:phrase => 34,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 36,
:BY => 20,
:atom => 21,
"<" => 37,
:QUOTED => 24,
:ID => 23,
:addrs => 39,
:routeaddr => 38,
:ATOM => 25,
:group => 40,
:WITH => 26,
:local => 41,
:word => 42
},
# state 6
{
:FROM => 43,
:from => 44,
:received => 45
},
# state 7
{
:TOKEN => 46,
:cdisp => 47
},
# state 8
{
:refs => 48
},
# state 9
{
:ctype => 50,
:TOKEN => 49
},
# state 10
{
:addr => 51,
:phrase => 34,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 36,
:BY => 20,
:atom => 21,
"<" => 37,
:QUOTED => 24,
:ID => 23,
:routeaddr => 38,
:ATOM => 25,
:group => 40,
:WITH => 26,
:local => 41,
:word => 42
},
# state 11
{
:DIGIT => 16,
:VIA => 15,
:enc => 52,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 53
},
# state 12
{
:returnpath => 54,
"<" => 55,
:routeaddr => 56
},
# state 13
{
Anchor => 57
},
# state 14
{
:datetime => 58,
:ATOM => 59,
:day => 60
},
# state 15
nil,
# state 16
nil,
# state 17
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 61
},
# state 18
nil,
# state 19
nil,
# state 20
nil,
# state 21
nil,
# state 22
{
"," => 62
},
# state 23
nil,
# state 24
nil,
# state 25
nil,
# state 26
nil,
# state 27
nil,
# state 28
nil,
# state 29
nil,
# state 30
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 63,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:local => 41,
:word => 64
},
# state 31
nil,
# state 32
{
"." => 65
},
# state 33
nil,
# state 34
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
":" => 66,
:BY => 20,
:atom => 21,
"<" => 37,
:QUOTED => 24,
:ID => 23,
:routeaddr => 67,
:ATOM => 25,
:WITH => 26,
:word => 61
},
# state 35
nil,
# state 36
nil,
# state 37
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:at_domains => 68,
:FOR => 19,
:spec => 69,
:BY => 20,
:atom => 21,
:route => 70,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
"@" => 71,
:local => 41,
:word => 64
},
# state 38
nil,
# state 39
{
"," => 72
},
# state 40
nil,
# state 41
{
"." => 73,
"@" => 74
},
# state 42
nil,
# state 43
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:domain => 77,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 79,
:WITH => 26
},
# state 44
{
:by => 80,
:BY => 81
},
# state 45
nil,
# state 46
{
:disp_params => 82
},
# state 47
nil,
# state 48
nil,
# state 49
{
"/" => 83,
:params => 84
},
# state 50
nil,
# state 51
nil,
# state 52
nil,
# state 53
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 85
},
# state 54
nil,
# state 55
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:at_domains => 68,
:FOR => 19,
:spec => 69,
:BY => 20,
:atom => 21,
:route => 70,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
">" => 86,
:WITH => 26,
"@" => 71,
:local => 41,
:word => 64
},
# state 56
nil,
# state 57
nil,
# state 58
nil,
# state 59
{
"," => 87
},
# state 60
{
:DIGIT => 88
},
# state 61
nil,
# state 62
{
:phrase => 89,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 27
},
# state 63
{
">" => 90
},
# state 64
nil,
# state 65
{
:DIGIT => 91
},
# state 66
{
:addr => 35,
:phrase => 34,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 36,
:BY => 20,
";" => 92,
:atom => 21,
"<" => 37,
:QUOTED => 24,
:ID => 23,
:addrs => 93,
:routeaddr => 38,
:ATOM => 25,
:group => 40,
:WITH => 26,
:local => 41,
:word => 42
},
# state 67
nil,
# state 68
{
"," => 94,
":" => 95
},
# state 69
{
">" => 96
},
# state 70
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 97,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:local => 41,
:word => 64
},
# state 71
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:domain => 98,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 79,
:WITH => 26
},
# state 72
{
:addr => 99,
:phrase => 34,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 36,
:BY => 20,
:atom => 21,
"<" => 37,
:QUOTED => 24,
:ID => 23,
:routeaddr => 38,
:ATOM => 25,
:group => 40,
:WITH => 26,
:local => 41,
:word => 42
},
# state 73
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 100
},
# state 74
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:domain => 101,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 79,
:WITH => 26
},
# state 75
nil,
# state 76
nil,
# state 77
{
"." => 102,
:DOMLIT => 103,
"@" => 104
},
# state 78
nil,
# state 79
nil,
# state 80
{
:VIA => 105,
:via => 106
},
# state 81
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:domain => 107,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 79,
:WITH => 26
},
# state 82
{
";" => 108
},
# state 83
{
:TOKEN => 109
},
# state 84
{
";" => 110
},
# state 85
nil,
# state 86
nil,
# state 87
nil,
# state 88
{
:ATOM => 111
},
# state 89
{
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 21,
:QUOTED => 24,
:ID => 23,
:ATOM => 25,
:WITH => 26,
:word => 61
},
# state 90
nil,
# state 91
nil,
# state 92
nil,
# state 93
{
"," => 72,
";" => 112
},
# state 94
{
"@" => 113
},
# state 95
nil,
# state 96
nil,
# state 97
{
">" => 114
},
# state 98
{
"." => 102
},
# state 99
nil,
# state 100
nil,
# state 101
{
"." => 102
},
# state 102
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 115,
:WITH => 26
},
# state 103
nil,
# state 104
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:domain => 116,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 79,
:WITH => 26
},
# state 105
{
:ATOM => 117
},
# state 106
{
:with => 118
},
# state 107
{
"." => 102
},
# state 108
{
:TOKEN => 119,
:disp_param => 120
},
# state 109
{
:params => 121
},
# state 110
{
:TOKEN => 122
},
# state 111
{
:DIGIT => 123
},
# state 112
nil,
# state 113
{
:DIGIT => 75,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:atom => 76,
:domain => 124,
:ID => 23,
:DOMLIT => 78,
:ATOM => 25,
:domword => 79,
:WITH => 26
},
# state 114
nil,
# state 115
nil,
# state 116
{
"." => 102
},
# state 117
nil,
# state 118
{
:ID => 125,
:WITH => 126,
:id => 127
},
# state 119
{
"=" => 128
},
# state 120
nil,
# state 121
{
";" => 110
},
# state 122
{
"=" => 129
},
# state 123
{
:DIGIT => 130,
:hour => 131
},
# state 124
{
"." => 102
},
# state 125
{
:msgid => 132,
"<" => 30,
:ATOM => 133
},
# state 126
{
:ATOM => 134
},
# state 127
{
:FOR => 135,
:for => 136
},
# state 128
{
:VIA => 15,
:FROM => 18,
:FOR => 19,
:BY => 20,
:VALUE => 138,
:atom => 137,
:QUOTED => 139,
:ID => 23,
:ATOM => 25,
:WITH => 26
},
# state 129
{
:TOKEN => 140,
:value => 141,
:QUOTED => 142
},
# state 130
{
":" => 143
},
# state 131
{
:ATOM => 144,
:zone => 145
},
# state 132
nil,
# state 133
nil,
# state 134
nil,
# state 135
{
:addr => 146,
:phrase => 34,
:DIGIT => 16,
:VIA => 15,
:FROM => 18,
:FOR => 19,
:spec => 36,
:BY => 20,
:atom => 21,
"<" => 37,
:QUOTED => 24,
:ID => 23,
:routeaddr => 38,
:ATOM => 25,
:group => 40,
:WITH => 26,
:local => 41,
:word => 42
},
# state 136
{
:recvdatetime => 147,
";" => 148
},
# state 137
nil,
# state 138
nil,
# state 139
nil,
# state 140
nil,
# state 141
nil,
# state 142
nil,
# state 143
{
:DIGIT => 149
},
# state 144
nil,
# state 145
nil,
# state 146
nil,
# state 147
nil,
# state 148
{
:datetime => 150,
:ATOM => 59,
:day => 60
},
# state 149
{
":" => 151
},
# state 150
nil,
# state 151
{
:DIGIT => 152
},
# state 152
nil
]   # LR goto table

DEBUG_PARSER = false

def __reduce_with_rule_0( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push Accept
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_1( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.date = val[1] 
 return result
end

def __reduce_with_rule_2( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_3( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_4( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.addrs.replace val[1] 
 return result
end

def __reduce_with_rule_5( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.addr = val[1] 
 return result
end

def __reduce_with_rule_6( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.msgid = val[1] 
 return result
end

def __reduce_with_rule_7( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.refs.replace val[1] 
 return result
end

def __reduce_with_rule_8( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.keys.replace val[1] 
 return result
end

def __reduce_with_rule_9( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_10( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_11( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_12( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_13( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :content
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_14( vstack, sstack, __state__ )
 val = vstack[ -6, 6 ]
 sim = sstack[ -6, 6 ]
 vstack[ -6, 6 ] = []
 sstack[ -6, 6 ] = []
 sstack.push :datetime
 __state__[ -6, 6 ] = []
 result = val[0]
 
      t = Time.gm( val[3], val[2], val[1], 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
    
 return result
end

def __reduce_with_rule_15( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :day
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_16( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :day
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_17( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :hour
 __state__[ -3, 3 ] = []
 result = val[0]
  result = (val[0] * 60 * 60) + (val[2] * 60) 
 return result
end

def __reduce_with_rule_18( vstack, sstack, __state__ )
 val = vstack[ -5, 5 ]
 sim = sstack[ -5, 5 ]
 vstack[ -5, 5 ] = []
 sstack[ -5, 5 ] = []
 sstack.push :hour
 __state__[ -5, 5 ] = []
 result = val[0]
  result = (val[0] * 60 * 60) + (val[2] * 60) + val[4] 
 return result
end

def __reduce_with_rule_19( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :zone
 __state__[ -1, 1 ] = []
 result = val[0]
  result = DateH.zone_s2i( val[0] ) * 60 
 return result
end

def __reduce_with_rule_20( vstack, sstack, __state__ )
 val = vstack[ -7, 7 ]
 sim = sstack[ -7, 7 ]
 vstack[ -7, 7 ] = []
 sstack[ -7, 7 ] = []
 sstack.push :received
 __state__[ -7, 7 ] = []
 result = val[0]
 
        @field.from  = val[0]
        @field.by    = val[1]
        @field.via   = val[2]
        @field.with.replace val[3]
        @field.msgid = val[4]
        @field.ford  = val[5]
        @field.date  = val[6]
      
 return result
end

def __reduce_with_rule_21( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :from
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_22( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :from
 __state__[ -2, 2 ] = []
 result = val[0]
 
      result = val[1]
      
 return result
end

def __reduce_with_rule_23( vstack, sstack, __state__ )
 val = vstack[ -4, 4 ]
 sim = sstack[ -4, 4 ]
 vstack[ -4, 4 ] = []
 sstack[ -4, 4 ] = []
 sstack.push :from
 __state__[ -4, 4 ] = []
 result = val[0]
 
        result = val[3]
      
 return result
end

def __reduce_with_rule_24( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :from
 __state__[ -3, 3 ] = []
 result = val[0]
 
        result = val[1]
      
 return result
end

def __reduce_with_rule_25( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :by
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_26( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :by
 __state__[ -2, 2 ] = []
 result = val[0]
 
        result = val[1]
      
 return result
end

def __reduce_with_rule_27( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :via
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_28( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :via
 __state__[ -2, 2 ] = []
 result = val[0]
 
        result = val[1]
      
 return result
end

def __reduce_with_rule_29( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :with
 __state__[ 0, 0 ] = []
 result = val[0]
 
        result = []
      
 return result
end

def __reduce_with_rule_30( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :with
 __state__[ -3, 3 ] = []
 result = val[0]
 
        result.push val[2]
      
 return result
end

def __reduce_with_rule_31( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :id
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_32( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :id
 __state__[ -2, 2 ] = []
 result = val[0]
 
        result = val[1]
      
 return result
end

def __reduce_with_rule_33( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :id
 __state__[ -2, 2 ] = []
 result = val[0]
 
        result = val[1]
      
 return result
end

def __reduce_with_rule_34( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :for
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_35( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :for
 __state__[ -2, 2 ] = []
 result = val[0]
  result = val[1] 
 return result
end

def __reduce_with_rule_36( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :recvdatetime
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_37( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :recvdatetime
 __state__[ -2, 2 ] = []
 result = val[0]
  result = val[1] 
 return result
end

def __reduce_with_rule_38( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :returnpath
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_39( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :returnpath
 __state__[ -1, 1 ] = []
 result = val[0]
 
        @field.routes.replace result.routes
        @field.addr = result.addr
      
 return result
end

def __reduce_with_rule_40( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :addrs
 __state__[ -1, 1 ] = []
 result = val[0]
  result = [ result ] 
 return result
end

def __reduce_with_rule_41( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :addrs
 __state__[ -3, 3 ] = []
 result = val[0]
  result.push val[2] 
 return result
end

def __reduce_with_rule_42( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :addr
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_43( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :addr
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_44( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :addr
 __state__[ -2, 2 ] = []
 result = val[0]
 
        val[1].phrase = Bencode.decode( val[0] )
        result = val[1]
      
 return result
end

def __reduce_with_rule_45( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :addr
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_46( vstack, sstack, __state__ )
 val = vstack[ -4, 4 ]
 sim = sstack[ -4, 4 ]
 vstack[ -4, 4 ] = []
 sstack[ -4, 4 ] = []
 sstack.push :group
 __state__[ -4, 4 ] = []
 result = val[0]
  result = AddrGroup.new( val[0], val[2] ) 
 return result
end

def __reduce_with_rule_47( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :group
 __state__[ -3, 3 ] = []
 result = val[0]
  result = AddrGroup.new( val[0] ) 
 return result
end

def __reduce_with_rule_48( vstack, sstack, __state__ )
 val = vstack[ -4, 4 ]
 sim = sstack[ -4, 4 ]
 vstack[ -4, 4 ] = []
 sstack[ -4, 4 ] = []
 sstack.push :routeaddr
 __state__[ -4, 4 ] = []
 result = val[0]
 
        val[2].route.replace val[1]
        result = val[2]
      
 return result
end

def __reduce_with_rule_49( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :routeaddr
 __state__[ -3, 3 ] = []
 result = val[0]
  result = val[1] 
 return result
end

def __reduce_with_rule_50( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :route
 __state__[ -2, 2 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_51( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :at_domains
 __state__[ -2, 2 ] = []
 result = val[0]
  result = [ val[1] ] 
 return result
end

def __reduce_with_rule_52( vstack, sstack, __state__ )
 val = vstack[ -4, 4 ]
 sim = sstack[ -4, 4 ]
 vstack[ -4, 4 ] = []
 sstack[ -4, 4 ] = []
 sstack.push :at_domains
 __state__[ -4, 4 ] = []
 result = val[0]
  result.push val[3] 
 return result
end

def __reduce_with_rule_53( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :spec
 __state__[ -3, 3 ] = []
 result = val[0]
  result = Mbox.new( val.join('') ) 
 return result
end

def __reduce_with_rule_54( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :local
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_55( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :local
 __state__[ -3, 3 ] = []
 result = val[0]
 
        result.concat val[1]
        result.concat val[2]
      
 return result
end

def __reduce_with_rule_56( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :domain
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_57( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :domain
 __state__[ -3, 3 ] = []
 result = val[0]
 
        result.concat val[1]
        result.concat val[2]
      
 return result
end

def __reduce_with_rule_58( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :domword
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_59( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :domword
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_60( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :domword
 __state__[ -1, 1 ] = []
 result = val[0]
  result = result.to_s 
 return result
end

def __reduce_with_rule_61( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :msgid
 __state__[ -3, 3 ] = []
 result = val[0]
  result = '<' + val[1].addr + '>' 
 return result
end

def __reduce_with_rule_62( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :phrase
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_63( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :phrase
 __state__[ -2, 2 ] = []
 result = val[0]
  result << ' ' << val[1] 
 return result
end

def __reduce_with_rule_64( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :word
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_65( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :word
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_66( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :word
 __state__[ -1, 1 ] = []
 result = val[0]
  result = result.to_s 
 return result
end

def __reduce_with_rule_67( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :keys
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_68( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :keys
 __state__[ -3, 3 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_69( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :enc
 __state__[ -1, 1 ] = []
 result = val[0]
  @field.encrypter = val[0] 
 return result
end

def __reduce_with_rule_70( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :enc
 __state__[ -2, 2 ] = []
 result = val[0]
 
        @field.encrypter = val[0]
        @field.keyword   = val[1]
      
 return result
end

def __reduce_with_rule_71( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :version
 __state__[ -3, 3 ] = []
 result = val[0]
 
        @field.major = val[0]
        @field.minor = val[2]
      
 return result
end

def __reduce_with_rule_72( vstack, sstack, __state__ )
 val = vstack[ -4, 4 ]
 sim = sstack[ -4, 4 ]
 vstack[ -4, 4 ] = []
 sstack[ -4, 4 ] = []
 sstack.push :ctype
 __state__[ -4, 4 ] = []
 result = val[0]
 
        @field.main = val[0]
        @field.sub  = val[2]
      
 return result
end

def __reduce_with_rule_73( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :ctype
 __state__[ -2, 2 ] = []
 result = val[0]
 
        @field.main = val[0]
        @field.sub  = ''
      
 return result
end

def __reduce_with_rule_74( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :params
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_75( vstack, sstack, __state__ )
 val = vstack[ -5, 5 ]
 sim = sstack[ -5, 5 ]
 vstack[ -5, 5 ] = []
 sstack[ -5, 5 ] = []
 sstack.push :params
 __state__[ -5, 5 ] = []
 result = val[0]
  @field.params.store( val[2].downcase, val[4] ) 
 return result
end

def __reduce_with_rule_76( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :value
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_77( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :value
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_78( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :cencode
 __state__[ -1, 1 ] = []
 result = val[0]
  @field.encoding = val[0] 
 return result
end

def __reduce_with_rule_79( vstack, sstack, __state__ )
 val = vstack[ -2, 2 ]
 sim = sstack[ -2, 2 ]
 vstack[ -2, 2 ] = []
 sstack[ -2, 2 ] = []
 sstack.push :cdisp
 __state__[ -2, 2 ] = []
 result = val[0]
  @field.disposition = val[0] 
 return result
end

def __reduce_with_rule_80( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :disp_params
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_81( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :disp_params
 __state__[ -3, 3 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_82( vstack, sstack, __state__ )
 val = vstack[ 0, 0 ]
 sim = sstack[ 0, 0 ]
 vstack[ 0, 0 ] = []
 sstack[ 0, 0 ] = []
 sstack.push :disp_param
 __state__[ 0, 0 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_83( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :disp_param
 __state__[ -3, 3 ] = []
 result = val[0]
  @field.params.store( val[0].downcase, val[2] ) 
 return result
end

def __reduce_with_rule_84( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :disp_param
 __state__[ -3, 3 ] = []
 result = val[0]
  @field.params.store( val[0].downcase, val[2] ) 
 return result
end

def __reduce_with_rule_85( vstack, sstack, __state__ )
 val = vstack[ -3, 3 ]
 sim = sstack[ -3, 3 ]
 vstack[ -3, 3 ] = []
 sstack[ -3, 3 ] = []
 sstack.push :disp_param
 __state__[ -3, 3 ] = []
 result = val[0]
  @field.params.store( val[0].downcase, val[2] ) 
 return result
end

def __reduce_with_rule_86( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_87( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_88( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_89( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_90( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_91( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end

def __reduce_with_rule_92( vstack, sstack, __state__ )
 val = vstack[ -1, 1 ]
 sim = sstack[ -1, 1 ]
 vstack[ -1, 1 ] = []
 sstack[ -1, 1 ] = []
 sstack.push :atom
 __state__[ -1, 1 ] = []
 result = val[0]
 
 return result
end
##### racc generated code end #####
end   # class Mailp


