#
# loader.rb
#
#     Copyright(c) 1999 Minero Aoki
#     aamine@dp.u-netsurf.ne.jp
#

require 'must'
require 'port'


class MhLoader

  def initialize( dname )
    dname.must String
    @dirname = File.expand_path( dname )
    @oldnext = nil

    unless File.directory? @dirname then
      raise ArgumentError,
        "#{dname} is not directory."
    end
  end


  class << self

    def nextfile( dir )
      num = 0
      Dir.foreach( dir ) do |fname|
        if /\A\d+\z/o === fname then
          i = fname.to_i
          if i > num then
            num = i
          end
        end
      end
      num += 1

      return dir + '/' + num.to_s
    end

    def foreach( dir )
      new( dir ).each do |port|
        yield port
      end
    end
  
  end


  def nextfile
    num   = @oldnext || 1
    fname = @dirname + File::Separator + num.to_s

    while File.exist? fname do
      num += 1
      fname = @dirname + File::Separator + num.to_s
    end
    @oldnext = num

    return fname
  end


  def each_mail
    Dir.foreach( @dirname ) do |fname|
      next if /\A(\.|\#)/o === fname
      yield FilePort.new( @dirname + File::Separator + fname )
    end
  end
  alias each each_mail


  def new_port
    return FilePort.new( nextfile )
  end

end



class MboxLoader

  def initialize( fname )
    fname.must String
    @filename = File.expand_path( fname )

    unless File.file? @filename then
      raise ArgumentError,
        "#{fname} is not directory"
    end
  end


  def each_mail
    p = nil

    tmp = ''
    lock do |f|
      f.each do |line|
        if /\AFrom [^\r\n]+(\n|\r\n|\r|\z)/o then
          yield StringPort.new( tmp ) if tmp.size > 0
          tmp = ''
        else
          tmp << line
        end
      end
      yield StringPort.new( tmp ) if tmp.size > 0
    end
  end
  alias each each_mail


  def new_port
    raise
  end


  private


  def lock
    begin
      f = File.open( @filename )
      begin
        f.flock( File::LOCK_EX )
        yield f
      ensure
        f.flock( File::LOCK_UN )
      end
    ensure
      f.close if f
    end
  end

end



class MaildirLoader
end
