#
#  extmod.rb
#
#    Copyright(c) 1999 Minero Aoki
#    aamine@dp.u-netsurf.ne.jp
#

require 'must'


class Module

  def abstract( nam )
    mname = nameexp_to_string( nam )

    module_eval %-
      def #{mname}( *args, &blk )
        raise NotImplementError,
          "method '#{mname}' is not implemented"
      end
    -
  end


  def property( name, tipe, r, w )
    name = nameexp_to_string( name )
    tipe = typeexp_to_string( tipe )

    if r then
      module_eval %-
        def #{name}() @#{name} end
      -
    end
    if w then
      module_eval %-
        def #{name}=(arg)
          @#{name} = (arg.must( #{tipe} ))
          return self
        end
      -
    end
  end
  alias attribute property

end



def nameexp_to_string( arg )
  case arg
  when String  then return arg
  when Integer then return arg.id2name
  else
    arg.must String, Integer
  end
end

def typeexp_to_string( arg )
  case arg
  when String  then return arg
  when Integer then return arg.id2name
  when Module  then return arg.to_s
  when Array
    return arg.collect{|i| typeexp_to_string( i ) }.join(',')
  else
    arg.must String, Integer, Module, Array
  end
end
