require 'tmbase64'

def error( msg, s, e, ok )
  $stderr.puts "#{msg}: #{s.inspect} (expected #{ok.inspect} but #{e.inspect})"
end

def try( s )
  e = TMail::Base64.c_encode(s)
  ok = [s].pack('m').tr("\r\n", '')
  unless e == ok then
    error 'encode fail', s, e, ok
  end
  d = TMail::Base64.c_decode(e)
  unless s == d then
    error 'decode fail', s, d, s
  end
end

try ''
try 'a'
try 'ab'
try 'abc'
try 'abcd'
try 'abcde'
try 'abcdef'
try 'abcdefg'
try 'abcdefgh'
try 'abcdefghi'
try 'abcdefghij'
try 'abcdefghijk'
try 'abcdefghijkl'
try 'abcdefghijklm'
try 'abcedfghijklmn'
try 'abcedfghijklmno'
try 'abcedfghijklmnop'
try 'abcedfghijklmnopq'
try 'abcedfghijklmnopqr'
try 'abcedfghijklmnopqrs'
try 'abcedfghijklmnopqrst'
try 'abcedfghijklmnopqrstu'
try 'abcedfghijklmnopqrstuv'
try 'abcedfghijklmnopqrstuvw'
try 'abcedfghijklmnopqrstuvwx'
try 'abcedfghijklmnopqrstuvwxy'
try 'abcedfghijklmnopqrstuvwxyz'

[ "\0", "\001", "\002", "\003", "\0xfd", "\0xfe", "\0xff" ].each do |s|
  1.upto(256) {|i| try s * i }
end

srand
1.upto(256) do |i|
  s = ''
  i.times { s << rand(255) }
  try s
end
