#
# sendmail.rb
#

require 'tmail'
require 'net/smtp'
require 'nkf'


if ARGV.empty? or /\A--?h/ === ARGV[0] then
  $stderr.puts 'send mail script using local SMTP server'
  $stderr.puts 'To: and From: header must be correctly set'
  $stderr.puts 'usage: ruby sendmail.rb <mailfile>'
  exit 1
end


#
# create mail object
#
mail = TMail::Mail.load( ARGV[0] )

#
# get from-address and to-addresses
#
to = mail.destinations
from = mail.from_address
unless from then
  from = ENV['USER']
  if domain = (Socket.gethostname || ENV['HOSTNAME'] || ENV['HOST']) then
    from += '@' + domain
  end
end
$stderr.printf "%s -> %s\n", from, to.join(',')

#
# setup header fields
#
mail.delete 'bcc'
mail.delete 'received'
mail.date = Time.now
mail.delete_if {|n,v| v.empty? }
mail.mime_version = '1.0'

#
# setup mail body
#
body = mail.body
if NKF.guess(body) != NKF::BINARY then
  mail.body = NKF.nkf( '-j -m0', body )
  mail.set_content_type( 'text', 'plain', {'charset' => 'iso-2022-jp'} )
  mail.encoding = '7bit'
else
  mail.body = [body].pack('m')
  mail.set_content_type( 'application', 'octet-stream' )
  mail.encoding = 'Base64'
end

#
# send mail
#
$stderr.puts "sending mail (file #{ARGV[0]}) to #{to.join(', ')}"
smtp = Net::SMTP.new
smtp.set_debug_output $stderr if $DEBUG
smtp.start {
  str = mail.encoded
  $stderr.print str if $DEBUG
  smtp.sendmail str, from, to
}
