
require 'racc/parser'
#
# mailp.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'tmail/mails'


module TMail

class Mailp < Racc::Parser

  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && Racc_debug_parser
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  def Mailp.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  NATIVE_ROUTINE = {
    'TMail::MsgidH' => :msgid_parse,
    'TMail::RefH' => :refs_parse
  }

  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    if mid = NATIVE_ROUTINE[ obj.type.name ] then
      send mid, str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = MailScanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]
      @pass_array = [nil, nil]

      do_parse
    end
  end


  private


  def next_token
    if @first then
      ret = @first
      @first = nil
      ret
    else
      @scanner.scan @pass_array
    end
  end
  
  def on_error( tok, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end



  def refs_parse( str )
    arr = []

    while mdata = ::TMail::MSGID.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      proc_phrase pre, arr unless pre.empty?
      arr.push mdata.to_s
    end
    str.strip!
    proc_phrase str, arr unless pre.empty?

    @field.refs.replace arr
  end

  def proc_phrase( str, arr )
    while mdata = /"([^\\]*(?:\\.[^"\\]*)*)"/.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      arr.push pre unless pre.empty?
      arr.push mdata[1]
    end
    str.strip!
    arr.push unless str.empty?
  end


  def msgid_parse( str )
    if mdata = ::TMail::MSGID.match( str ) then
      @field.msgid = mdata.to_s
    else
      raise ParseError, "wrong Message-ID format: #{str}"
    end
  end

##### racc 0.12.1 generates ###

Racc_reduce_table = [
 0, 0, :racc_error,
 2, 40, :_reduce_1,
 2, 40, :_reduce_none,
 2, 40, :_reduce_none,
 2, 40, :_reduce_4,
 2, 40, :_reduce_5,
 2, 40, :_reduce_6,
 2, 40, :_reduce_7,
 2, 40, :_reduce_8,
 2, 40, :_reduce_9,
 2, 40, :_reduce_none,
 2, 40, :_reduce_none,
 2, 40, :_reduce_none,
 2, 40, :_reduce_none,
 2, 40, :_reduce_none,
 2, 40, :_reduce_15,
 2, 40, :_reduce_16,
 6, 39, :_reduce_17,
 0, 55, :_reduce_none,
 2, 55, :_reduce_none,
 3, 56, :_reduce_20,
 5, 56, :_reduce_21,
 1, 57, :_reduce_22,
 7, 41, :_reduce_none,
 0, 58, :_reduce_none,
 2, 58, :_reduce_25,
 4, 58, :_reduce_26,
 3, 58, :_reduce_27,
 0, 59, :_reduce_none,
 2, 59, :_reduce_29,
 0, 60, :_reduce_none,
 2, 60, :_reduce_31,
 0, 61, :_reduce_none,
 2, 61, :_reduce_33,
 0, 62, :_reduce_none,
 2, 62, :_reduce_35,
 2, 62, :_reduce_36,
 0, 63, :_reduce_none,
 2, 63, :_reduce_38,
 0, 64, :_reduce_none,
 2, 64, :_reduce_40,
 2, 42, :_reduce_none,
 1, 42, :_reduce_42,
 1, 43, :_reduce_43,
 3, 43, :_reduce_44,
 1, 44, :_reduce_none,
 1, 44, :_reduce_none,
 1, 45, :_reduce_47,
 3, 45, :_reduce_48,
 1, 46, :_reduce_none,
 1, 46, :_reduce_none,
 2, 46, :_reduce_51,
 4, 67, :_reduce_52,
 4, 66, :_reduce_53,
 3, 66, :_reduce_54,
 2, 69, :_reduce_none,
 2, 70, :_reduce_56,
 4, 70, :_reduce_57,
 3, 54, :_reduce_58,
 1, 54, :_reduce_59,
 1, 71, :_reduce_60,
 3, 71, :_reduce_61,
 1, 65, :_reduce_62,
 3, 65, :_reduce_63,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 3, 47, :_reduce_67,
 1, 68, :_reduce_none,
 2, 68, :_reduce_69,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 48, :_reduce_none,
 3, 48, :_reduce_none,
 1, 49, :_reduce_75,
 2, 49, :_reduce_76,
 3, 50, :_reduce_77,
 4, 51, :_reduce_78,
 2, 51, :_reduce_79,
 0, 75, :_reduce_none,
 5, 75, :_reduce_81,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 52, :_reduce_84,
 2, 53, :_reduce_85,
 0, 77, :_reduce_none,
 3, 77, :_reduce_none,
 0, 78, :_reduce_none,
 3, 78, :_reduce_89,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none ]

Racc_reduce_n = 97

Racc_shift_n = 162

Racc_action_table = [
     2,    16,     3,    15,     4,    14,     5,    13,     6,    12,
     7,    11,     8,    10,     9,     9,    10,     8,    11,     7,
    12,     6,    13,     5,    14,     4,    15,     3,    16,     2,
    17,     1,    -1,   -97,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    31,    31,    34,    26,    18,    25,
    19,    24,    22,    23,    25,    22,    26,    21,    27,    20,
    28,    19,    29,    18,    -1,   -97,    35,    37,    -1,   -97,
    35,    39,    -1,   -97,    35,    41,    -1,   -97,    18,    43,
    -1,   -97,    34,    26,    18,    25,    19,    24,    22,    23,
    25,    22,    26,    21,    27,    20,    28,    19,    29,    18,
    -1,   -97,    34,    26,    18,    25,    19,    24,    22,    23,
    25,    22,    26,    21,    27,    20,    28,    19,    29,    18,
    -1,   -97,    31,    50,    -1,   -97,    31,    31,    34,    26,
    18,    25,    19,    24,    22,    23,    25,    22,    26,    21,
    27,    20,    28,    19,    29,    18,    -1,   -97,    31,    31,
    34,    26,    18,    25,    19,    24,    22,    23,    25,    22,
    26,    21,    27,    20,    28,    19,    29,    18,    -1,   -97,
    31,    31,    34,    26,    18,    25,    19,    24,    22,    23,
    25,    22,    26,    21,    27,    20,    28,    19,    29,    18,
    -1,   -97,    31,    31,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    31,    61,    -1,   -97,    22,    64,
    -1,   -24,    19,    67,    18,   -18,    -1,   -97,     0,    70,
    -1,   -97,    -1,   -96,    -1,   -95,    -1,   -94,    -1,   -93,
    -1,   -92,    -1,   -91,    -1,   -90,    -1,   -72,    -1,   -71,
    -1,   -70,    -1,   -60,    23,    71,    33,    72,    -1,   -59,
    -1,   -16,    23,    73,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    23,   -60,    30,   -60,    20,   -60,
    33,   -60,     0,   -60,    -1,   -68,    31,    31,    34,    26,
    18,    25,    19,    24,    22,    23,    25,    22,    26,    21,
    27,    20,    28,    19,    29,    18,    -1,   -97,    -1,   -50,
    -1,   -49,    -1,   -15,    -1,   -86,    -1,   -14,    -1,   -84,
    -1,   -13,    36,    80,    -1,   -80,    -1,   -12,    33,    82,
    -1,   -97,    -1,   -11,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,     0,   -75,    -1,   -97,    -1,   -10,    34,    26,
    18,    25,    19,    24,    22,    23,    25,    22,    26,    21,
    27,    20,    28,    19,    29,    18,    -1,   -73,    -1,   -68,
    20,    84,     0,    -9,    -1,   -97,    34,    26,    18,    25,
    19,    24,    22,    23,    25,    22,    26,    21,    27,    20,
    28,    19,    29,    18,    -1,   -97,    -1,    -8,    -1,    -7,
    -1,   -47,    20,    86,     0,    -6,    -1,   -97,    21,    87,
    31,    31,    34,    26,    18,    25,    19,    24,    22,    23,
    25,    22,    26,    21,    27,    20,    28,    19,    29,    18,
    -1,   -97,    -1,   -46,    -1,   -45,    -1,    -5,    -1,   -43,
    20,    88,     0,    -4,    -1,   -97,    23,    73,    32,    89,
    34,    26,    18,    25,    19,    24,    22,    23,    25,    22,
    26,    21,    27,    20,    28,    19,    29,    18,    -1,   -97,
    -1,   -42,    -1,    -3,    24,    91,    18,    90,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    25,    95,    -1,   -28,    -1,    -2,
    20,    97,    -1,   -97,    18,    98,    -1,   -97,    -1,    -1,
     0,    99,    -1,   -97,    24,    91,    18,    90,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    24,    91,    18,    90,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    21,   103,    20,   104,    -1,   -97,
    32,   105,    -1,   -97,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    -1,   -69,    -1,   -51,    30,   107,
     0,   -85,    -1,   -97,    35,   108,    -1,   -97,    30,   109,
     0,   -79,    -1,   -97,    18,   110,    -1,   -97,    -1,   -76,
    34,    26,    18,    25,    19,    24,    22,    23,    25,    22,
    26,    21,    27,    20,    28,    19,    29,    18,    -1,   -97,
    32,   112,    -1,   -97,    31,    31,    34,    26,    18,    25,
    19,    24,    22,    23,    25,    22,    26,    21,    27,    20,
    28,    19,    29,    18,    -1,   -97,    31,    31,    34,    26,
    18,    25,    19,    24,    22,    23,    25,    22,    26,    21,
    27,    20,    28,    19,    29,    18,    -1,   -97,    31,    31,
    34,    26,    18,    25,    19,    24,    22,    23,    25,    22,
    26,    21,    27,    20,    28,    19,    29,    18,    -1,   -97,
    -1,   -41,    -1,   -66,    -1,   -65,    -1,   -64,    -1,   -62,
    23,   116,    24,   118,    33,   117,    -1,   -25,    24,    91,
    18,    90,    19,    24,    22,    23,    25,    22,    26,    21,
    27,    20,    28,    19,    29,    18,    -1,   -97,    26,   120,
    -1,   -30,    -1,   -19,    19,   122,    -1,   -97,    -1,   162,
    33,   117,    -1,   -58,    -1,   -61,    33,   117,    -1,   -56,
    -1,   -55,    23,   123,    -1,   -97,    -1,   -54,    32,   124,
    -1,   -97,    35,   125,    -1,   -88,    -1,   -80,    35,   128,
    -1,   -97,    -1,   -77,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -74,    -1,   -67,    -1,   -48,    30,   129,
    20,    86,    -1,   -97,    -1,   -44,    24,    91,    18,    90,
    19,    24,    22,    23,    25,    22,    26,    21,    27,    20,
    28,    19,    29,    18,    -1,   -97,    24,    91,    18,    90,
    19,    24,    22,    23,    25,    22,    26,    21,    27,    20,
    28,    19,    29,    18,    -1,   -97,    -1,   -27,    33,   117,
    -1,   -29,    19,   132,    -1,   -97,    27,   133,    -1,   -32,
    18,   135,    -1,   -97,    24,    91,    18,    90,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    -1,   -53,    37,   137,    -1,   -97,
    -1,   -87,    30,   109,     0,   -78,    -1,   -97,    37,   138,
    -1,   -97,    -1,   -52,    33,   117,    -1,   -26,    -1,   -63,
    -1,   -31,    19,   139,    -1,   -97,    28,   140,    -1,   -34,
    18,   142,    -1,   -97,    33,   117,    -1,   -57,    35,   146,
    34,   145,    -1,   -97,    35,   146,    34,   145,    -1,   -97,
    -1,   -33,    31,    50,    19,   148,    -1,   -97,    29,   150,
    -1,   -37,    21,   152,    -1,   -97,    19,   153,    -1,   -97,
    -1,   -89,    -1,   -83,    -1,   -82,    -1,   -81,    -1,   -36,
    -1,   -35,    31,    31,    34,    26,    18,    25,    19,    24,
    22,    23,    25,    22,    26,    21,    27,    20,    28,    19,
    29,    18,    -1,   -97,    30,   156,     0,   -39,    -1,   -97,
    18,   158,    -1,   -97,    -1,   -22,    -1,   -17,    -1,   -38,
    19,    67,    18,   -18,    -1,   -97,    -1,   -23,    21,   160,
    19,   -20,    -1,   -97,    -1,   -40,    18,   161,    -1,   -97,
    -1,   -21 ]

Racc_action_table_ptr = [
     0,    34,    54,    76,    80,    84,    88,    92,   112,   132,
   136,   158,   180,   202,   224,   228,   232,   238,   242,   244,
   246,   248,   250,   252,   254,   256,   258,   260,   262,   264,
   270,   272,   294,   306,   328,   330,   332,   334,   336,   338,
   340,   342,   346,   348,   352,   354,   376,   378,   398,   400,
   406,   426,   428,   430,   432,   438,   462,   464,   466,   468,
   470,   476,   500,   502,   504,   524,   528,   530,   534,   538,
   540,   544,   564,   584,   604,   610,   614,   634,   636,   638,
   644,   648,   654,   658,   660,   680,   684,   706,   728,   750,
   752,   754,   756,   758,   760,   768,   788,   792,   794,   798,
   800,   804,   806,   810,   812,   816,   818,   822,   826,   828,
   832,   834,   854,   856,   858,   864,   866,   886,   906,   908,
   912,   916,   920,   924,   944,   946,   950,   952,   958,   962,
   964,   968,   970,   972,   976,   980,   984,   988,   994,  1000,
  1002,  1008,  1012,  1016,  1020,  1022,  1024,  1026,  1028,  1030,
  1032,  1054,  1060,  1064,  1066,  1068,  1070,  1076,  1078,  1084,
  1086,  1090 ]


Racc_goto_table = [
    40,    17,    74,    27,    72,    28,    71,    29,    54,    30,
    74,    27,    72,    32,    71,    29,    68,    33,    66,    34,
    54,    35,    46,    36,    53,    38,    52,    40,    51,    42,
    50,    44,    72,    45,    74,    27,    49,    46,    74,    27,
    68,    47,    72,    48,    48,    49,    47,    51,    74,    27,
    72,    32,    71,    29,    68,    33,    66,    34,    54,    35,
    46,    52,    74,    27,    72,    32,    71,    29,    68,    33,
    66,    34,    54,    35,    46,    53,    45,    54,    74,    27,
    72,    32,    71,    29,    68,    55,    66,    34,    54,    35,
    67,    56,    46,    57,    44,    58,    74,    27,    72,    32,
    71,    29,    68,    55,    66,    34,    54,    35,    67,    56,
    46,    57,    44,    59,    43,    60,    66,    62,    42,    63,
    58,    65,    41,    66,    55,    68,    39,    69,    74,    27,
    72,    28,    71,    29,    70,    74,    54,    75,    69,    76,
    74,    27,    72,    77,    66,    78,    77,    79,    75,    81,
    72,    83,    74,    27,    74,    27,    72,    77,    74,    27,
    54,    85,    72,    28,    71,    29,    74,    27,    72,    77,
    66,    78,    74,    27,    72,    28,    71,    29,    70,    74,
    54,    75,    69,    76,    74,    92,    73,    93,    65,    94,
    59,    96,    74,    92,    73,    93,    65,   100,    74,    27,
    72,   101,    74,    92,    73,    93,    65,   102,    74,    27,
    72,    28,    71,    29,    54,   106,    74,    27,    68,   111,
    72,    48,    74,    27,    72,    32,    71,    29,    68,    33,
    66,    34,    54,    35,    46,   113,    74,    27,    72,    32,
    71,    29,    68,    33,    66,    34,    54,    35,    45,   114,
    46,    53,    74,    27,    72,    32,    71,    29,    68,    55,
    66,    34,    54,    35,    67,    56,    46,    57,    44,   115,
    74,    92,    73,    93,    65,   119,    60,   121,    78,   126,
    75,   127,    74,    27,    72,    77,    74,    92,    73,    93,
    65,   130,    74,    92,    73,   131,    61,   134,    74,    92,
    73,    93,    65,   136,    62,   141,    56,   143,    76,   144,
    76,   147,    47,   149,    63,   151,    57,   154,    74,    27,
    72,    32,    71,    29,    68,    55,    66,    34,    54,    35,
    67,    56,    46,    57,    44,   155,    64,   157,    39,   159,
    55,    68,    -1,    -1 ]

Racc_goto_table_ptr = [
     0,     2,    10,    24,    26,    28,    30,    32,    38,    46,
    48,    62,    78,    96,   116,   120,   124,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   128,    -1,   140,    -1,    -1,    -1,   146,    -1,    -1,
    -1,   148,    -1,    -1,    -1,   150,    -1,   154,    -1,    -1,
   158,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,
    -1,   172,    -1,    -1,   184,   190,    -1,    -1,    -1,    -1,
    -1,   192,   198,   202,    -1,    -1,   208,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   216,    -1,   222,   236,   252,    -1,
    -1,    -1,    -1,    -1,    -1,   270,   276,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,   280,    -1,
    -1,   282,    -1,    -1,    -1,    -1,   286,   292,    -1,    -1,
    -1,   296,    -1,   298,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   304,   306,    -1,   308,   310,    -1,
   312,   314,    -1,   316,    -1,    -1,    -1,    -1,    -1,    -1,
   318,   336,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,
    -1,    -1 ]


Racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :KeyH => 10,
 :EncH => 11,
 :VersionH => 12,
 :CTypeH => 13,
 :CEncodingH => 14,
 :CDispositionH => 15,
 :Mbox => 16,
 :Spec => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37 }

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

 module_eval( '', 'mailp.y', 14 ) {
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
 }

 # reduce 2 omitted

 # reduce 3 omitted

 module_eval( '', 'mailp.y', 17 ) {
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 18 ) {
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 19 ) {
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 20 ) {
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 21 ) {
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 22 ) {
  def _reduce_9( val, _values, result )
 @field.keys.replace val[1]
   result
  end
 }

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 module_eval( '', 'mailp.y', 30 ) {
  def _reduce_15( val, _values, result )
                  mb = val[1]
                  @field.phrase = mb.phrase
                  @field.setroute mb.route
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
 }

 module_eval( '', 'mailp.y', 38 ) {
  def _reduce_16( val, _values, result )
                  mb = val[1]
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
 }

 module_eval( '', 'mailp.y', 48 ) {
  def _reduce_17( val, _values, result )
                  t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
                  result = (t + val[4] - val[5]).localtime
   result
  end
 }

 # reduce 18 omitted

 # reduce 19 omitted

 module_eval( '', 'mailp.y', 59 ) {
  def _reduce_20( val, _values, result )
                  result = (result.to_i * 60 * 60) + (val[2].to_i * 60)
   result
  end
 }

 module_eval( '', 'mailp.y', 63 ) {
  def _reduce_21( val, _values, result )
                  result = (result.to_i * 60 * 60) +
                           (val[2].to_i * 60)
                           + val[4].to_i
   result
  end
 }

 module_eval( '', 'mailp.y', 71 ) {
  def _reduce_22( val, _values, result )
                  result = ::TMail.zonestr2i( val[0] ) * 60
   result
  end
 }

 # reduce 23 omitted

 # reduce 24 omitted

 module_eval( '', 'mailp.y', 81 ) {
  def _reduce_25( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
 }

 module_eval( '', 'mailp.y', 85 ) {
  def _reduce_26( val, _values, result )
                  @field.from = Address.join( val[3] )
   result
  end
 }

 module_eval( '', 'mailp.y', 89 ) {
  def _reduce_27( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
 }

 # reduce 28 omitted

 module_eval( '', 'mailp.y', 96 ) {
  def _reduce_29( val, _values, result )
                  @field.by = Address.join( val[1] )
   result
  end
 }

 # reduce 30 omitted

 module_eval( '', 'mailp.y', 103 ) {
  def _reduce_31( val, _values, result )
                  @field.via = val[1]
   result
  end
 }

 # reduce 32 omitted

 module_eval( '', 'mailp.y', 110 ) {
  def _reduce_33( val, _values, result )
                  @field.with.push val[1]
   result
  end
 }

 # reduce 34 omitted

 module_eval( '', 'mailp.y', 117 ) {
  def _reduce_35( val, _values, result )
                  @field.msgid = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 121 ) {
  def _reduce_36( val, _values, result )
                  @field.msgid = val[1]
   result
  end
 }

 # reduce 37 omitted

 module_eval( '', 'mailp.y', 128 ) {
  def _reduce_38( val, _values, result )
                  @field.for_ = val[1].address
   result
  end
 }

 # reduce 39 omitted

 module_eval( '', 'mailp.y', 136 ) {
  def _reduce_40( val, _values, result )
                  @field.date = val[1]
   result
  end
 }

 # reduce 41 omitted

 module_eval( '', 'mailp.y', 143 ) {
  def _reduce_42( val, _values, result )
                  @field.route.replace result.route
                  @field.addr = result.addr
   result
  end
 }

 module_eval( '', 'mailp.y', 148 ) {
  def _reduce_43( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 149 ) {
  def _reduce_44( val, _values, result )
 result.push val[2]
   result
  end
 }

 # reduce 45 omitted

 # reduce 46 omitted

 module_eval( '', 'mailp.y', 158 ) {
  def _reduce_47( val, _values, result )
                  result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 162 ) {
  def _reduce_48( val, _values, result )
                  result.push val[2]
   result
  end
 }

 # reduce 49 omitted

 # reduce 50 omitted

 module_eval( '', 'mailp.y', 170 ) {
  def _reduce_51( val, _values, result )
                  val[1].phrase = HFdecoder.decode( result )
                  result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 177 ) {
  def _reduce_52( val, _values, result )
                  result = AddressGroup.new( result, val[2] )
   result
  end
 }

 module_eval( '', 'mailp.y', 184 ) {
  def _reduce_53( val, _values, result )
                  result = val[2]
                  result.route = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 189 ) {
  def _reduce_54( val, _values, result )
                  result = val[1]
   result
  end
 }

 # reduce 55 omitted

 module_eval( '', 'mailp.y', 196 ) {
  def _reduce_56( val, _values, result )
 result = [ val[1] ]
   result
  end
 }

 module_eval( '', 'mailp.y', 197 ) {
  def _reduce_57( val, _values, result )
 result.push val[3]
   result
  end
 }

 module_eval( '', 'mailp.y', 200 ) {
  def _reduce_58( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
 }

 module_eval( '', 'mailp.y', 201 ) {
  def _reduce_59( val, _values, result )
 result = Address.new( result, nil )
   result
  end
 }

 module_eval( '', 'mailp.y', 204 ) {
  def _reduce_60( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 205 ) {
  def _reduce_61( val, _values, result )
 result.push val[2]
   result
  end
 }

 module_eval( '', 'mailp.y', 208 ) {
  def _reduce_62( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 209 ) {
  def _reduce_63( val, _values, result )
 result.push val[2]
   result
  end
 }

 # reduce 64 omitted

 # reduce 65 omitted

 # reduce 66 omitted

 module_eval( '', 'mailp.y', 219 ) {
  def _reduce_67( val, _values, result )
                  val[1] = val[1].addr
                  result = val.join('')
   result
  end
 }

 # reduce 68 omitted

 module_eval( '', 'mailp.y', 225 ) {
  def _reduce_69( val, _values, result )
 result << ' ' << val[1]
   result
  end
 }

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

 module_eval( '', 'mailp.y', 239 ) {
  def _reduce_75( val, _values, result )
                  @field.encrypter = val[0]
   result
  end
 }

 module_eval( '', 'mailp.y', 243 ) {
  def _reduce_76( val, _values, result )
                  @field.encrypter = val[0]
                  @field.keyword   = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 250 ) {
  def _reduce_77( val, _values, result )
                  @field.major = val[0].to_i
                  @field.minor = val[2].to_i
   result
  end
 }

 module_eval( '', 'mailp.y', 257 ) {
  def _reduce_78( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = val[2]
   result
  end
 }

 module_eval( '', 'mailp.y', 262 ) {
  def _reduce_79( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = ''
   result
  end
 }

 # reduce 80 omitted

 module_eval( '', 'mailp.y', 270 ) {
  def _reduce_81( val, _values, result )
                  @field.params[ val[2].downcase ] = val[4]
   result
  end
 }

 # reduce 82 omitted

 # reduce 83 omitted

 module_eval( '', 'mailp.y', 280 ) {
  def _reduce_84( val, _values, result )
                  @field.encoding = val[0]
   result
  end
 }

 module_eval( '', 'mailp.y', 286 ) {
  def _reduce_85( val, _values, result )
                  @field.disposition = val[0]
   result
  end
 }

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 module_eval( '', 'mailp.y', 298 ) {
  def _reduce_89( val, _values, result )
                  @field.params[ val[0].downcase ] = val[2]
   result
  end
 }

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

end

end   # module TMail
