
require 'racc/parser'
#
# mailp.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'tmail/mails'


module TMail


class Mailp < Racc::Parser

  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && DEBUG_PARSER
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  def Mailp.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    case obj
    when MsgidH
      msgid_parse str
    when RefH
      refs_parse str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = MailScanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]
      @pass_array = [nil, nil]

      do_parse
    end
  end


  private


  def next_token
    if @first then
      ret = @first
      @first = nil
      ret
    else
      @scanner.scan @pass_array
    end
  end
  
  def on_error( tok, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}' header, on token #{val.inspect}"
  end


  def refs_parse( str )
    arr = []

    while ::TMail::MSGID === str do
      p   = $`
      m   = $&
      str = $'

      p.strip!
      arr.push p
      arr.push m
    end
    str.strip!
    arr.push str unless str.empty?

    @field.refs.replace arr
  end

  def msgid_parse( str )
    if ::TMail::MSGID === str then
      @field.msgid = $&
    else
      raise ParseError, "wrong Message-ID format: #{str}"
    end
  end


##### racc 0.10.10 generates ###

Racc_reduce_table = [
0, 0, :racc_error,
2, 42, :_reduce_1,
2, 42, :_reduce_none,
2, 42, :_reduce_none,
2, 42, :_reduce_4,
2, 42, :_reduce_5,
2, 42, :_reduce_6,
2, 42, :_reduce_7,
2, 42, :_reduce_8,
2, 42, :_reduce_9,
2, 42, :_reduce_10,
2, 42, :_reduce_none,
2, 42, :_reduce_none,
2, 42, :_reduce_none,
2, 42, :_reduce_none,
2, 42, :_reduce_none,
2, 42, :_reduce_16,
2, 42, :_reduce_17,
6, 41, :_reduce_18,
0, 57, :_reduce_none,
2, 57, :_reduce_none,
3, 58, :_reduce_21,
5, 58, :_reduce_22,
1, 59, :_reduce_23,
7, 43, :_reduce_24,
0, 60, :_reduce_none,
2, 60, :_reduce_26,
4, 60, :_reduce_27,
3, 60, :_reduce_28,
0, 61, :_reduce_none,
2, 61, :_reduce_30,
0, 62, :_reduce_none,
2, 62, :_reduce_32,
0, 63, :_reduce_33,
3, 63, :_reduce_34,
0, 64, :_reduce_none,
2, 64, :_reduce_36,
2, 64, :_reduce_37,
0, 65, :_reduce_none,
2, 65, :_reduce_39,
0, 66, :_reduce_none,
2, 66, :_reduce_41,
2, 44, :_reduce_none,
1, 44, :_reduce_43,
1, 45, :_reduce_44,
3, 45, :_reduce_45,
1, 46, :_reduce_none,
1, 46, :_reduce_none,
1, 47, :_reduce_48,
3, 47, :_reduce_49,
1, 48, :_reduce_none,
1, 48, :_reduce_none,
2, 48, :_reduce_52,
4, 69, :_reduce_53,
4, 68, :_reduce_54,
3, 68, :_reduce_55,
2, 71, :_reduce_none,
2, 72, :_reduce_57,
4, 72, :_reduce_58,
3, 56, :_reduce_59,
1, 56, :_reduce_60,
1, 73, :_reduce_61,
3, 73, :_reduce_62,
1, 67, :_reduce_63,
3, 67, :_reduce_64,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
1, 75, :_reduce_none,
3, 49, :_reduce_68,
1, 70, :_reduce_none,
2, 70, :_reduce_70,
1, 74, :_reduce_none,
1, 74, :_reduce_none,
1, 74, :_reduce_none,
1, 50, :_reduce_none,
3, 50, :_reduce_none,
1, 51, :_reduce_76,
2, 51, :_reduce_77,
3, 52, :_reduce_78,
4, 53, :_reduce_79,
2, 53, :_reduce_80,
0, 77, :_reduce_none,
5, 77, :_reduce_82,
1, 78, :_reduce_none,
1, 78, :_reduce_none,
1, 54, :_reduce_85,
2, 55, :_reduce_86,
0, 79, :_reduce_none,
3, 79, :_reduce_none,
0, 80, :_reduce_none,
3, 80, :_reduce_90,
1, 76, :_reduce_none,
1, 76, :_reduce_none,
1, 76, :_reduce_none,
1, 76, :_reduce_none,
1, 76, :_reduce_none,
1, 76, :_reduce_none,
1, 76, :_reduce_none ]

Racc_reduce_n = 98

Racc_shift_n = 164

Racc_action_table = [
     8,     2,    15,     1,     6,     5,    13,     4,    19,     3,
     4,     6,     2,     8,    12,    10,    18,     9,     9,    12,
    16,    11,     7,    14,    14,    13,     5,    15,     3,    16,
    10,    18,    17,    17,    -1,   -98,    37,    20,    -1,   -98,
    31,    21,    27,    24,    30,    25,    33,    29,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    31,    21,    27,    24,    30,    25,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    31,    21,    27,    24,    30,    25,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    31,    21,    27,    24,    30,    25,    33,    29,
    36,    33,    20,    32,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    33,    47,    -1,   -98,     0,    49,
    -1,   -98,    20,   -19,    21,    52,    -1,   -98,    31,    21,
    27,    24,    30,    25,    33,    29,    36,    33,    20,    32,
    29,    31,    28,    34,    21,    37,    24,    36,    -1,   -98,
    31,    21,    27,    24,    30,    25,    36,    33,    20,    32,
    29,    31,    28,    34,    21,    37,    24,    36,    -1,   -98,
    37,    57,    -1,   -98,    33,    59,    -1,   -98,    20,    61,
    -1,   -98,    31,    21,    27,    24,    30,    25,    33,    29,
    36,    33,    20,    32,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    31,    21,    27,    24,    30,    25,
    33,    29,    36,    33,    20,    32,    29,    31,    28,    34,
    21,    37,    24,    36,    -1,   -98,    24,    69,    -1,   -25,
    37,    71,    -1,   -98,    11,    72,    -1,   -98,    -1,   -13,
    38,    73,    -1,   -81,    -1,   -97,    22,   -61,    35,   -61,
    32,   -61,    34,   -61,     0,   -61,    25,   -61,    -1,   -69,
    35,    75,    25,    76,    -1,   -60,    -1,   -93,    -1,   -96,
    -1,   -51,    -1,    -7,    -1,   -71,    31,    21,    27,    24,
    30,    25,    36,    33,    20,    32,    29,    31,    25,    80,
    28,    34,    21,    37,    24,    36,    -1,   -98,    -1,   -50,
    -1,   -95,    -1,   -73,    -1,   -72,    -1,   -94,    31,    21,
    27,    24,    30,    25,    33,    29,    36,    33,    20,    32,
    29,    31,    28,    34,    21,    37,    24,    36,    -1,   -98,
    -1,   -92,    -1,   -91,    -1,   -61,    -1,   -17,    31,    21,
    27,    24,    30,    25,    36,    33,    20,    32,    29,    31,
    28,    34,     0,   -76,    21,    37,    24,    36,    -1,   -98,
    -1,   -11,    -1,   -47,    -1,   -46,    -1,    -5,    31,    21,
    27,    24,    23,    84,    30,    25,    33,    29,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    -1,   -43,    31,    21,    27,    24,    30,    25,
    36,    33,    20,    32,    29,    31,    34,    85,    25,    80,
    28,    34,    21,    37,    24,    36,    -1,   -98,    -1,    -3,
     0,    86,    -1,   -98,    -1,    -1,    20,    87,    -1,   -98,
    22,    88,    -1,   -98,    -1,   -16,    -1,   -69,    31,    21,
    27,    24,    30,    25,    36,    33,    20,    32,    29,    31,
    28,    34,    21,    37,    24,    36,    -1,   -74,    22,    89,
     0,   -10,    -1,   -98,    -1,   -85,    -1,   -14,    31,    21,
    27,    24,    30,    25,    36,    33,    20,    32,    29,    31,
    28,    34,    21,    37,    24,    36,    -1,   -98,    -1,    -8,
    35,    91,    -1,   -98,    -1,   -12,    -1,   -48,    22,    92,
     0,    -6,    -1,   -98,    22,    93,     0,    -4,    -1,   -98,
    -1,   -44,    -1,    -2,    27,    94,    -1,   -29,    31,    21,
    27,    24,    30,    25,    26,    97,    20,    99,    29,    31,
    28,    34,    21,    37,    24,    36,    -1,   -98,    -1,   -15,
    -1,   -87,    -1,    -9,    37,   102,    -1,   -98,    32,   103,
     0,   -80,    -1,   -98,    31,    21,    27,    24,    30,    25,
    36,    33,    20,    32,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    31,    21,    27,    24,    30,    25,
    26,    97,    20,    99,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    22,   106,    23,   107,    -1,   -98,
    34,   108,    -1,   -98,    31,    21,    27,    24,    30,    25,
    36,    33,    20,    32,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    31,    21,    27,    24,    30,    25,
    26,    97,    20,    99,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    -1,   -70,    -1,   -52,    -1,   -77,
    31,    21,    27,    24,    30,    25,    33,    29,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    -1,   -42,    -1,   164,    21,   112,    -1,   -98,
    -1,   -20,    31,    21,    27,    24,    30,    25,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    34,   114,    -1,   -98,    20,   115,    -1,   -98,
    31,    21,    27,    24,    30,    25,    33,    29,    36,    33,
    20,    32,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    31,    21,    27,    24,    30,    25,    33,    29,
    36,    33,    20,    32,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    31,    21,    27,    24,    30,    25,
    26,    97,    20,    99,    29,    31,    28,    34,    21,    37,
    24,    36,    -1,   -98,    28,   120,    -1,   -31,    35,   121,
    26,   122,    25,   123,    -1,   -26,    -1,   -66,    -1,   -65,
    -1,   -67,    -1,   -63,    32,   124,     0,   -86,    -1,   -98,
    -1,   -81,    37,   126,    -1,   -98,    -1,   -62,    35,   121,
    -1,   -59,    25,   127,    -1,   -98,    -1,   -56,    -1,   -55,
    34,   128,    -1,   -98,    35,   121,    -1,   -57,    22,    92,
    32,   129,    -1,   -98,    20,   130,    -1,   -98,    31,    21,
    27,    24,    30,    25,    36,    33,    20,    32,    29,    31,
    28,    34,    21,    37,    24,    36,    -1,   -75,    -1,   -68,
    -1,   -78,    -1,   -49,    -1,   -45,    35,   121,    -1,   -30,
    -1,   -33,    21,   132,    -1,   -98,    31,    21,    27,    24,
    30,    25,    26,    97,    20,    99,    29,    31,    28,    34,
    21,    37,    24,    36,    -1,   -98,    -1,   -28,    31,    21,
    27,    24,    30,    25,    26,    97,    20,    99,    29,    31,
    28,    34,    21,    37,    24,    36,    -1,   -98,    37,   136,
    -1,   -89,    32,   103,     0,   -79,    -1,   -98,    39,   137,
    -1,   -98,    31,    21,    27,    24,    30,    25,    26,    97,
    20,    99,    29,    31,    28,    34,    21,    37,    24,    36,
    -1,   -98,    -1,   -54,    -1,   -53,    20,   140,    -1,   -98,
    30,   141,    29,   142,    -1,   -35,    -1,   -32,    -1,   -64,
    35,   121,    -1,   -27,    -1,   -88,    39,   144,    -1,   -98,
    36,   146,    37,   147,    -1,   -98,    35,   121,    -1,   -58,
    21,   148,    -1,   -98,    23,   150,    -1,   -98,    33,    59,
    21,   152,    -1,   -98,    21,   153,    -1,   -98,    31,   154,
    -1,   -38,    36,   146,    37,   147,    -1,   -98,    -1,   -82,
    -1,   -84,    -1,   -83,    -1,   -23,    -1,   -18,    20,   157,
    -1,   -98,    -1,   -36,    -1,   -37,    -1,   -34,    31,    21,
    27,    24,    30,    25,    33,    29,    36,    33,    20,    32,
    29,    31,    28,    34,    21,    37,    24,    36,    -1,   -98,
    32,   159,     0,   -40,    -1,   -98,    -1,   -90,    23,   161,
    21,   -21,    -1,   -98,    -1,   -39,    20,   -19,    21,    52,
    -1,   -98,    -1,   -24,    20,   163,    -1,   -98,    -1,   -41,
    -1,   -22 ]

Racc_action_table_ptr = [
     0,    36,    40,    62,    82,   102,   124,   128,   132,   138,
   160,   180,   184,   188,   192,   214,   236,   240,   244,   248,
   250,   254,   256,   270,   276,   278,   280,   282,   284,   286,
   308,   310,   312,   314,   316,   318,   340,   342,   344,   346,
   348,   370,   372,   374,   376,   378,   402,   404,   428,   430,
   434,   436,   440,   444,   446,   448,   468,   474,   476,   478,
   498,   500,   504,   506,   508,   514,   520,   522,   524,   528,
   548,   550,   552,   554,   558,   564,   584,   604,   610,   614,
   634,   654,   656,   658,   660,   682,   684,   686,   690,   692,
   712,   716,   720,   742,   764,   784,   788,   796,   798,   800,
   802,   804,   810,   812,   816,   818,   822,   826,   828,   830,
   834,   838,   844,   848,   868,   870,   872,   874,   876,   880,
   882,   886,   906,   908,   928,   932,   938,   942,   962,   964,
   966,   970,   976,   978,   980,   984,   986,   990,   996,  1000,
  1004,  1008,  1014,  1018,  1022,  1028,  1030,  1032,  1034,  1036,
  1038,  1042,  1044,  1046,  1048,  1070,  1076,  1078,  1084,  1086,
  1092,  1094,  1098,  1100 ]


Racc_goto_table = [
    42,     7,    53,    19,    74,    22,    73,    23,    68,    26,
    48,    27,    76,    28,    56,    30,    70,    35,    74,    38,
    73,    23,    76,    28,    56,    39,    74,    40,    76,    28,
    51,    41,    74,    22,    73,    23,    69,    42,    68,    26,
    48,    43,    76,    28,    56,    30,    46,    44,    70,    45,
    68,    46,    44,    48,    41,    50,    57,    51,    74,    22,
    73,    23,    68,    26,    48,    53,    76,    28,    56,    30,
    70,    35,    74,    54,    76,    28,    70,    55,    50,    56,
    54,    58,    49,    60,    52,    62,    74,    22,    73,    23,
    68,    26,    48,    63,    76,    28,    56,    30,    70,    35,
    47,    64,    74,    22,    73,    23,    45,    65,    69,    42,
    68,    26,    48,    43,    76,    28,    56,    30,    46,    66,
    70,    45,    43,    67,    60,    68,    55,    70,    77,    74,
    74,    38,    73,    23,    72,    77,    76,    28,    56,    78,
    71,    79,    74,    81,    68,    82,    76,    28,    74,    83,
    76,    28,    74,    81,    68,    82,    76,    28,    74,    38,
    73,    23,    72,    77,    76,    28,    56,    78,    71,    79,
    74,    81,    76,    28,    74,    38,    73,    23,    76,    28,
    56,    90,    61,    95,    67,    96,    76,    98,    75,   100,
    79,   101,    74,   104,    76,    28,    67,   105,    76,    98,
    75,   100,    74,    38,    73,    23,    76,    28,    56,   109,
    67,   110,    76,    98,    75,   100,    74,    22,    73,    23,
    68,    26,    48,    63,    76,    28,    56,    30,    70,    35,
    47,   111,    74,    54,    76,    28,    70,   113,    74,    22,
    73,    23,    68,    26,    48,   116,    76,    28,    56,    30,
    70,    35,    74,    22,    73,    23,    69,    42,    68,    26,
    48,    43,    76,    28,    56,    30,    46,   117,    70,    45,
    67,   118,    76,    98,    75,   100,    62,   119,    77,   125,
    74,    81,    76,    28,    63,   131,    76,    98,    75,   133,
    67,   134,    76,    98,    75,   100,    80,   135,    67,   138,
    76,    98,    75,   100,    58,   139,    64,   143,    78,   145,
    59,   149,    49,   151,    65,   155,    78,   156,    74,    22,
    73,    23,    69,    42,    68,    26,    48,    43,    76,    28,
    56,    30,    46,   158,    70,    45,    66,   160,    41,   162,
    57,    51,    -1,    -1 ]

Racc_goto_table_ptr = [
     0,     2,     4,    18,    26,    32,    50,    -1,    54,    58,
    72,    80,    82,    84,    86,   102,   122,   126,    -1,    -1,
   128,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,
   148,    -1,    -1,    -1,    -1,   152,    -1,   158,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   170,    -1,    -1,    -1,   174,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,   184,
    -1,   190,    -1,    -1,    -1,   192,   196,    -1,    -1,   202,
   210,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,   232,
    -1,    -1,   238,   252,   270,   276,    -1,    -1,    -1,    -1,
    -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,   284,
    -1,   286,    -1,   290,   296,    -1,    -1,   298,    -1,    -1,
   304,   306,    -1,    -1,    -1,    -1,    -1,   308,    -1,   310,
    -1,   312,    -1,   314,   316,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   318,   336,    -1,    -1,    -1,   338,
    -1,    -1,    -1,    -1 ]


Racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :RefH => 10,
 :refs => 11,
 :KeyH => 12,
 :EncH => 13,
 :VersionH => 14,
 :CTypeH => 15,
 :CEncodingH => 16,
 :CDispositionH => 17,
 :Mbox => 18,
 :Spec => 19,
 :DIGIT => 20,
 :ATOM => 21,
 "," => 22,
 ":" => 23,
 :FROM => 24,
 "@" => 25,
 :DOMLIT => 26,
 :BY => 27,
 :VIA => 28,
 :WITH => 29,
 :ID => 30,
 :FOR => 31,
 ";" => 32,
 "<" => 33,
 ">" => 34,
 "." => 35,
 :QUOTED => 36,
 :TOKEN => 37,
 "/" => 38,
 "=" => 39 }

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

 module_eval( '', 'mailp.y', 16 ) {
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
 }

 # reduce 2 omitted

 # reduce 3 omitted

 module_eval( '', 'mailp.y', 19 ) {
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 20 ) {
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 21 ) {
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 22 ) {
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 23 ) {
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 24 ) {
  def _reduce_9( val, _values, result )
 @field.refs.replace val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 25 ) {
  def _reduce_10( val, _values, result )
 @field.keys.replace val[1]
   result
  end
 }

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 # reduce 15 omitted

 module_eval( '', 'mailp.y', 33 ) {
  def _reduce_16( val, _values, result )
        mb = val[1]
        @field.phrase = mb.phrase
        @field.setroute mb.route
        @field.local  = mb.local
        @field.domain = mb.domain
   result
  end
 }

 module_eval( '', 'mailp.y', 41 ) {
  def _reduce_17( val, _values, result )
        mb = val[1]
        @field.local  = mb.local
        @field.domain = mb.domain
   result
  end
 }

 module_eval( '', 'mailp.y', 51 ) {
  def _reduce_18( val, _values, result )
      t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
      result = (t + val[4] - val[5]).localtime
   result
  end
 }

 # reduce 19 omitted

 # reduce 20 omitted

 module_eval( '', 'mailp.y', 61 ) {
  def _reduce_21( val, _values, result )
 result = (result.to_i * 60 * 60) + (val[2].to_i * 60)
   result
  end
 }

 module_eval( '', 'mailp.y', 63 ) {
  def _reduce_22( val, _values, result )
 result = (result.to_i * 60 * 60) + (val[2].to_i * 60) + val[4].to_i
   result
  end
 }

 module_eval( '', 'mailp.y', 66 ) {
  def _reduce_23( val, _values, result )
 result = ::TMail.zonestr2i( val[0] ) * 60
   result
  end
 }

 module_eval( '', 'mailp.y', 71 ) {
  def _reduce_24( val, _values, result )
        @field.from  = val[0] if val[0]
        @field.by    = val[1] if val[1]
        @field.via   = val[2] if val[2]
        @field.with.replace val[3]
        @field.msgid = val[4] if val[4]
        @field.for_  = val[5] if val[5]
        @field.date  = val[6] if val[6]
   result
  end
 }

 # reduce 25 omitted

 module_eval( '', 'mailp.y', 84 ) {
  def _reduce_26( val, _values, result )
        result = val[1].join('.')
   result
  end
 }

 module_eval( '', 'mailp.y', 88 ) {
  def _reduce_27( val, _values, result )
        result = val[3].join('.')
   result
  end
 }

 module_eval( '', 'mailp.y', 92 ) {
  def _reduce_28( val, _values, result )
        result = val[1].join('.')
   result
  end
 }

 # reduce 29 omitted

 module_eval( '', 'mailp.y', 99 ) {
  def _reduce_30( val, _values, result )
        result = val[1].join('.')
   result
  end
 }

 # reduce 31 omitted

 module_eval( '', 'mailp.y', 106 ) {
  def _reduce_32( val, _values, result )
        result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 112 ) {
  def _reduce_33( val, _values, result )
        result = []
   result
  end
 }

 module_eval( '', 'mailp.y', 116 ) {
  def _reduce_34( val, _values, result )
        result.push val[2]
   result
  end
 }

 # reduce 35 omitted

 module_eval( '', 'mailp.y', 123 ) {
  def _reduce_36( val, _values, result )
        result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 127 ) {
  def _reduce_37( val, _values, result )
        result = val[1]
   result
  end
 }

 # reduce 38 omitted

 module_eval( '', 'mailp.y', 132 ) {
  def _reduce_39( val, _values, result )
 result = val[1].address
   result
  end
 }

 # reduce 40 omitted

 module_eval( '', 'mailp.y', 136 ) {
  def _reduce_41( val, _values, result )
 result = val[1]
   result
  end
 }

 # reduce 42 omitted

 module_eval( '', 'mailp.y', 142 ) {
  def _reduce_43( val, _values, result )
        @field.route.replace result.route
        @field.addr = result.addr
   result
  end
 }

 module_eval( '', 'mailp.y', 147 ) {
  def _reduce_44( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 148 ) {
  def _reduce_45( val, _values, result )
 result.push val[2]
   result
  end
 }

 # reduce 46 omitted

 # reduce 47 omitted

 module_eval( '', 'mailp.y', 153 ) {
  def _reduce_48( val, _values, result )
 result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 154 ) {
  def _reduce_49( val, _values, result )
 result.push val[2]
   result
  end
 }

 # reduce 50 omitted

 # reduce 51 omitted

 module_eval( '', 'mailp.y', 161 ) {
  def _reduce_52( val, _values, result )
        val[1].phrase = HFdecoder.decode( result )
        result = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 166 ) {
  def _reduce_53( val, _values, result )
 result = AddressGroup.new( result, val[2] )
   result
  end
 }

 module_eval( '', 'mailp.y', 173 ) {
  def _reduce_54( val, _values, result )
        result = val[2]
        result.route = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 178 ) {
  def _reduce_55( val, _values, result )
        result = val[1]
   result
  end
 }

 # reduce 56 omitted

 module_eval( '', 'mailp.y', 184 ) {
  def _reduce_57( val, _values, result )
 result = [ val[1] ]
   result
  end
 }

 module_eval( '', 'mailp.y', 185 ) {
  def _reduce_58( val, _values, result )
 result.push val[3]
   result
  end
 }

 module_eval( '', 'mailp.y', 188 ) {
  def _reduce_59( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
 }

 module_eval( '', 'mailp.y', 189 ) {
  def _reduce_60( val, _values, result )
 result = Address.new( result, nil )
   result
  end
 }

 module_eval( '', 'mailp.y', 194 ) {
  def _reduce_61( val, _values, result )
        result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 198 ) {
  def _reduce_62( val, _values, result )
        result.push val[2]
   result
  end
 }

 module_eval( '', 'mailp.y', 204 ) {
  def _reduce_63( val, _values, result )
        result = val
   result
  end
 }

 module_eval( '', 'mailp.y', 208 ) {
  def _reduce_64( val, _values, result )
        result.push val[2]
   result
  end
 }

 # reduce 65 omitted

 # reduce 66 omitted

 # reduce 67 omitted

 module_eval( '', 'mailp.y', 219 ) {
  def _reduce_68( val, _values, result )
        val[1] = val[1].addr
        result = val.join('')
   result
  end
 }

 # reduce 69 omitted

 module_eval( '', 'mailp.y', 225 ) {
  def _reduce_70( val, _values, result )
 result << ' ' << val[1]
   result
  end
 }

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

 # reduce 75 omitted

 module_eval( '', 'mailp.y', 249 ) {
  def _reduce_76( val, _values, result )
        @field.encrypter = val[0]
   result
  end
 }

 module_eval( '', 'mailp.y', 253 ) {
  def _reduce_77( val, _values, result )
        @field.encrypter = val[0]
        @field.keyword   = val[1]
   result
  end
 }

 module_eval( '', 'mailp.y', 260 ) {
  def _reduce_78( val, _values, result )
        @field.major = val[0].to_i
        @field.minor = val[2].to_i
   result
  end
 }

 module_eval( '', 'mailp.y', 267 ) {
  def _reduce_79( val, _values, result )
        @field.main = val[0]
        @field.sub  = val[2]
   result
  end
 }

 module_eval( '', 'mailp.y', 272 ) {
  def _reduce_80( val, _values, result )
        @field.main = val[0]
        @field.sub  = ''
   result
  end
 }

 # reduce 81 omitted

 module_eval( '', 'mailp.y', 280 ) {
  def _reduce_82( val, _values, result )
        @field.params[ val[2].downcase ] = val[4]
   result
  end
 }

 # reduce 83 omitted

 # reduce 84 omitted

 module_eval( '', 'mailp.y', 286 ) {
  def _reduce_85( val, _values, result )
 @field.encoding = val[0]
   result
  end
 }

 module_eval( '', 'mailp.y', 289 ) {
  def _reduce_86( val, _values, result )
 @field.disposition = val[0]
   result
  end
 }

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 module_eval( '', 'mailp.y', 297 ) {
  def _reduce_90( val, _values, result )
 @field.params[ val[0].downcase ] = val[2]
   result
  end
 }

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 # reduce 97 omitted

end

end   # module TMail

